/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.treelist.parts.entity;

import com.paterva.maltego.bookmarks.ui.BookmarkFactory;
import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.graph.selection.GraphSelection;
import com.paterva.maltego.graph.store.GraphStore;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.structure.GraphStructureReader;
import com.paterva.maltego.graph.store.structure.GraphStructureStore;
import com.paterva.maltego.graph.store.view.GraphModelViewMappings;
import com.paterva.maltego.graph.store.view.GraphStoreView;
import com.paterva.maltego.graph.store.view.GraphStoreViewRegistry;
import com.paterva.maltego.imgfactory.parts.PartImageHelper;
import com.paterva.maltego.treelist.lazy.LazyTreelistSettings;
import com.paterva.maltego.treelist.parts.PartNode;
import com.paterva.maltego.treelist.parts.PartsTable;
import com.paterva.maltego.treelist.parts.entity.EntityTable;
import com.paterva.maltego.util.IconSize;
import com.paterva.maltego.util.ui.GraphicsUtils;
import java.awt.Component;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;
import org.openide.util.Exceptions;

public class EntityHoverableIconRenderer
extends JLabel
implements TableCellRenderer {
    private static final Logger LOG = Logger.getLogger(EntityHoverableIconRenderer.class.getName());
    private final EntityTable _table;
    private final int _iconSize;
    private final EmptyBorder emptyBorder;
    private final EmptyBorder spacedBorder;

    public EntityHoverableIconRenderer(EntityTable table) {
        this.setOpaque(true);
        this._table = table;
        this._iconSize = LazyTreelistSettings.getDefault().getIconSize()[this._table.isSmall() ? 0 : 1];
        this.emptyBorder = new EmptyBorder(0, 0, 0, 0);
        this.spacedBorder = new EmptyBorder(0, 5, 0, 0);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value == null) {
            return this;
        }
        PartsTable partsTable = (PartsTable)((Object)table);
        PartNode partNode = (PartNode)value;
        GraphID graphID = this._table.getTreelistModel().getGraphID();
        EntityID entityID = (EntityID)partNode.getPartID();
        if (entityID == null || !this.entityExists(graphID, entityID)) {
            return new JPanel();
        }
        this.setText(null);
        this.setHorizontalAlignment(0);
        this.setBorder(this.emptyBorder);
        if (LOG.isLoggable(Level.FINE)) {
            try {
                GraphStoreView view = GraphStoreViewRegistry.getDefault().getDefaultView(graphID);
                GraphModelViewMappings mappings = view.getModelViewMappings();
                if (mappings.getViewEntity(entityID) == null) {
                    LOG.log(Level.FINE, "Entity: {0} {1} {2} {3}", new Object[]{entityID, mappings.isViewEntity(entityID), mappings.isModelEntity(entityID), mappings.getViewEntity(entityID)});
                }
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        column = table.convertColumnIndexToModel(column);
        boolean hovered = partsTable.isHovered(entityID, column);
        Icon icon = null;
        switch (column - 1) {
            case 0: {
                icon = this._table.isSmall() ? this.getSelectedIcon(partNode, hovered) : this.getInspectIcon(hovered);
                break;
            }
            case 1: {
                icon = this.getInspectIcon(hovered);
                break;
            }
            case 2: {
                try {
                    icon = PartImageHelper.getIcon((GraphID)graphID, (EntityID)entityID, (int)IconSize.TINY.getSize(), null);
                    if (!this.displayTypeNames()) break;
                    partNode.getPart().ifPresent(part -> {
                        String typeName = part.getTypeName();
                        this.setText(typeName);
                        this.setHorizontalAlignment(2);
                        this.setBorder(this.spacedBorder);
                    });
                }
                catch (GraphStoreException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                break;
            }
            case 3: {
                icon = this.getBookmarkIcon(partNode, hovered);
                break;
            }
            case 4: {
                icon = this.getPinIcon(partNode, hovered);
                break;
            }
            case 5: {
                icon = this.getCollectedIcon(partNode, hovered);
            }
        }
        this.setIcon(icon);
        if (isSelected) {
            this.setForeground(table.getSelectionForeground());
            this.setBackground(table.getSelectionBackground());
        } else {
            this.setForeground(table.getForeground());
            this.setBackground(table.getBackground());
        }
        return this;
    }

    private boolean entityExists(GraphID graphID, EntityID entityID) {
        boolean exists = false;
        try {
            GraphStore graphStore;
            GraphStoreRegistry registry = GraphStoreRegistry.getDefault();
            if (registry.isExistingAndOpen(graphID) && (graphStore = registry.forGraphID(graphID)) != null) {
                GraphStructureStore structureStore = graphStore.getGraphStructureStore();
                return structureStore.getStructureReader().exists(entityID);
            }
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return exists;
    }

    protected boolean displayTypeNames() {
        return false;
    }

    private Icon getPinIcon(PartNode<EntityID, MaltegoEntity> node, boolean hovered) {
        boolean pinned = false;
        try {
            GraphID graphID = this._table.getTreelistModel().getGraphID();
            EntityID entityID = node.getPartID();
            GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(graphID);
            GraphStructureReader structureReader = graphStore.getGraphStructureStore().getStructureReader();
            pinned = structureReader.getPinned(entityID);
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return GraphicsUtils.getPinIcon((int)this._iconSize, (boolean)pinned, (boolean)hovered, (boolean)false);
    }

    private Icon getBookmarkIcon(PartNode<EntityID, MaltegoEntity> partNode, boolean hovered) {
        EntityID entityID = partNode.getPartID();
        Optional entity = this._table.getTreelistModel().getModelPart(entityID, null);
        if (!entity.isPresent()) {
            return null;
        }
        int bookmark = ((MaltegoEntity)entity.get()).getBookmark();
        return BookmarkFactory.getDefault().getIcon(Integer.valueOf(bookmark), this._iconSize, hovered);
    }

    private Icon getCollectedIcon(PartNode<EntityID, MaltegoEntity> node, boolean hovered) {
        int count = 0;
        try {
            GraphID graphID = this._table.getTreelistModel().getGraphID();
            EntityID entityID = node.getPartID();
            GraphStoreView view = GraphStoreViewRegistry.getDefault().getDefaultView(graphID);
            GraphModelViewMappings mappings = view.getModelViewMappings();
            EntityID viewEntity = mappings.getViewEntity(entityID);
            if (viewEntity != null) {
                count = mappings.getModelEntities(viewEntity).size();
            }
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        int iconWidth = LazyTreelistSettings.getDefault().getIconWidth(this._table.isSmall(), count);
        return GraphicsUtils.getCollectedIcon((int)iconWidth, (int)this._iconSize, (int)count, (boolean)hovered, (boolean)false);
    }

    private Icon getSelectedIcon(PartNode<EntityID, MaltegoEntity> node, boolean hovered) {
        GraphID graphID = this._table.getTreelistModel().getGraphID();
        EntityID entityID = node.getPartID();
        GraphSelection selection = GraphSelection.forGraph((GraphID)graphID);
        boolean selected = selection.isSelectedInModel(entityID);
        return GraphicsUtils.getSelectedIcon((int)this._iconSize, (boolean)selected, (boolean)hovered);
    }

    private Icon getInspectIcon(boolean hovered) {
        return GraphicsUtils.getInspectIcon((int)this._iconSize, (boolean)hovered);
    }
}

