/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.collab.ui;

import com.paterva.maltego.chat.ChatRoomTopComponentRegistry;
import com.paterva.maltego.chatapi.ChatRoom;
import com.paterva.maltego.chatapi.ChatRoomCookie;
import com.paterva.maltego.collab.graph.GraphChatRoom;
import com.paterva.maltego.collab.ui.Bundle;
import com.paterva.maltego.collab.ui.SelectEntitiesListener;
import com.paterva.maltego.collab.ui.SelectLinksListener;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.graph.selection.GraphSelection;
import com.paterva.maltego.graph.wrapper.GraphIDProvider;
import com.paterva.maltego.ui.graph.GraphView;
import com.paterva.maltego.ui.graph.GraphViewCookie;
import com.paterva.maltego.ui.graph.actions.TopGraphSelectionContextAction;
import com.paterva.maltego.ui.graph.transactions.GraphTransactionHelper;
import com.paterva.maltego.util.output.MessageChunk;
import com.paterva.maltego.util.output.MessageLinkListener;
import com.paterva.maltego.util.output.OutputMessage;
import java.util.Collection;
import java.util.Set;
import org.openide.util.HelpCtx;
import org.openide.windows.TopComponent;
import yguard.A.J.SA;

public final class SelectedAction
extends TopGraphSelectionContextAction {
    public SelectedAction() {
        this.putValue("ShortDescription", "Send selection as a chat message");
    }

    public String getName() {
        return Bundle.CTL_SelectedAction();
    }

    protected String iconResource() {
        return "com/paterva/maltego/collab/resources/Highlight.png";
    }

    protected void actionPerformed(GraphView graphView) {
        TopComponent chatRoomTC = ChatRoomTopComponentRegistry.getDefault().getActiveChatRoomTopComponent();
        ChatRoom chatRoom = this.getChatRoom(chatRoomTC);
        if (chatRoom instanceof GraphChatRoom) {
            GraphChatRoom graphChatRoom = (GraphChatRoom)chatRoom;
            GraphViewCookie cookie = (GraphViewCookie)chatRoomTC.getLookup().lookup(GraphViewCookie.class);
            if (cookie != null) {
                Set selectedModelLinks;
                SA viewGraph = cookie.getGraphView().getViewGraph();
                GraphID graphID = GraphIDProvider.forGraph((SA)viewGraph);
                GraphSelection selection = GraphSelection.forGraph((GraphID)graphID);
                Set selectedModelEntities = selection.getSelectedModelEntities();
                if (!selectedModelEntities.isEmpty()) {
                    SelectEntitiesListener listener = new SelectEntitiesListener(graphChatRoom, selectedModelEntities);
                    String description = GraphTransactionHelper.getDescriptionForEntityIDs((GraphID)graphID, (Collection)selectedModelEntities, (boolean)false);
                    this.sendSelection(description, (MessageLinkListener)listener, chatRoom);
                }
                if (!(selectedModelLinks = selection.getSelectedModelLinks()).isEmpty()) {
                    SelectLinksListener listener = new SelectLinksListener(graphChatRoom, selectedModelLinks);
                    String description = GraphTransactionHelper.getDescriptionForLinkIDs((GraphID)graphID, (Collection)selectedModelLinks, (boolean)false);
                    this.sendSelection(description, (MessageLinkListener)listener, chatRoom);
                }
            }
        }
    }

    private void sendSelection(String description, MessageLinkListener listener, ChatRoom chatRoom) {
        OutputMessage msg = new OutputMessage();
        msg.addChunk(new MessageChunk(description, listener));
        chatRoom.sendChat(chatRoom.getClientUser(), msg);
    }

    private ChatRoom getChatRoom(TopComponent topComponent) {
        ChatRoomCookie chatRoomCookie;
        ChatRoom chatRoom = null;
        if (topComponent != null && (chatRoomCookie = (ChatRoomCookie)topComponent.getLookup().lookup(ChatRoomCookie.class)) != null) {
            chatRoom = chatRoomCookie.getChatRoom();
        }
        return chatRoom;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }
}

