/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.protocol.v2api;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.TypedPropertyBag;
import com.paterva.maltego.entity.api.EntityFactory;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.inheritance.InheritanceHelper;
import com.paterva.maltego.transform.descriptor.TransformDescriptor;
import com.paterva.maltego.transform.protocol.v2api.EntityTranslator;
import com.paterva.maltego.transform.protocol.v2api.LocalTransformExecutor;
import com.paterva.maltego.transform.protocol.v2api.V2TransformRunner;
import com.paterva.maltego.transform.protocol.v2api.messaging.AdditionalField;
import com.paterva.maltego.transform.protocol.v2api.messaging.EntityDescriptor;
import com.paterva.maltego.transform.protocol.v2api.messaging.MaltegoMessageWrapper;
import com.paterva.maltego.transform.protocol.v2api.messaging.MessagingHelper;
import com.paterva.maltego.transform.protocol.v2api.messaging.TransformResponse;
import com.paterva.maltego.transform.runner.api.TransformRunException;
import com.paterva.maltego.typing.Converter;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.descriptor.SpecRegistry;
import com.paterva.maltego.util.StringUtilities;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

class LocalTransformRunner
extends V2TransformRunner {
    private static final RequestProcessor _processor = new RequestProcessor("V2 Local Transform Throttle", 10, true);
    private String _command;
    private String _params;
    private File _workingDir;
    private boolean _debug;

    public LocalTransformRunner(GraphID graphID, TransformDescriptor transform, EntityFactory factory, EntityRegistry registry, String command) {
        super(graphID, transform, factory, registry);
        if (StringUtilities.isNullOrEmpty((String)command)) {
            throw new IllegalArgumentException("Command cannot be null");
        }
        this._command = command;
    }

    @Override
    protected MaltegoMessageWrapper runTransform(MaltegoEntity input) throws TransformRunException, IOException {
        String message = null;
        try {
            PropertyDescriptor valuePd = InheritanceHelper.getValueProperty((SpecRegistry)this.getRegistry(), (TypedPropertyBag)input, (boolean)true);
            String value = LocalTransformRunner.toString(input.getValue(valuePd), valuePd);
            String additionalFields = this.getAdditionalFields(input);
            String command = this._command;
            File workingDir = this._workingDir;
            ArrayList<String> params = new ArrayList<String>();
            if (!StringUtilities.isNullOrEmpty((String)this._params)) {
                Pattern regex = Pattern.compile("[^\\s\"']+|\"[^\"]*\"|'[^']*'");
                Matcher regexMatcher = regex.matcher(this._params);
                while (regexMatcher.find()) {
                    params.add(regexMatcher.group());
                }
            }
            if (value != null) {
                params.add(value);
            }
            if (additionalFields != null) {
                params.add(additionalFields);
            }
            boolean debug = this._debug;
            message = LocalTransformExecutor.getDefault().execute(command, workingDir, params, debug);
        }
        catch (InterruptedException ex) {
            TransformResponse.Notification notification = new TransformResponse.Notification();
            notification.setType("PartialError");
            notification.setValue("Transform " + this._command + " cancelled");
            TransformResponse msg = new TransformResponse();
            msg.getMessages().add(notification);
            return new MaltegoMessageWrapper(msg);
        }
        catch (TransformRunException ex) {
            throw ex;
        }
        catch (ExecutionException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            throw new TransformRunException(LocalTransformRunner.getInnermostException(ex).getMessage());
        }
        return MessagingHelper.read(message);
    }

    private static Throwable getInnermostException(Throwable t) {
        if (t.getCause() == null) {
            return t;
        }
        return LocalTransformRunner.getInnermostException(t.getCause());
    }

    private String getAdditionalFields(MaltegoEntity input) {
        EntityDescriptor desc = EntityTranslator.instance().translate(input, this.getRegistry());
        if (desc.getFields().isEmpty()) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        for (AdditionalField field : desc.getFields()) {
            buffer.append(field.getName());
            buffer.append("=");
            buffer.append(this.escape(field.getValue()));
            buffer.append("#");
        }
        return buffer.substring(0, buffer.length() - 1);
    }

    private static String toString(Object value, PropertyDescriptor pd) {
        if (value == null) {
            return null;
        }
        if (pd == null) {
            return value.toString();
        }
        return Converter.convertTo((Object)value, (Class)pd.getType());
    }

    public void setParameters(String params) {
        this._params = params;
    }

    public void setWorkingDir(File workingDir) {
        this._workingDir = workingDir;
    }

    public void setDebug(boolean debug) {
        this._debug = debug;
    }

    public String getCommand() {
        return this._command;
    }

    public void setCommand(String command) {
        this._command = command;
    }

    public String getParams() {
        return this._params;
    }

    public File getWorkingDir() {
        return this._workingDir;
    }

    public boolean isDebug() {
        return this._debug;
    }

    @Override
    protected RequestProcessor processor() {
        return _processor;
    }

    private String escape(String text) {
        if (text == null) {
            return null;
        }
        return text.replace("\\", "\\\\").replace("=", "\\=").replace("#", "\\#");
    }
}

