/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xlightweb.AbstractHttpConnection;
import org.xlightweb.IMessageWriter;

abstract class AbstractNetworkMessageWriter
implements IMessageWriter {
    private static final Logger LOG = Logger.getLogger(AbstractNetworkMessageWriter.class.getName());
    private AtomicBoolean isOpen = new AtomicBoolean(true);
    private final AbstractHttpConnection httpConnection;
    private final boolean destroyOnClose;

    public AbstractNetworkMessageWriter(AbstractHttpConnection httpConnection, boolean destroyOnClose) {
        this.httpConnection = httpConnection;
        this.destroyOnClose = destroyOnClose;
    }

    final AbstractHttpConnection getConnection() {
        return this.httpConnection;
    }

    final String getId() {
        return this.httpConnection.getId();
    }

    public final void close() throws IOException {
        if (this.isOpen.getAndSet(false)) {
            this.onClose(this.destroyOnClose);
        }
    }

    abstract void onClose(boolean var1) throws IOException;

    public final void destroy() {
        if (this.httpConnection == null) {
            return;
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("[" + this.getId() + "] destroying connection");
        }
        this.httpConnection.destroy();
    }

    public int getPendingWriteDataSize() {
        return this.httpConnection.getUnderlyingTcpConnection().getPendingWriteDataSize();
    }
}

