/*
 * Decompiled with CFR 0.152.
 */
package com.maltego.cloud.serializer;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.maltego.cloud.data.CloudAttachments;
import com.maltego.cloud.data.CloudGraphContent;
import com.maltego.cloud.data.CloudGraphContentMetadata;
import com.maltego.cloud.data.CloudGraphSchemaVersion;
import com.maltego.cloud.data.DisplayElements;
import com.maltego.cloud.data.Entity;
import com.maltego.cloud.data.Link;
import com.maltego.cloud.data.Property;
import com.maltego.cloud.serializer.NeoSpecialProperty;
import com.paterva.maltego.core.DisplayInformation;
import com.paterva.maltego.core.DisplayInformationCollection;
import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.Guid;
import com.paterva.maltego.core.LinkEntityIDs;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.MaltegoLink;
import com.paterva.maltego.core.OverlayDescriptor;
import com.paterva.maltego.entity.api.EntityFactory;
import com.paterva.maltego.entity.api.EntityPropTypeMapping;
import com.paterva.maltego.entity.api.LinkFactory;
import com.paterva.maltego.graph.store.GraphFactory;
import com.paterva.maltego.graph.store.GraphStore;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.structure.GraphStructureWriter;
import com.paterva.maltego.graph.wrapper.GraphStoreWriter;
import com.paterva.maltego.serializers.map.PartMapReader;
import com.paterva.maltego.typing.Converter;
import com.paterva.maltego.typing.DisplayDescriptor;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.TypeDescriptor;
import com.paterva.maltego.typing.TypeRegistry;
import com.paterva.maltego.typing.types.DateTime;
import com.paterva.maltego.util.StringUtilities;
import java.awt.Color;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NeoJsonReader {
    private static final Logger LOG = Logger.getLogger(NeoJsonReader.class.getName());
    private static final String ICON_PROPERTY_NAME_FROM_WEB = "reserved-entity-icon-overlay-url";
    private final PartMapReader partMapReader = new PartMapReader();
    private final ObjectMapper mapper = new ObjectMapper();
    private final Map<MaltegoEntity, CloudAttachments> attachmentProperties = new LinkedHashMap<MaltegoEntity, CloudAttachments>();
    private final Map<EntityID, Boolean> pinnedEntities = new LinkedHashMap<EntityID, Boolean>();
    private GraphID maltegoGraphID;
    private final GraphID cloudGraphID;
    private boolean editable;
    private final String cloudGraphVersion;
    private String graphName;
    private String schemaVersion;
    private CloudGraphContentMetadata contentMetadata;
    private boolean blockSaveToCloud = false;
    private final int maxLogCount = 5;
    private int nullOrEmptyCount = 0;
    private int exceptionCount = 0;
    private int resultingTypeCount = 0;
    private int compositesCount = 0;

    public NeoJsonReader(GraphID maltegoGraphID, GraphID cloudGraphID, boolean editable, String cloudGraphVersion) {
        this.maltegoGraphID = maltegoGraphID;
        this.cloudGraphID = cloudGraphID;
        this.editable = editable;
        this.cloudGraphVersion = cloudGraphVersion;
    }

    public GraphID getCloudGraphID() {
        return this.cloudGraphID;
    }

    public GraphID getMaltegoGraphID() {
        return this.maltegoGraphID;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public String getCloudGraphVersion() {
        return this.cloudGraphVersion;
    }

    public String getGraphName() {
        return this.graphName;
    }

    public void setGraphName(String graphName) {
        this.graphName = graphName;
    }

    public Map<MaltegoEntity, CloudAttachments> getAttachmentProperties() {
        return this.attachmentProperties;
    }

    public CloudGraphContentMetadata getContentMetadata() {
        return this.contentMetadata;
    }

    public String getSchemaVersion() {
        return this.schemaVersion;
    }

    public boolean readFromString(String graphJson) throws Exception {
        return (Boolean)this.readFromString(graphJson, null)[0];
    }

    @Deprecated
    public Object[] readFromString(String graphJson, EntityFactory unitTestEntityFactory) throws Exception {
        CloudGraphContent graph = (CloudGraphContent)this.mapper.readValue(graphJson, CloudGraphContent.class);
        this.schemaVersion = graph.getSchemaVersion();
        if (this.schemaVersion == null) {
            this.schemaVersion = CloudGraphSchemaVersion.SCHEMA_VERSION_0_0_0.toString();
        }
        this.graphName = graph.getName();
        this.contentMetadata = graph.getMetadata();
        if (unitTestEntityFactory == null) {
            GraphFactory.getDefault().createGraph(this.maltegoGraphID, false, false);
        }
        ArrayList<MaltegoEntity> entities = new ArrayList<MaltegoEntity>();
        ArrayList<Guid> entityIds = new ArrayList<Guid>();
        for (Entity entity : graph.getEntities()) {
            MaltegoEntity maltegoEntity = unitTestEntityFactory == null ? this.fromDto(entity, EntityFactory.getDefault()) : this.fromDto(entity, unitTestEntityFactory);
            entities.add(maltegoEntity);
            entityIds.add(maltegoEntity.getID());
        }
        if (this.blockSaveToCloud) {
            this.maltegoGraphID = GraphID.create();
            GraphFactory.getDefault().createGraph(this.maltegoGraphID, false, false);
            if (this.editable) {
                this.editable = false;
            }
        }
        if (unitTestEntityFactory == null) {
            GraphStoreWriter.initForCloud((GraphID)this.maltegoGraphID);
            GraphStoreWriter.addEntities((GraphID)this.maltegoGraphID, entities);
        }
        LinkedHashMap<MaltegoLink, LinkEntityIDs> links = new LinkedHashMap<MaltegoLink, LinkEntityIDs>();
        for (Link link : graph.getLinks()) {
            MaltegoLink maltegoLink = this.fromDto(link);
            EntityID from = EntityID.parse((String)link.getFromId());
            EntityID to = EntityID.parse((String)link.getToId());
            LinkEntityIDs entityIDs = new LinkEntityIDs(from, to);
            if (entityIds.contains(from) && entityIds.contains(to)) {
                links.put(maltegoLink, entityIDs);
                continue;
            }
            LOG.log(Level.WARNING, "One or both of the entities not found: {0}, {1}", new Object[]{from, to});
        }
        if (unitTestEntityFactory == null) {
            GraphStoreWriter.addLinks((GraphID)this.maltegoGraphID, links);
            GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(this.maltegoGraphID);
            if (!this.pinnedEntities.isEmpty()) {
                try {
                    GraphStructureWriter structureWriter = graphStore.getGraphStructureStore().getStructureWriter();
                    structureWriter.setPinned(this.pinnedEntities);
                }
                catch (GraphStoreException ex) {
                    LOG.log(Level.WARNING, "Could not set pinned entities: {0}", ex.getMessage());
                }
            }
            graphStore.refresh();
            return new Object[]{this.blockSaveToCloud};
        }
        return new Object[]{entities, links};
    }

    private MaltegoEntity fromDto(Entity entity, EntityFactory entityFactory) throws Exception {
        EntityID entityId = EntityID.parse((String)entity.getId());
        String type = entity.getType();
        MaltegoEntity maltegoEntity = entityFactory.createInstance(type, false, entityId, false);
        List<Property> properties = entity.getProperties();
        for (Property property : properties) {
            if (NeoSpecialProperty.ATTACHMENTS.getId().equals(property.getType())) {
                Object value2 = property.getValue();
                CloudAttachments atts = (CloudAttachments)this.mapper.convertValue(value2, CloudAttachments.class);
                this.attachmentProperties.put(maltegoEntity, atts);
                continue;
            }
            if (this.isSpecialProperty(property, MaltegoEntity.class)) continue;
            DisplayDescriptor pd = this.fromDto(property);
            Object value3 = this.toClientValue((PropertyDescriptor)pd, property);
            maltegoEntity.setValue((PropertyDescriptor)pd, value3);
        }
        this.getSpecialProperty(properties, NeoSpecialProperty.VALUE).map(prop -> (String)prop.getValue()).filter(Objects::nonNull).map(propId -> maltegoEntity.getProperties().get(propId)).ifPresent(value -> maltegoEntity.setValueProperty(value));
        this.getSpecialProperty(properties, NeoSpecialProperty.DISPLAY_VALUE).map(prop -> (String)prop.getValue()).filter(Objects::nonNull).ifPresent(value -> maltegoEntity.setDisplayValueExpression(value));
        AtomicBoolean bookmarkSet = new AtomicBoolean(false);
        this.getSpecialProperty(properties, NeoSpecialProperty.BOOKMARK_FROM_WEB).ifPresent(prop -> {
            Object value = prop.getValue();
            if (value instanceof Number) {
                maltegoEntity.setBookmark(Integer.valueOf(((Number)value).intValue()));
                bookmarkSet.set(true);
            } else if (value instanceof String) {
                try {
                    maltegoEntity.setBookmark(Integer.valueOf((String)value));
                    bookmarkSet.set(true);
                }
                catch (NumberFormatException ex) {
                    LOG.log(Level.WARNING, "Could not parse bookmark# value: {0}", value);
                }
            }
        });
        if (!bookmarkSet.get()) {
            this.getSpecialProperty(properties, NeoSpecialProperty.BOOKMARK).ifPresent(prop -> {
                Object value = prop.getValue();
                if (value instanceof Number) {
                    maltegoEntity.setBookmark(Integer.valueOf(((Number)value).intValue()));
                } else if (value instanceof String) {
                    try {
                        maltegoEntity.setBookmark(Integer.valueOf((String)value));
                    }
                    catch (NumberFormatException ex) {
                        LOG.log(Level.WARNING, "Could not parse bookmark value: {0}", value);
                    }
                }
            });
        }
        AtomicBoolean notesSet = new AtomicBoolean(false);
        this.getSpecialProperty(properties, NeoSpecialProperty.NOTES_FROM_WEB).ifPresent(prop -> {
            maltegoEntity.setNotes((String)prop.getValue());
            notesSet.set(true);
        });
        if (!notesSet.get()) {
            this.getSpecialProperty(properties, NeoSpecialProperty.NOTES).ifPresent(prop -> maltegoEntity.setNotes((String)prop.getValue()));
        }
        this.getSpecialProperty(properties, NeoSpecialProperty.SHOW_NOTES).ifPresent(prop -> maltegoEntity.setShowNotes((Boolean)prop.getValue()));
        this.getSpecialProperty(properties, NeoSpecialProperty.WEIGHT).ifPresent(prop -> {
            Object value = prop.getValue();
            if (value instanceof Number) {
                try {
                    maltegoEntity.setWeight(Integer.valueOf(((Number)value).intValue()));
                }
                catch (IllegalArgumentException ex) {
                    LOG.log(Level.WARNING, "Could not parse weight value (1): {0}", value);
                }
            } else if (value instanceof String) {
                try {
                    maltegoEntity.setWeight(Integer.valueOf((String)value));
                }
                catch (NumberFormatException ex) {
                    LOG.log(Level.WARNING, "Could not parse weight value (2): {0}", value);
                }
            }
        });
        AtomicBoolean imageSet = new AtomicBoolean(false);
        this.getSpecialProperty(properties, NeoSpecialProperty.IMAGE).ifPresent(prop -> {
            Object value = prop.getValue();
            if (value instanceof String) {
                maltegoEntity.setImageExpression((String)value);
                imageSet.set(true);
            }
        });
        if (!imageSet.get()) {
            this.getProperty(properties, ICON_PROPERTY_NAME_FROM_WEB).ifPresent(prop -> {
                Object value = prop.getValue();
                if (value instanceof String) {
                    maltegoEntity.setImageExpression(ICON_PROPERTY_NAME_FROM_WEB);
                }
            });
        }
        AtomicBoolean displayInfoSet = new AtomicBoolean(false);
        List<DisplayElements> displayElements = entity.getDisplayElements();
        if (displayElements != null && !displayElements.isEmpty()) {
            DisplayInformationCollection displayInfo = new DisplayInformationCollection();
            for (DisplayElements displayElement : displayElements) {
                DisplayInformation info = new DisplayInformation(displayElement.getName(), displayElement.getValue());
                displayInfo.add(info);
            }
            maltegoEntity.setDisplayInformation(displayInfo);
            displayInfoSet.set(true);
        }
        if (!displayInfoSet.get()) {
            this.getSpecialProperty(properties, NeoSpecialProperty.DISPLAY_INFO).ifPresent(prop -> {
                DisplayInformationCollection displayInfo = new DisplayInformationCollection();
                ArrayList displayInfoData = (ArrayList)prop.getValue();
                for (LinkedHashMap entry : displayInfoData) {
                    DisplayInformation info = new DisplayInformation((String)entry.get("name"), (String)entry.get("value"));
                    displayInfo.add(info);
                }
                maltegoEntity.setDisplayInformation(displayInfo);
            });
        }
        this.getSpecialProperty(properties, NeoSpecialProperty.OVERLAYS).ifPresent(prop -> {
            ArrayList overlays = new ArrayList();
            try {
                overlays = (ArrayList)prop.getValue();
            }
            catch (ClassCastException ex) {
                LOG.log(Level.WARNING, "Could not parse overlays value: {0}", prop.getValue());
            }
            overlays.forEach(overlay -> {
                String[] positionWords = ((String)overlay.get("position")).split("_");
                String positionCode = String.valueOf(positionWords[0].charAt(0));
                if (positionWords.length == 2) {
                    positionCode = positionCode + positionWords[1].charAt(0);
                }
                OverlayDescriptor overlayDescriptor = new OverlayDescriptor((String)overlay.get("propertyName"), positionCode, (String)overlay.get("type"));
                maltegoEntity.addOverlay(overlayDescriptor);
            });
        });
        this.getSpecialProperty(properties, NeoSpecialProperty.PINNED_FROM_WEB).ifPresent(prop -> {
            Object value = prop.getValue();
            if (value instanceof Boolean) {
                this.pinnedEntities.put((EntityID)maltegoEntity.getID(), (Boolean)value);
            } else if (value instanceof String) {
                try {
                    this.pinnedEntities.put((EntityID)maltegoEntity.getID(), Boolean.valueOf((String)value));
                }
                catch (Exception ex) {
                    LOG.log(Level.WARNING, "Could not parse pinned value: {0}", value);
                }
            }
        });
        return maltegoEntity;
    }

    private MaltegoLink fromDto(Link link) throws Exception {
        LinkID linkId = LinkID.parse((String)link.getId());
        List<Property> properties = link.getProperties();
        boolean isTransformLink = this.getSpecialProperty(properties, NeoSpecialProperty.TRANSFORM_ID).isPresent();
        String type = isTransformLink ? "maltego.link.transform-link" : "maltego.link.manual-link";
        MaltegoLink maltegoLink = LinkFactory.getDefault().createInstance(type, linkId, false);
        for (Property property : properties) {
            if (this.isSpecialProperty(property, MaltegoLink.class)) continue;
            DisplayDescriptor pd = this.fromDto(property);
            Object value = this.toClientValue((PropertyDescriptor)pd, property);
            maltegoLink.setValue((PropertyDescriptor)pd, value);
        }
        AtomicBoolean colorSet = new AtomicBoolean(false);
        this.getSpecialProperty(properties, NeoSpecialProperty.COLOR_FROM_WEB).map(prop -> (Color)Converter.convert((Object)prop.getValue(), Color.class)).ifPresent(color -> {
            maltegoLink.setColor(color);
            colorSet.set(true);
        });
        if (!colorSet.get()) {
            this.getSpecialProperty(properties, NeoSpecialProperty.COLOR).map(prop -> (Color)Converter.convert((Object)prop.getValue(), Color.class)).ifPresent(color -> maltegoLink.setColor(color));
        }
        String labelPropertyId = isTransformLink ? "maltego.link.label" : "maltego.link.manual.type";
        AtomicBoolean labelSet = new AtomicBoolean(false);
        this.getSpecialProperty(properties, NeoSpecialProperty.LABEL_FROM_WEB).ifPresent(prop -> {
            this.setProperty(maltegoLink, labelPropertyId, prop.getValue());
            labelSet.set(true);
        });
        if (!labelSet.get()) {
            this.getSpecialProperty(properties, NeoSpecialProperty.LABEL).ifPresent(prop -> this.setProperty(maltegoLink, labelPropertyId, prop.getValue()));
        }
        this.getSpecialProperty(properties, NeoSpecialProperty.DESCRIPTION).ifPresent(prop -> this.setProperty(maltegoLink, "maltego.link.manual.description", prop.getValue()));
        this.getSpecialProperty(properties, NeoSpecialProperty.SHOW_LABEL).ifPresent(prop -> {
            Object value = prop.getValue();
            if (value instanceof Number) {
                maltegoLink.setShowLabel(((Number)value).intValue());
            } else if (value instanceof String) {
                try {
                    maltegoLink.setShowLabel(Integer.parseInt((String)value));
                }
                catch (NumberFormatException ex) {
                    LOG.log(Level.WARNING, "Could not parse show label: {0}", value);
                }
            }
        });
        AtomicBoolean styleSet = new AtomicBoolean(false);
        this.getSpecialProperty(properties, NeoSpecialProperty.STYLE_FROM_WEB).ifPresent(prop -> {
            Object value = prop.getValue();
            if (value instanceof Number) {
                maltegoLink.setStyle(Integer.valueOf(((Number)value).intValue()));
                styleSet.set(true);
            } else if (value instanceof String) {
                try {
                    maltegoLink.setStyle(Integer.valueOf((String)value));
                    styleSet.set(true);
                }
                catch (NumberFormatException ex) {
                    LOG.log(Level.WARNING, "Could not parse style value: {0}", value);
                }
            }
        });
        if (!styleSet.get()) {
            this.getSpecialProperty(properties, NeoSpecialProperty.STYLE).ifPresent(prop -> {
                Object value = prop.getValue();
                if (value instanceof Number) {
                    maltegoLink.setStyle(Integer.valueOf(((Number)value).intValue()));
                } else if (value instanceof String) {
                    try {
                        maltegoLink.setStyle(Integer.valueOf((String)value));
                    }
                    catch (NumberFormatException ex) {
                        LOG.log(Level.WARNING, "Could not parse style value: {0}", value);
                    }
                }
            });
        }
        AtomicBoolean thicknessSet = new AtomicBoolean(false);
        this.getSpecialProperty(properties, NeoSpecialProperty.THICKNESS_FROM_WEB).ifPresent(prop -> {
            Object value = prop.getValue();
            if (value instanceof Number) {
                maltegoLink.setThickness(Integer.valueOf(((Number)value).intValue()));
                thicknessSet.set(true);
            } else if (value instanceof String) {
                try {
                    maltegoLink.setThickness(Integer.valueOf((String)value));
                    thicknessSet.set(true);
                }
                catch (NumberFormatException ex) {
                    LOG.log(Level.WARNING, "Could not parse thickness value: {0}", value);
                }
            }
        });
        if (!thicknessSet.get()) {
            this.getSpecialProperty(properties, NeoSpecialProperty.THICKNESS).ifPresent(prop -> {
                Object value = prop.getValue();
                if (value instanceof Number) {
                    maltegoLink.setThickness(Integer.valueOf(((Number)value).intValue()));
                } else if (value instanceof String) {
                    try {
                        maltegoLink.setThickness(Integer.valueOf((String)value));
                    }
                    catch (NumberFormatException ex) {
                        LOG.log(Level.WARNING, "Could not parse thickness value: {0}", value);
                    }
                }
            });
        }
        this.getSpecialProperty(properties, NeoSpecialProperty.TRANSFORM_ID).ifPresent(prop -> this.setProperty(maltegoLink, "maltego.link.transform.name", prop.getValue()));
        this.getSpecialProperty(properties, NeoSpecialProperty.TRANSFORM_NAME).ifPresent(prop -> this.setProperty(maltegoLink, "maltego.link.transform.display-name", prop.getValue()));
        this.getSpecialProperty(properties, NeoSpecialProperty.TRANSFORM_VERSION).ifPresent(prop -> this.setProperty(maltegoLink, "maltego.link.transform.version", prop.getValue()));
        this.getSpecialProperty(properties, NeoSpecialProperty.TRANSFORM_DATE).ifPresent(prop -> this.setProperty(maltegoLink, "maltego.link.transform.run-date", prop.getValue()));
        return maltegoLink;
    }

    private boolean isSpecialProperty(Property property, Class target) {
        Optional<NeoSpecialProperty> prop = NeoSpecialProperty.get(property.getId());
        return prop.isPresent() && prop.get().getTarget().equals(target);
    }

    private Optional<Property> getSpecialProperty(List<Property> properties, NeoSpecialProperty specialProperty) {
        return this.getProperty(properties, specialProperty.getId());
    }

    private Optional<Property> getProperty(List<Property> properties, String propertyId) {
        return properties.stream().filter(prop -> prop.getId().equals(propertyId)).findAny();
    }

    private void setProperty(MaltegoLink link, String propertyId, Object value) {
        try {
            PropertyDescriptor property = link.getProperties().get(propertyId);
            value = this.toClientValue(property, value);
            link.setValue(property, value);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private DisplayDescriptor fromDto(Property property) {
        String propType;
        String id = property.getId();
        String displayName = property.getDisplayName();
        TypeRegistry typeRegistry = TypeRegistry.getDefault();
        TypeDescriptor clientType = typeRegistry.getType(propType = property.getType());
        if (clientType == null) {
            boolean fallbackToString;
            String v2PropType;
            boolean isArray;
            block10: {
                Object value = property.getValue();
                isArray = value != null && value instanceof List;
                v2PropType = "string";
                fallbackToString = false;
                try {
                    v2PropType = EntityPropTypeMapping.getDefault().getV2PropTypeName(propType, isArray, false, new Object[]{value});
                    if (StringUtilities.isNullOrEmpty((String)v2PropType)) {
                        fallbackToString = true;
                        if (this.nullOrEmptyCount < 5) {
                            LOG.log(Level.WARNING, "NullOrEmpty: Could not map property of type: {0}, isArray: {1}, id: {2}, displayName: {3}, v2PropType: {4}", new Object[]{propType, isArray, id, displayName, v2PropType});
                            ++this.nullOrEmptyCount;
                        }
                    }
                }
                catch (Exception ex) {
                    fallbackToString = true;
                    if (this.exceptionCount >= 5) break block10;
                    LOG.log(Level.WARNING, "Exception: Could not map property of type: {0}, isArray: {1}, id: {2}, displayName: {3}, v2PropType: {4}", new Object[]{propType, isArray, id, displayName, v2PropType});
                    ++this.exceptionCount;
                }
            }
            if (fallbackToString) {
                if ("ENTITY[]".equalsIgnoreCase(propType) || "ENTITY".equalsIgnoreCase(propType)) {
                    this.blockSaveToCloud = true;
                    if (this.compositesCount < 5) {
                        LOG.log(Level.WARNING, "Composite: Could not map property of type: {0}, isArray: {1}, id: {2}, displayName: {3}, v2PropType: {4}", new Object[]{propType, isArray, id, displayName, v2PropType});
                        ++this.compositesCount;
                    }
                }
                v2PropType = "string";
                property.setType("STRING");
            }
            if (isArray) {
                v2PropType = v2PropType + "[]";
            }
            if (fallbackToString && this.resultingTypeCount < 5) {
                LOG.log(Level.INFO, "Resulting type: {0}", v2PropType);
                ++this.resultingTypeCount;
            }
            clientType = typeRegistry.getType(v2PropType);
        }
        Class type = clientType.getType();
        DisplayDescriptor result = new DisplayDescriptor(type, id, displayName);
        return result;
    }

    private Object toClientValue(PropertyDescriptor pd, Property property) throws Exception {
        Object value = property.getValue();
        return this.toClientValue(pd, value);
    }

    private Object toClientValue(PropertyDescriptor pd, Object value) throws Exception {
        TypeDescriptor type = TypeRegistry.getDefault().getType(pd.getType());
        if (value instanceof List) {
            List list = (List)value;
            Object[] valueArr = list.toArray();
            value = Converter.changeArrayType((Object)valueArr, type.getType().getComponentType(), (boolean)true);
        } else if (type != null) {
            String typeName = type.getTypeName();
            if ("timespan".equals(typeName)) {
                if (value == null) {
                    value = null;
                } else if (value instanceof Integer) {
                    value = (long)((Integer)value).intValue();
                }
            } else if ("date".equals(typeName)) {
                if (value == null) {
                    value = null;
                } else if (value instanceof Long) {
                    value = Long.toString((Long)value);
                }
            } else if ("url".equals(typeName)) {
                if (value == null) {
                    return null;
                }
                if (value instanceof String && StringUtilities.isNullOrEmpty((String)((String)value))) {
                    return null;
                }
            } else if ("datetime".equals(typeName)) {
                if (value == null) {
                    value = null;
                } else if (value instanceof String) {
                    value = StringUtilities.isNullOrEmpty((String)((String)value)) ? null : Long.valueOf(DateTime.parse((String)((String)value)).getTime());
                }
            } else if ("double".equals(typeName) && value instanceof String && "<empty>".equals(value)) {
                value = null;
            }
        }
        value = this.partMapReader.translatePropertyValue(type, value);
        return value;
    }
}

