/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.tools;

import java.awt.event.MouseEvent;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.constructors.ObjectConstructor;
import rene.zirkel.objects.PointObject;
import rene.zirkel.objects.PrimitiveCircleObject;

public class SetRangeTool
extends ObjectConstructor {
    ObjectConstructor OC;
    PrimitiveCircleObject C;
    PointObject P1;
    PointObject P2;

    public SetRangeTool(ZirkelCanvas zirkelCanvas, PrimitiveCircleObject primitiveCircleObject, ObjectConstructor objectConstructor) {
        this.C = primitiveCircleObject;
        this.OC = objectConstructor;
        this.C.setSelected(true);
        zirkelCanvas.repaint();
    }

    public void mousePressed(MouseEvent mouseEvent, ZirkelCanvas zirkelCanvas) {
        if (this.P1 == null) {
            this.P1 = zirkelCanvas.selectPoint(mouseEvent.getX(), mouseEvent.getY());
            if (this.P1 != null) {
                this.P1.setSelected(true);
                this.showStatus(zirkelCanvas);
                zirkelCanvas.repaint();
            }
        } else {
            this.P2 = zirkelCanvas.selectPoint(mouseEvent.getX(), mouseEvent.getY());
            if (this.P2 == null) {
                return;
            }
            this.C.setRange(this.P1.getName(), this.P2.getName());
            this.reset(zirkelCanvas);
        }
    }

    public void mouseMoved(MouseEvent mouseEvent, ZirkelCanvas zirkelCanvas, boolean bl) {
        zirkelCanvas.indicatePointObjects(mouseEvent.getX(), mouseEvent.getY());
    }

    public void showStatus(ZirkelCanvas zirkelCanvas) {
        if (this.P1 == null) {
            zirkelCanvas.showStatus(Zirkel.name("message.range.first"));
        } else {
            zirkelCanvas.showStatus(Zirkel.name("message.range.second"));
        }
    }

    public void reset(ZirkelCanvas zirkelCanvas) {
        super.reset(zirkelCanvas);
        zirkelCanvas.setTool(this.OC);
        zirkelCanvas.validate();
        zirkelCanvas.repaint();
    }
}

