(********************************************************************)
(*                                                                  *)
(*  The Why3 Verification Platform   /   The Why3 Development Team  *)
(*  Copyright 2010-2022 --  Inria - CNRS - Paris-Saclay University  *)
(*                                                                  *)
(*  This software is distributed under the terms of the GNU Lesser  *)
(*  General Public License version 2.1, with the special exception  *)
(*  on linking described in file LICENSE.                           *)
(*                                                                  *)
(********************************************************************)

(* This file is generated by Why3's Coq-realize driver *)
(* Beware! Only edit allowed sections below    *)
Require Import BuiltIn.
Require BuiltIn.

(* Why3 goal *)
Lemma andb'def :
  forall (x:Init.Datatypes.bool) (y:Init.Datatypes.bool),
  ((Init.Datatypes.andb x y) =
   match x with
   | Init.Datatypes.true => y
   | Init.Datatypes.false => Init.Datatypes.false
   end).
Proof.
intros x y.
apply refl_equal.
Qed.

(* Why3 goal *)
Lemma orb'def :
  forall (x:Init.Datatypes.bool) (y:Init.Datatypes.bool),
  ((Init.Datatypes.orb x y) =
   match x with
   | Init.Datatypes.false => y
   | Init.Datatypes.true => Init.Datatypes.true
   end).
Proof.
intros x y.
apply refl_equal.
Qed.

(* Why3 goal *)
Lemma notb'def :
  forall (x:Init.Datatypes.bool),
  ((Init.Datatypes.negb x) =
   match x with
   | Init.Datatypes.false => Init.Datatypes.true
   | Init.Datatypes.true => Init.Datatypes.false
   end).
Proof.
intros x.
apply refl_equal.
Qed.

(* Why3 goal *)
Lemma xorb'def :
  forall (x:Init.Datatypes.bool) (y:Init.Datatypes.bool),
  ((Init.Datatypes.xorb x y) =
   match x with
   | Init.Datatypes.false => y
   | Init.Datatypes.true => Init.Datatypes.negb y
   end).
Proof.
intros x y.
destruct x; destruct y; auto.
Qed.

(* Why3 goal *)
Lemma implb'def :
  forall (x:Init.Datatypes.bool) (y:Init.Datatypes.bool),
  ((Init.Datatypes.implb x y) =
   match x with
   | Init.Datatypes.false => Init.Datatypes.true
   | Init.Datatypes.true => y
   end).
Proof.
now intros [|] [|].
Qed.

