/*
 * ===========================
 * VDK Visual Development Kit
 * Version 2.0
 * February 2001
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
*/

#include <vdk/rawpixbuf.h>
#include <vdk/forms.h>
#include <cstring>
/*
constructor
*/
VDKPixbuf::VDKPixbuf(VDKObject* owner, const char* pixfile):
  VDKRawObject(owner)
{
    pixbuf =  gdk_pixbuf_new_from_file(pixfile,NULL);
    if(pixbuf)    
      {
          w = gdk_pixbuf_get_width(pixbuf);
          h = gdk_pixbuf_get_height(pixbuf);
      }
    else
      { w = -1; h = -1; }
}
/*
*/ 
VDKPixbuf::VDKPixbuf(VDKObject* owner,const char** pixdata):
  VDKRawObject(owner)
{
   pixbuf =   gdk_pixbuf_new_from_xpm_data (pixdata);
    if(pixbuf)    
      {
          w = gdk_pixbuf_get_width(pixbuf);
          h = gdk_pixbuf_get_height(pixbuf);
      }
}

/*
destructor
*/
VDKPixbuf::~VDKPixbuf()
{
if(pixbuf)
     gdk_pixbuf_unref(pixbuf);
}
