/*
 * ===========================
 * VDK Visual Development Kit
 * Version 0.4
 * October 1998
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
*/

#include "vdk/numentry.h"
#include "vdk/vdkobj.h"
#include "vdk/forms.h"
#include <cstring>
#include <gdk/gdkkeysyms.h>
/*
 */
int 
VDKNumericEntry::KeyEvent(GtkWidget *wid, GdkEventKey *ev, gpointer data)
{
  g_return_val_if_fail(wid != NULL,FALSE);
  g_return_val_if_fail(data != NULL,FALSE);
  switch(ev->keyval)
    {
    case GDK_Tab:
    case GDK_Linefeed:
    case GDK_Clear:
    case GDK_BackSpace:
    case GDK_Delete:
    case GDK_Right:
    case GDK_Left:
    case GDK_Return:
    case GDK_End:
    case GDK_Home:
    case '.':
    case ',':
    case '-':
      break;
    default:
      if(ev->keyval < 48 || ev->keyval > 57)
	return TRUE; //gtk_signal_emit_stop_by_name(GTK_OBJECT(wid),"key_press_event");
    }
  return FALSE;
}

/*
 */
VDKNumericEntry::VDKNumericEntry(VDKForm* owner, 
				  int maxLen, 
				  char* def):
  VDKEntry(owner,maxLen,def)
{
  gtk_signal_connect(GTK_OBJECT(widget),"key_press_event",
  	     GTK_SIGNAL_FUNC(VDKNumericEntry::KeyEvent),
  	     (gpointer) this);
}
/*
 */
VDKNumericEntry::~VDKNumericEntry() {}
