# Community References
Below is a list of additional resources from the community.

## Vulnderability Scanning

- [Detecting Spring4Shell with Trivy and Grype](https://youtu.be/mOfBcpJWwSs)

## CI/CD Pipelines

- [How to use Tekton to set up a CI pipeline with OpenShift Pipelines](https://www.redhat.com/architect/cicd-pipeline-openshift-tekton)
- [Continuous Container Vulnerability Testing with Trivy](https://semaphoreci.com/blog/continuous-container-vulnerability-testing-with-trivy)
- [Getting Started With Trivy and Jenkins](https://youtu.be/MWe01VdwuMA)
- [How to use Tekton to set up a CI pipeline with OpenShift Pipelines](https://www.redhat.com/architect/cicd-pipeline-openshift-tekton)

## Misconfiguration Scanning

- [Identifying Misconfigurations in your Terraform](https://youtu.be/cps1V5fOHtE)
- [How to write custom policies for Trivy](https://blog.ediri.io/how-to-write-custom-policies-for-trivy)

## SBOM, Attestation & related

- [Attesting Image Scans With Kyverno](https://neonmirrors.net/post/2022-07/attesting-image-scans-kyverno/)

## Trivy Kubernetes

- [Using Trivy Kubernetes in OVHCloud documentation.](https://docs.ovh.com/gb/en/kubernetes/installing-trivy/)

## Comparisons

- [the vulnerability remediation lifecycle of Alpine containers](https://ariadne.space/2021/06/08/the-vulnerability-remediation-lifecycle-of-alpine-containers/)
- [Open Source CVE Scanner Round-Up: Clair vs Anchore vs Trivy](https://boxboat.com/2020/04/24/image-scanning-tech-compared/)
- [Docker Image Security: Static Analysis Tool Comparison – Anchore Engine vs Clair vs Trivy](https://www.a10o.net/devsecops/docker-image-security-static-analysis-tool-comparison-anchore-engine-vs-clair-vs-trivy/)

### Evaluations

- [Istio evaluating to use Trivy](https://github.com/istio/release-builder/pull/687#issuecomment-874938417)
- [Research Spike: evaluate Trivy for scanning running containers](https://gitlab.com/gitlab-org/gitlab/-/issues/270888)