/*
 * SVG Salamander
 * Copyright (c) 2004, Mark McKay
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or 
 * without modification, are permitted provided that the following
 * conditions are met:
 *
 *   - Redistributions of source code must retain the above 
 *     copyright notice, this list of conditions and the following
 *     disclaimer.
 *   - Redistributions in binary form must reproduce the above
 *     copyright notice, this list of conditions and the following
 *     disclaimer in the documentation and/or other materials 
 *     provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE. 
 * 
 * Mark McKay can be contacted at mark@kitfox.com.  Salamander and other
 * projects can be found at http://www.kitfox.com
 *
 * Created on September 28, 2004, 9:56 PM
 */

package com.kitfox.svg.app;

/**
 *
 * @author  kitfox
 */
public class PlayerDialog extends javax.swing.JDialog implements PlayerThreadListener
{
    public static final long serialVersionUID = 1;
    
    PlayerThread thread;
    
    final SVGPlayer parent;
    
    /** Creates new form PlayerDialog */
    public PlayerDialog(SVGPlayer parent)
    {
        super(parent, false);
        initComponents();
        
        this.parent = parent;
        
        thread = new PlayerThread();
        thread.addListener(this);
        
        text_timeStepActionPerformed(null);
    }
    
    public void updateTime(double curTime, double timeStep, int playState)
    {
        if (playState == PlayerThread.PS_STOP) return;
        
        text_curTime.setText("" + (float)curTime);
        parent.updateTime(curTime);
//        text_timeStep.setText("" + (int)(1.0 / timeStep));
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents()
    {
        jPanel1 = new javax.swing.JPanel();
        bn_playBack = new javax.swing.JButton();
        bn_stop = new javax.swing.JButton();
        bn_playFwd = new javax.swing.JButton();
        jPanel2 = new javax.swing.JPanel();
        jPanel3 = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        text_curTime = new javax.swing.JTextField();
        bn_time0 = new javax.swing.JButton();
        jPanel4 = new javax.swing.JPanel();
        jLabel2 = new javax.swing.JLabel();
        text_timeStep = new javax.swing.JTextField();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setTitle("Player");
        addWindowListener(new java.awt.event.WindowAdapter()
        {
            @Override
            public void windowClosed(java.awt.event.WindowEvent evt)
            {
                formWindowClosed(evt);
            }
        });

        bn_playBack.setText("<");
        bn_playBack.setToolTipText("Play backwards");
        bn_playBack.addActionListener(new java.awt.event.ActionListener()
        {
            public void actionPerformed(java.awt.event.ActionEvent evt)
            {
                bn_playBackActionPerformed(evt);
            }
        });

        jPanel1.add(bn_playBack);

        bn_stop.setText("||");
        bn_stop.setToolTipText("Stop playback");
        bn_stop.addActionListener(new java.awt.event.ActionListener()
        {
            public void actionPerformed(java.awt.event.ActionEvent evt)
            {
                bn_stopActionPerformed(evt);
            }
        });

        jPanel1.add(bn_stop);

        bn_playFwd.setText(">");
        bn_playFwd.setToolTipText("Play Forwards");
        bn_playFwd.addActionListener(new java.awt.event.ActionListener()
        {
            public void actionPerformed(java.awt.event.ActionEvent evt)
            {
                bn_playFwdActionPerformed(evt);
            }
        });

        jPanel1.add(bn_playFwd);

        getContentPane().add(jPanel1, java.awt.BorderLayout.NORTH);

        jPanel2.setLayout(new javax.swing.BoxLayout(jPanel2, javax.swing.BoxLayout.Y_AXIS));

        jLabel1.setText("Cur Time");
        jPanel3.add(jLabel1);

        text_curTime.setHorizontalAlignment(javax.swing.JTextField.LEFT);
        text_curTime.setText("0");
        text_curTime.setPreferredSize(new java.awt.Dimension(100, 21));
        text_curTime.addActionListener(new java.awt.event.ActionListener()
        {
            public void actionPerformed(java.awt.event.ActionEvent evt)
            {
                text_curTimeActionPerformed(evt);
            }
        });
        text_curTime.addFocusListener(new java.awt.event.FocusAdapter()
        {
            @Override
            public void focusLost(java.awt.event.FocusEvent evt)
            {
                text_curTimeFocusLost(evt);
            }
        });

        jPanel3.add(text_curTime);

        bn_time0.setText("Time 0");
        bn_time0.setToolTipText("Reset time to first frame");
        bn_time0.addActionListener(new java.awt.event.ActionListener()
        {
            public void actionPerformed(java.awt.event.ActionEvent evt)
            {
                bn_time0ActionPerformed(evt);
            }
        });

        jPanel3.add(bn_time0);

        jPanel2.add(jPanel3);

        jLabel2.setText("Frames Per Second");
        jPanel4.add(jLabel2);

        text_timeStep.setHorizontalAlignment(javax.swing.JTextField.RIGHT);
        text_timeStep.setText("60");
        text_timeStep.setPreferredSize(new java.awt.Dimension(100, 21));
        text_timeStep.addActionListener(new java.awt.event.ActionListener()
        {
            public void actionPerformed(java.awt.event.ActionEvent evt)
            {
                text_timeStepActionPerformed(evt);
            }
        });
        text_timeStep.addFocusListener(new java.awt.event.FocusAdapter()
        {
            @Override
            public void focusLost(java.awt.event.FocusEvent evt)
            {
                text_timeStepFocusLost(evt);
            }
        });

        jPanel4.add(text_timeStep);

        jPanel2.add(jPanel4);

        getContentPane().add(jPanel2, java.awt.BorderLayout.CENTER);

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void bn_time0ActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_bn_time0ActionPerformed
    {//GEN-HEADEREND:event_bn_time0ActionPerformed
        thread.setCurTime(0);
    }//GEN-LAST:event_bn_time0ActionPerformed

    private void bn_playFwdActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_bn_playFwdActionPerformed
    {//GEN-HEADEREND:event_bn_playFwdActionPerformed
        thread.setPlayState(PlayerThread.PS_PLAY_FWD);
    }//GEN-LAST:event_bn_playFwdActionPerformed

    private void bn_stopActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_bn_stopActionPerformed
    {//GEN-HEADEREND:event_bn_stopActionPerformed
        thread.setPlayState(PlayerThread.PS_STOP);
    }//GEN-LAST:event_bn_stopActionPerformed

    private void bn_playBackActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_bn_playBackActionPerformed
    {//GEN-HEADEREND:event_bn_playBackActionPerformed
        thread.setPlayState(PlayerThread.PS_PLAY_BACK);
    }//GEN-LAST:event_bn_playBackActionPerformed

    private void formWindowClosed(java.awt.event.WindowEvent evt)//GEN-FIRST:event_formWindowClosed
    {//GEN-HEADEREND:event_formWindowClosed
//        thread.exit();
    }//GEN-LAST:event_formWindowClosed

    private void text_timeStepFocusLost(java.awt.event.FocusEvent evt)//GEN-FIRST:event_text_timeStepFocusLost
    {//GEN-HEADEREND:event_text_timeStepFocusLost
        text_timeStepActionPerformed(null);
    }//GEN-LAST:event_text_timeStepFocusLost

    private void text_timeStepActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_text_timeStepActionPerformed
    {//GEN-HEADEREND:event_text_timeStepActionPerformed
        try
        {
            int val = Integer.parseInt(text_timeStep.getText());
            thread.setTimeStep(1.0 / val);
        }
        catch (Exception e)
        {
        }
        
        double d = thread.getTimeStep();
        String newStrn = "" + (int)(1f / d);
        if (newStrn.equals(text_timeStep.getText())) return;
        text_timeStep.setText(newStrn);
        
//        text_timeStepActionPerformed(null);
    }//GEN-LAST:event_text_timeStepActionPerformed

    private void text_curTimeActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_text_curTimeActionPerformed
    {//GEN-HEADEREND:event_text_curTimeActionPerformed
        try
        {
            double val = Double.parseDouble(text_curTime.getText());
            thread.setCurTime(val);
        }
        catch (Exception e)
        {
        }
        
        double d = thread.getCurTime();
        text_curTime.setText("" + (float)d);
        
        text_timeStepActionPerformed(null);
    }//GEN-LAST:event_text_curTimeActionPerformed

    private void text_curTimeFocusLost(java.awt.event.FocusEvent evt)//GEN-FIRST:event_text_curTimeFocusLost
    {//GEN-HEADEREND:event_text_curTimeFocusLost
        text_curTimeActionPerformed(null);
    }//GEN-LAST:event_text_curTimeFocusLost
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton bn_playBack;
    private javax.swing.JButton bn_playFwd;
    private javax.swing.JButton bn_stop;
    private javax.swing.JButton bn_time0;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JPanel jPanel4;
    private javax.swing.JTextField text_curTime;
    private javax.swing.JTextField text_timeStep;
    // End of variables declaration//GEN-END:variables
    
}
