/*
	SRG - Squid Report Generator

	Report By User
		- Shows the Sites that a user visited
		- User could be a squid username, ip address, subnet
		
	Copyright 2005 University of Waikato

	This file is part of SRG.

	SRG is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	SRG is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with SRG; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

*/

#ifndef USERREPORT_H
#define USREREPORT_H

#include "srg.h"
#include "Report.h"
#include "SiteReport.h"


class UserReport : public Report {
	
	public:
		UserReport(char * user) : Report(user) {singleUserMode=false;}
		~UserReport();

		void generate_report(const char *);
		
		void process_line(const log_line *line);
		void updateStats();
		summary_info getStats();
 
		bool singleUserMode;
		
	private:
		SiteReport *findSite(char * site);
		list<SiteReport*> sites;
		
};

#endif // USREREPORT_H
