# :briefcase: &nbsp;  The Social-Engineer Toolkit (SET) &nbsp;  :briefcase:

Copyright 2020 The Social-Engineer Toolkit (SET)

Written by: David Kennedy (ReL1K) @HackingDave

Company: [TrustedSec](https://www.trustedsec.com)

DISCLAIMER: This is *only* for testing purposes and can only be used where strict consent has been given. Do not use this for illegal purposes, period.

Please read the LICENSE under readme/LICENSE for the licensing of SET. 


# :book: &nbsp; SET Tutorial &nbsp; :book:

For a full document on how to use SET, [visit the SET user manual](https://github.com/trustedsec/social-engineer-toolkit/raw/master/readme/User_Manual.pdf).


# :computer: &nbsp; Features &nbsp; :computer:


The Social-Engineer Toolkit is an open-source penetration testing framework designed for social engineering. SET has a number of custom attack vectors that allow you to make a believable attack quickly. SET is a product of TrustedSec, LLC – an information security consulting firm located in Cleveland, Ohio.


## Bugs and enhancements

For bug reports or enhancements, please open an [issue](https://github.com/trustedsec/social-engineer-toolkit/issues) here.


## Supported platforms


* Linux :penguin:
* Mac OS X :apple:

# :inbox_tray: &nbsp; Installation &nbsp; :inbox_tray:
## Resolve dependencies
*Ubuntu/Debian System*
=======
* Linux
* Mac OS X (experimental)

# Installation

## Install via requirements.txt

pip3 install -r requirements.txt
python setup.py 

## Install SET

*All OSs*

```bash
git clone https://github.com/trustedsec/social-engineer-toolkit/ setoolkit/
cd setoolkit
pip3 install -r requirements.txt
python setup.py
```
