//
//  Copyright (C) 2002-2018 Greg Landrum and Rational Discovery LLC
//
//   @@ All Rights Reserved @@
//  This file is part of the RDKit.
//  The contents are covered by the terms of the BSD license
//  which is included in the file license.txt, found at the root
//  of the RDKit source tree.
//

/*! \file RDKitBase.h

  \brief pulls in the core \c RDKit functionality

*/

#include <RDGeneral/export.h>
#ifndef _RDKIT_BASE_H
#define _RDKIT_BASE_H

#include <RDGeneral/Invariant.h>

#include <GraphMol/Atom.h>
#include <GraphMol/Bond.h>
#include <GraphMol/Conformer.h>
#include <GraphMol/GraphMol.h>
#include <GraphMol/MolOps.h>
#include <GraphMol/RingInfo.h>
#include <GraphMol/AtomIterators.h>
#include <GraphMol/BondIterators.h>
#include <GraphMol/PeriodicTable.h>
#include <GraphMol/SanitException.h>
#include <GraphMol/StereoGroup.h>

#endif
