/*
 * Decompiled with CFR 0.152.
 */
package analysis.results;

import analysis.results.BriefResult;
import data.Point;
import data.VarPairData;
import java.io.IOException;
import mine.core.MineParameters;

public class FullResult
extends BriefResult {
    protected float lastVal = Float.NaN;
    protected float fisher = Float.NaN;
    protected float pearson = Float.NaN;
    protected float KDE = Float.NaN;
    protected float signalToNoise = Float.NaN;
    protected float spearman = Float.NaN;
    protected int fisherFoundAt = Integer.MIN_VALUE;
    protected Point MICfoundAt = new Point(-2.1474836E9f, -2.1474836E9f);
    protected Point MASfoundAt = new Point(-2.1474836E9f, -2.1474836E9f);

    @Override
    public void construct(VarPairData xy, MineParameters p) {
        super.construct(xy, p);
        int[] fisherFoundAt_ = new int[]{Integer.MIN_VALUE};
        this.lastVal = this.m.lastValueOfRay(new Point(1.0f, 1.0f));
        this.signalToNoise = this.lastVal / this.m.maxValueAlongRay(new Point(1.0f, 1.0f));
        this.signalToNoise = Math.min(this.signalToNoise, 1.0f);
        this.fisher = xy.FisherTest(fisherFoundAt_);
        this.fisherFoundAt = fisherFoundAt_[0];
        this.KDE = xy.mutualInfoKDE(0.4f);
        this.spearman = xy.spearmanCorrelation();
        if (p.debug > 1) {
            try {
                p.debugOut.write("maxVal (=" + this.getMIC() + ") found at xbins = " + this.getMICfoundAtX() + ", ybins = " + this.getMICfoundAtY() + "\n");
                p.debugOut.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public String getHeader() {
        String header = String.valueOf(super.getHeader()) + "MIC found at (X),MICfound at (Y)," + "MAS found at (X),MAS found at (Y)," + "last value,signal/noise," + "Fisher,Fisher found at,MI via KDE,Spearman";
        return header;
    }

    @Override
    public String toString() {
        String result = "," + (int)this.MICfoundAt.x + "," + (int)this.MICfoundAt.y + "," + (int)this.MASfoundAt.x + "," + (int)this.MASfoundAt.y + "," + this.lastVal + "," + this.signalToNoise + "," + this.fisher + "," + this.fisherFoundAt + "," + this.KDE + "," + this.spearman;
        result = result.replace(Float.toString(Float.NaN), "");
        result = result.replace(Integer.toString(Integer.MIN_VALUE), "");
        result = result.replace(Integer.toString(Integer.MAX_VALUE), "ERROR");
        return String.valueOf(super.toString()) + result;
    }

    public float getLastVal() {
        return this.lastVal;
    }

    public float getKDE() {
        return this.KDE;
    }

    public float getSignalToNoise() {
        return this.signalToNoise;
    }

    public int getFisherFoundAt() {
        return this.fisherFoundAt;
    }

    public int getMASfoundAtX() {
        return (int)this.MASfoundAt.x;
    }

    public int getMASfoundAtY() {
        return (int)this.MASfoundAt.y;
    }

    public float getSpearman() {
        return this.spearman;
    }

    public float getFisher() {
        return this.fisher;
    }

    public int getMICfoundAtX() {
        return (int)this.MICfoundAt.x;
    }

    public int getMICfoundAtY() {
        return (int)this.MICfoundAt.y;
    }
}

