% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/saveFile.R
\name{saveFile}
\alias{saveFile}
\title{Save a file from a version of a project asset}
\usage{
saveFile(
  project,
  asset,
  version,
  path,
  cache = cacheDirectory(),
  overwrite = FALSE,
  url = restUrl(),
  config = NULL
)
}
\arguments{
\item{project}{String containing the project name.}

\item{asset}{String containing the asset name.}

\item{version}{String containing the version name.}

\item{path}{String containing the suffix of the object key for the file of interest,
i.e., the relative \dQuote{path} inside the version's \dQuote{subdirectory}.
The full object key is defined as \code{{project}/{asset}/{version}/{path}}.}

\item{cache}{String containing the path to the cache directory.}

\item{overwrite}{Logical scalar indicating whether to overwrite an existing file in \code{cache}.
If \code{FALSE} and the file exists in \code{cache}, the download is skipped.}

\item{url}{String containing the URL of the gypsum REST API.}

\item{config}{Deprecated and ignored.}
}
\value{
The file is downloaded to the local file system. The destination file path is returned.
}
\description{
Download a file from the gypsum bucket, for a version of an asset of a project.
}
\details{
The full object key is defined as \code{{project}/{asset}/{version}/{path}}.
If no file exists in the project-asset-version combination at \code{path}, 
this function will check the \code{..links} file to check whether \code{path} refers to a linked-from file.
If so, the contents of the link destination is downloaded to the cache and a link/copy is created at the returned file path.
}
\examples{
out <- saveFile("test-R", "basic", "v1", "blah.txt")
readLines(out)

}
\seealso{
\code{\link{saveVersion}}, to save all files with the same prefix.

\code{\link{cacheDirectory}}, for file caching.
}
\author{
Aaron Lun
}
