# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.servicebus.v2021_11_01 import ServiceBusManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestServiceBusManagementSubscriptionsOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ServiceBusManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_subscriptions_list_by_topic(self, resource_group):
        response = self.client.subscriptions.list_by_topic(
            resource_group_name=resource_group.name,
            namespace_name="str",
            topic_name="str",
            api_version="2021-11-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_subscriptions_create_or_update(self, resource_group):
        response = self.client.subscriptions.create_or_update(
            resource_group_name=resource_group.name,
            namespace_name="str",
            topic_name="str",
            subscription_name="str",
            parameters={
                "accessedAt": "2020-02-20 00:00:00",
                "autoDeleteOnIdle": "1 day, 0:00:00",
                "clientAffineProperties": {"clientId": "str", "isDurable": bool, "isShared": bool},
                "countDetails": {
                    "activeMessageCount": 0,
                    "deadLetterMessageCount": 0,
                    "scheduledMessageCount": 0,
                    "transferDeadLetterMessageCount": 0,
                    "transferMessageCount": 0,
                },
                "createdAt": "2020-02-20 00:00:00",
                "deadLetteringOnFilterEvaluationExceptions": bool,
                "deadLetteringOnMessageExpiration": bool,
                "defaultMessageTimeToLive": "1 day, 0:00:00",
                "duplicateDetectionHistoryTimeWindow": "1 day, 0:00:00",
                "enableBatchedOperations": bool,
                "forwardDeadLetteredMessagesTo": "str",
                "forwardTo": "str",
                "id": "str",
                "isClientAffine": bool,
                "location": "str",
                "lockDuration": "1 day, 0:00:00",
                "maxDeliveryCount": 0,
                "messageCount": 0,
                "name": "str",
                "requiresSession": bool,
                "status": "str",
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "type": "str",
                "updatedAt": "2020-02-20 00:00:00",
            },
            api_version="2021-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_subscriptions_delete(self, resource_group):
        response = self.client.subscriptions.delete(
            resource_group_name=resource_group.name,
            namespace_name="str",
            topic_name="str",
            subscription_name="str",
            api_version="2021-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_subscriptions_get(self, resource_group):
        response = self.client.subscriptions.get(
            resource_group_name=resource_group.name,
            namespace_name="str",
            topic_name="str",
            subscription_name="str",
            api_version="2021-11-01",
        )

        # please add some check logic here by yourself
        # ...
