'''OpenGL extension NV.shader_atomic_fp16_vector

This module customises the behaviour of the 
OpenGL.raw.GLES2.NV.shader_atomic_fp16_vector to provide a more 
Python-friendly API

Overview (from the spec)
	
	This extension provides GLSL built-in functions and assembly opcodes
	allowing shaders to perform a limited set of atomic read-modify-write
	operations to buffer or texture memory with 16-bit floating point vector
	surface formats.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/NV/shader_atomic_fp16_vector.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GLES2 import _types, _glgets
from OpenGL.raw.GLES2.NV.shader_atomic_fp16_vector import *
from OpenGL.raw.GLES2.NV.shader_atomic_fp16_vector import _EXTENSION_NAME

def glInitShaderAtomicFp16VectorNV():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )


### END AUTOGENERATED SECTION