/**
* @license Apache-2.0
*
* Copyright (c) 2018 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

'use strict';

// MODULES //

var tape = require( 'tape' );
var minstd = require( './../../../base/minstd' );
var isInt32Array = require( '@stdlib/assert/is-int32array' );
var Int32Array = require( '@stdlib/array/int32' );
var createTable = require( './../lib/create_table.js' );


// TESTS //

tape( 'main export is a function', function test( t ) {
	t.ok( true, __filename );
	t.equal( typeof createTable, 'function', 'main export is a function' );
	t.end();
});

tape( 'the function returns an `Int32Array`', function test( t ) {
	var arr;
	var out;

	arr = new Int32Array( 32 );
	out = createTable( minstd, arr, arr.length );

	t.equal( isInt32Array( out ), true, 'returns expected value' );
	t.equal( out, arr, 'returns expected value' );

	t.end();
});

tape( 'if the provided PRNG returns `NaN`, the function throws an error', function test( t ) {
	t.throws( foo, Error, 'throws an error' );
	t.end();

	function foo() {
		createTable( rand, new Int32Array( 32 ), 32 );
	}

	function rand() {
		return NaN;
	}
});
