/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.IOException;
import org.neo4j.internal.batchimport.input.InputChunk;
import org.neo4j.internal.batchimport.input.InputEntityVisitor;
import org.neo4j.internal.recordstorage.RecordStorageReader;
import org.neo4j.io.IOUtils;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.LongReference;
import org.neo4j.storageengine.api.PropertySelection;
import org.neo4j.storageengine.api.StorageEntityCursor;
import org.neo4j.storageengine.api.StoragePropertyCursor;
import org.neo4j.storageengine.api.cursor.StoreCursors;

abstract class StoreScanChunk<T extends StorageEntityCursor>
implements InputChunk {
    final StoragePropertyCursor storePropertyCursor;
    protected final T cursor;
    private final boolean requiresPropertyMigration;
    private final CursorContext cursorContext;
    private long id;
    private long endId;

    StoreScanChunk(T cursor, RecordStorageReader storageReader, boolean requiresPropertyMigration, CursorContext cursorContext, StoreCursors storeCursors, MemoryTracker memoryTracker) {
        this.cursor = cursor;
        this.requiresPropertyMigration = requiresPropertyMigration;
        this.storePropertyCursor = storageReader.allocatePropertyCursor(cursorContext, storeCursors, memoryTracker);
        this.cursorContext = cursorContext;
    }

    void visitProperties(T record, InputEntityVisitor visitor) {
        if (!this.requiresPropertyMigration) {
            visitor.propertyId(((LongReference)record.propertiesReference()).id);
        } else {
            record.properties(this.storePropertyCursor, PropertySelection.ALL_PROPERTIES);
            while (this.storePropertyCursor.next()) {
                visitor.property(this.storePropertyCursor.propertyKey(), this.storePropertyCursor.propertyValue().asObject());
            }
            this.storePropertyCursor.close();
        }
    }

    public void close() {
        IOUtils.closeAllUnchecked((AutoCloseable[])new AutoCloseable[]{this.cursor, this.storePropertyCursor, this.cursorContext});
    }

    public boolean next(InputEntityVisitor visitor) throws IOException {
        if (this.id < this.endId) {
            this.read(this.cursor, this.id);
            if (this.cursor.next()) {
                this.visitRecord(this.cursor, visitor);
                visitor.endOfEntity();
            }
            ++this.id;
            return true;
        }
        return false;
    }

    protected abstract void read(T var1, long var2);

    public void initialize(long startId, long endId) {
        this.id = startId;
        this.endId = endId;
    }

    abstract void visitRecord(T var1, InputEntityVisitor var2);
}

