/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.IOException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.LongSupplier;
import java.util.stream.Stream;
import org.eclipse.collections.api.factory.Sets;
import org.eclipse.collections.api.set.ImmutableSet;
import org.neo4j.common.ProgressReporter;
import org.neo4j.configuration.Config;
import org.neo4j.dbms.database.readonly.DatabaseReadOnlyChecker;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.batchimport.IndexImporterFactory;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.id.DefaultIdGeneratorFactory;
import org.neo4j.internal.id.IdGenerator;
import org.neo4j.internal.id.IdGeneratorFactory;
import org.neo4j.internal.id.IdSlotDistribution;
import org.neo4j.internal.id.IdType;
import org.neo4j.internal.id.ScanOnOpenReadOnlyIdGeneratorFactory;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.layout.recordstorage.RecordDatabaseFile;
import org.neo4j.io.layout.recordstorage.RecordDatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.StoreType;
import org.neo4j.kernel.impl.store.format.RecordFormatSelector;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.store.format.RecordStorageCapability;
import org.neo4j.kernel.impl.storemigration.ExistingTargetStrategy;
import org.neo4j.kernel.impl.storemigration.FileOperation;
import org.neo4j.kernel.impl.storemigration.StoreMigratorFileOperation;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.storageengine.migration.AbstractStoreMigrationParticipant;

public class IdGeneratorMigrator
extends AbstractStoreMigrationParticipant {
    public static final String ID_GENERATOR_MIGRATION_TAG = "idGeneratorMigration";
    private final FileSystemAbstraction fileSystem;
    private final PageCache pageCache;
    private final Config config;
    private final PageCacheTracer cacheTracer;

    public IdGeneratorMigrator(FileSystemAbstraction fileSystem, PageCache pageCache, Config config, PageCacheTracer cacheTracer) {
        super("Id files");
        this.fileSystem = fileSystem;
        this.pageCache = pageCache;
        this.config = config;
        this.cacheTracer = cacheTracer;
    }

    public void migrate(DatabaseLayout directoryLayoutArg, DatabaseLayout migrationLayoutArg, ProgressReporter progress, String versionToMigrateFrom, String versionToMigrateTo, IndexImporterFactory indexImporterFactory) throws IOException {
        RecordFormats newFormat;
        RecordDatabaseLayout directoryLayout = RecordDatabaseLayout.convert((DatabaseLayout)directoryLayoutArg);
        RecordDatabaseLayout migrationLayout = RecordDatabaseLayout.convert((DatabaseLayout)migrationLayoutArg);
        RecordFormats oldFormat = RecordFormatSelector.selectForVersion(versionToMigrateFrom);
        if (IdGeneratorMigrator.requiresIdFilesMigration(oldFormat, newFormat = RecordFormatSelector.selectForVersion(versionToMigrateTo))) {
            try (CursorContext cursorContext = new CursorContext(this.cacheTracer.createPageCursorTracer(ID_GENERATOR_MIGRATION_TAG));){
                this.migrateIdFiles(directoryLayout, migrationLayout, oldFormat, newFormat, progress, cursorContext);
            }
        }
    }

    private void migrateIdFiles(RecordDatabaseLayout directoryLayout, final RecordDatabaseLayout migrationLayout, RecordFormats oldFormat, RecordFormats newFormat, ProgressReporter progress, CursorContext cursorContext) throws IOException {
        ArrayList<StoreType> storesInDbDirectory = new ArrayList<StoreType>();
        ArrayList<StoreType> storesInMigrationDirectory = new ArrayList<StoreType>();
        for (StoreType storeType : StoreType.values()) {
            ArrayList<StoreType> list = this.fileSystem.fileExists(migrationLayout.file(storeType.getDatabaseFile())) ? storesInMigrationDirectory : storesInDbDirectory;
            list.add(storeType);
        }
        progress.start((long)(storesInDbDirectory.size() + storesInMigrationDirectory.size()));
        DefaultIdGeneratorFactory rebuiltIdGeneratorsFromOldStore = new DefaultIdGeneratorFactory(this.fileSystem, RecoveryCleanupWorkCollector.immediate(), directoryLayout.getDatabaseName()){

            public IdGenerator open(PageCache pageCache, Path filename, IdType idType, LongSupplier highIdScanner, long maxId, DatabaseReadOnlyChecker readOnlyChecker, Config config, CursorContext cursorContext, ImmutableSet<OpenOption> openOptions, IdSlotDistribution slotDistribution) throws IOException {
                Path redirectedFilename = migrationLayout.databaseDirectory().resolve(filename.getFileName().toString());
                return super.open(pageCache, redirectedFilename, idType, highIdScanner, maxId, readOnlyChecker, config, cursorContext, openOptions, slotDistribution);
            }

            public IdGenerator create(PageCache pageCache, Path fileName, IdType idType, long highId, boolean throwIfFileExists, long maxId, DatabaseReadOnlyChecker readOnlyChecker, Config config, CursorContext cursorContext, ImmutableSet<OpenOption> openOptions, IdSlotDistribution slotDistribution) {
                throw new IllegalStateException("The store file should exist and therefore all calls should be to open, not create");
            }
        };
        this.startAndTriggerRebuild(directoryLayout, oldFormat, (IdGeneratorFactory)rebuiltIdGeneratorsFromOldStore, storesInDbDirectory, progress, cursorContext);
        DefaultIdGeneratorFactory rebuiltIdGeneratorsFromNewStore = new DefaultIdGeneratorFactory(this.fileSystem, RecoveryCleanupWorkCollector.immediate(), migrationLayout.getDatabaseName());
        Set<Path> placeHolderStoreFiles = this.createEmptyPlaceHolderStoreFiles(migrationLayout, newFormat);
        this.startAndTriggerRebuild(migrationLayout, newFormat, (IdGeneratorFactory)rebuiltIdGeneratorsFromNewStore, storesInMigrationDirectory, progress, cursorContext);
        for (Path emptyPlaceHolderStoreFile : placeHolderStoreFiles) {
            this.fileSystem.deleteFile(emptyPlaceHolderStoreFile);
        }
    }

    private void startAndTriggerRebuild(RecordDatabaseLayout layout, RecordFormats format, IdGeneratorFactory idGeneratorFactory, List<StoreType> storeTypes, ProgressReporter progress, CursorContext cursorContext) throws IOException {
        try (NeoStores stores = this.createStoreFactory(layout, format, idGeneratorFactory).openNeoStores((StoreType[])storeTypes.toArray(StoreType[]::new));){
            stores.start(store -> progress.progress(1L), cursorContext);
        }
    }

    private Set<Path> createEmptyPlaceHolderStoreFiles(RecordDatabaseLayout layout, RecordFormats format) {
        HashSet<Path> createdStores = new HashSet<Path>();
        StoreType[] storesToCreate = (StoreType[])Stream.of(StoreType.values()).filter(t -> {
            Path file = layout.file(t.getDatabaseFile());
            boolean exists = this.fileSystem.fileExists(file);
            if (!exists) {
                createdStores.add(file);
            }
            return !exists;
        }).toArray(StoreType[]::new);
        this.createStoreFactory(layout, format, (IdGeneratorFactory)new ScanOnOpenReadOnlyIdGeneratorFactory()).openNeoStores(true, storesToCreate).close();
        return createdStores;
    }

    static boolean requiresIdFilesMigration(RecordFormats oldFormat, RecordFormats newFormat) {
        return !oldFormat.hasCapability(RecordStorageCapability.GBPTREE_ID_FILES) && newFormat.hasCapability(RecordStorageCapability.GBPTREE_ID_FILES);
    }

    private StoreFactory createStoreFactory(RecordDatabaseLayout databaseLayout, RecordFormats formats, IdGeneratorFactory idGeneratorFactory) {
        return new StoreFactory((DatabaseLayout)databaseLayout, this.config, idGeneratorFactory, this.pageCache, this.fileSystem, formats, (LogProvider)NullLogProvider.getInstance(), this.cacheTracer, DatabaseReadOnlyChecker.writable(), (ImmutableSet<OpenOption>)Sets.immutable.empty());
    }

    public void moveMigratedFiles(DatabaseLayout migrationLayout, DatabaseLayout directoryLayout, String versionToMigrateFrom, String versionToMigrateTo) throws IOException {
        StoreMigratorFileOperation.fileOperation(FileOperation.MOVE, this.fileSystem, migrationLayout, directoryLayout, Iterables.iterable((Object[])RecordDatabaseFile.allValues()), true, true, ExistingTargetStrategy.OVERWRITE);
    }

    public void cleanup(DatabaseLayout migrationLayout) {
    }
}

