/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.neo4j.internal.helpers.Numbers;
import org.neo4j.internal.kernel.api.exceptions.schema.MalformedSchemaRuleException;
import org.neo4j.internal.recordstorage.Command;
import org.neo4j.internal.recordstorage.CommandReading;
import org.neo4j.internal.recordstorage.LogCommandSerialization;
import org.neo4j.internal.schema.SchemaRule;
import org.neo4j.internal.schema.SchemaRuleMapifier;
import org.neo4j.io.fs.ReadableChannel;
import org.neo4j.io.fs.WritableChannel;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.store.PropertyType;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.LabelTokenRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.store.record.RelationshipTypeTokenRecord;
import org.neo4j.kernel.impl.store.record.SchemaRecord;
import org.neo4j.string.UTF8;
import org.neo4j.util.Bits;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueWriter;
import org.neo4j.values.storable.Values;

class LogCommandSerializationV4_0
extends LogCommandSerialization {
    static final LogCommandSerializationV4_0 INSTANCE = new LogCommandSerializationV4_0();

    LogCommandSerializationV4_0() {
    }

    @Override
    KernelVersion version() {
        return KernelVersion.V4_0;
    }

    @Override
    protected Command readNodeCommand(ReadableChannel channel) throws IOException {
        long id = channel.getLong();
        NodeRecord before = LogCommandSerializationV4_0.readNodeRecord(id, channel);
        NodeRecord after = LogCommandSerializationV4_0.readNodeRecord(id, channel);
        LogCommandSerializationV4_0.markAfterRecordAsCreatedIfCommandLooksCreated(before, after);
        return new Command.NodeCommand((LogCommandSerialization)this, before, after);
    }

    @Override
    protected Command readRelationshipCommand(ReadableChannel channel) throws IOException {
        long id = channel.getLong();
        RelationshipRecord before = LogCommandSerializationV4_0.readRelationshipRecord(id, channel);
        RelationshipRecord after = LogCommandSerializationV4_0.readRelationshipRecord(id, channel);
        LogCommandSerializationV4_0.markAfterRecordAsCreatedIfCommandLooksCreated(before, after);
        return new Command.RelationshipCommand((LogCommandSerialization)this, before, after);
    }

    @Override
    protected Command readPropertyCommand(ReadableChannel channel) throws IOException {
        long id = channel.getLong();
        PropertyRecord before = LogCommandSerializationV4_0.readPropertyRecord(id, channel);
        if (before == null) {
            return null;
        }
        PropertyRecord after = LogCommandSerializationV4_0.readPropertyRecord(id, channel);
        if (after == null) {
            return null;
        }
        LogCommandSerializationV4_0.markAfterRecordAsCreatedIfCommandLooksCreated(before, after);
        return new Command.PropertyCommand((LogCommandSerialization)this, before, after);
    }

    @Override
    protected Command readRelationshipGroupCommand(ReadableChannel channel) throws IOException {
        long id = channel.getLong();
        RelationshipGroupRecord before = LogCommandSerializationV4_0.readRelationshipGroupRecord(id, channel);
        RelationshipGroupRecord after = LogCommandSerializationV4_0.readRelationshipGroupRecord(id, channel);
        LogCommandSerializationV4_0.markAfterRecordAsCreatedIfCommandLooksCreated(before, after);
        return new Command.RelationshipGroupCommand((LogCommandSerialization)this, before, after);
    }

    private static RelationshipGroupRecord readRelationshipGroupRecord(long id, ReadableChannel channel) throws IOException {
        byte flags = channel.get();
        boolean inUse = Bits.bitFlag((byte)flags, (byte)Record.IN_USE.byteValue());
        boolean requireSecondaryUnit = Bits.bitFlag((int)flags, (int)4);
        boolean hasSecondaryUnit = Bits.bitFlag((int)flags, (int)8);
        boolean usesFixedReferenceFormat = Bits.bitFlag((int)flags, (int)16);
        int type = Numbers.unsignedShortToInt((short)channel.getShort());
        long next = channel.getLong();
        long firstOut = channel.getLong();
        long firstIn = channel.getLong();
        long firstLoop = channel.getLong();
        long owningNode = channel.getLong();
        RelationshipGroupRecord record = new RelationshipGroupRecord(id).initialize(inUse, type, firstOut, firstIn, firstLoop, owningNode, next);
        record.setRequiresSecondaryUnit(requireSecondaryUnit);
        if (hasSecondaryUnit) {
            record.setSecondaryUnitIdOnLoad(channel.getLong());
        }
        record.setUseFixedReferences(usesFixedReferenceFormat);
        return record;
    }

    @Override
    protected Command readRelationshipGroupExtendedCommand(ReadableChannel channel) throws IOException {
        long id = channel.getLong();
        RelationshipGroupRecord before = this.readRelationshipGroupExtendedRecord(id, channel);
        RelationshipGroupRecord after = this.readRelationshipGroupExtendedRecord(id, channel);
        LogCommandSerializationV4_0.markAfterRecordAsCreatedIfCommandLooksCreated(before, after);
        return new Command.RelationshipGroupCommand(before, after);
    }

    private RelationshipGroupRecord readRelationshipGroupExtendedRecord(long id, ReadableChannel channel) throws IOException {
        byte flags = channel.get();
        boolean inUse = Bits.bitFlag((byte)flags, (byte)Record.IN_USE.byteValue());
        boolean requireSecondaryUnit = Bits.bitFlag((int)flags, (int)4);
        boolean hasSecondaryUnit = Bits.bitFlag((int)flags, (int)8);
        boolean usesFixedReferenceFormat = Bits.bitFlag((int)flags, (int)16);
        int type = Numbers.unsignedShortToInt((short)channel.getShort());
        type |= Numbers.unsignedByteToInt((byte)channel.get()) << 16;
        long next = channel.getLong();
        long firstOut = channel.getLong();
        long firstIn = channel.getLong();
        long firstLoop = channel.getLong();
        long owningNode = channel.getLong();
        RelationshipGroupRecord record = new RelationshipGroupRecord(id).initialize(inUse, type, firstOut, firstIn, firstLoop, owningNode, next);
        record.setRequiresSecondaryUnit(requireSecondaryUnit);
        if (hasSecondaryUnit) {
            record.setSecondaryUnitIdOnLoad(channel.getLong());
        }
        record.setUseFixedReferences(usesFixedReferenceFormat);
        return record;
    }

    @Override
    protected Command readRelationshipTypeTokenCommand(ReadableChannel channel) throws IOException {
        int id = channel.getInt();
        RelationshipTypeTokenRecord before = LogCommandSerializationV4_0.readRelationshipTypeTokenRecord(id, channel);
        RelationshipTypeTokenRecord after = LogCommandSerializationV4_0.readRelationshipTypeTokenRecord(id, channel);
        LogCommandSerializationV4_0.markAfterRecordAsCreatedIfCommandLooksCreated(before, after);
        return new Command.RelationshipTypeTokenCommand((LogCommandSerialization)this, before, after);
    }

    private static RelationshipTypeTokenRecord readRelationshipTypeTokenRecord(int id, ReadableChannel channel) throws IOException {
        byte headerByte = channel.get();
        boolean inUse = false;
        boolean internal = false;
        if ((headerByte & Record.IN_USE.byteValue()) == Record.IN_USE.byteValue()) {
            inUse = true;
            internal = (headerByte & 0x20) == 32;
        } else if (headerByte != Record.NOT_IN_USE.byteValue()) {
            throw new IOException("Illegal in use flag: " + headerByte);
        }
        RelationshipTypeTokenRecord record = new RelationshipTypeTokenRecord(id);
        record.setInUse(inUse);
        record.setNameId(channel.getInt());
        record.setInternal(internal);
        int nrTypeRecords = channel.getInt();
        for (int i = 0; i < nrTypeRecords; ++i) {
            DynamicRecord dr = LogCommandSerializationV4_0.readDynamicRecord(channel);
            record.addNameRecord(dr);
        }
        return record;
    }

    @Override
    protected Command readLabelTokenCommand(ReadableChannel channel) throws IOException {
        int id = channel.getInt();
        LabelTokenRecord before = LogCommandSerializationV4_0.readLabelTokenRecord(id, channel);
        LabelTokenRecord after = LogCommandSerializationV4_0.readLabelTokenRecord(id, channel);
        LogCommandSerializationV4_0.markAfterRecordAsCreatedIfCommandLooksCreated(before, after);
        return new Command.LabelTokenCommand((LogCommandSerialization)this, before, after);
    }

    private static LabelTokenRecord readLabelTokenRecord(int id, ReadableChannel channel) throws IOException {
        byte headerByte = channel.get();
        boolean inUse = false;
        boolean internal = false;
        if ((headerByte & Record.IN_USE.byteValue()) == Record.IN_USE.byteValue()) {
            inUse = true;
            internal = (headerByte & 0x20) == 32;
        } else if (headerByte != Record.NOT_IN_USE.byteValue()) {
            throw new IOException("Illegal in use flag: " + headerByte);
        }
        LabelTokenRecord record = new LabelTokenRecord(id);
        record.setInUse(inUse);
        record.setNameId(channel.getInt());
        record.setInternal(internal);
        int nrTypeRecords = channel.getInt();
        for (int i = 0; i < nrTypeRecords; ++i) {
            DynamicRecord dr = LogCommandSerializationV4_0.readDynamicRecord(channel);
            record.addNameRecord(dr);
        }
        return record;
    }

    @Override
    protected Command readPropertyKeyTokenCommand(ReadableChannel channel) throws IOException {
        int id = channel.getInt();
        PropertyKeyTokenRecord before = LogCommandSerializationV4_0.readPropertyKeyTokenRecord(id, channel);
        if (before == null) {
            return null;
        }
        PropertyKeyTokenRecord after = LogCommandSerializationV4_0.readPropertyKeyTokenRecord(id, channel);
        if (after == null) {
            return null;
        }
        LogCommandSerializationV4_0.markAfterRecordAsCreatedIfCommandLooksCreated(before, after);
        return new Command.PropertyKeyTokenCommand((LogCommandSerialization)this, before, after);
    }

    private static PropertyKeyTokenRecord readPropertyKeyTokenRecord(int id, ReadableChannel channel) throws IOException {
        byte headerByte = channel.get();
        boolean inUse = false;
        boolean internal = false;
        if ((headerByte & Record.IN_USE.byteValue()) == Record.IN_USE.byteValue()) {
            inUse = true;
            internal = (headerByte & 0x20) == 32;
        } else if (headerByte != Record.NOT_IN_USE.byteValue()) {
            throw new IOException("Illegal in use flag: " + headerByte);
        }
        PropertyKeyTokenRecord record = new PropertyKeyTokenRecord(id);
        record.setInUse(inUse);
        record.setPropertyCount(channel.getInt());
        record.setNameId(channel.getInt());
        record.setInternal(internal);
        if (LogCommandSerializationV4_0.readDynamicRecords(channel, record, CommandReading.PROPERTY_INDEX_DYNAMIC_RECORD_ADDER) == -1) {
            return null;
        }
        return record;
    }

    @Override
    protected Command readSchemaRuleCommand(ReadableChannel channel) throws IOException {
        long id = channel.getLong();
        byte schemaRulePresence = channel.get();
        boolean hasSchemaRule = schemaRulePresence == 1;
        SchemaRecord before = LogCommandSerializationV4_0.readSchemaRecord(id, channel);
        SchemaRecord after = LogCommandSerializationV4_0.readSchemaRecord(id, channel);
        LogCommandSerializationV4_0.markAfterRecordAsCreatedIfCommandLooksCreated(before, after);
        SchemaRule schemaRule = null;
        if (hasSchemaRule) {
            schemaRule = LogCommandSerializationV4_0.readSchemaRule(id, channel);
        }
        return new Command.SchemaRuleCommand(this, before, after, schemaRule);
    }

    private static SchemaRecord readSchemaRecord(long id, ReadableChannel channel) throws IOException {
        SchemaRecord schemaRecord = new SchemaRecord(id);
        byte flags = channel.get();
        boolean inUse = Bits.bitFlag((byte)flags, (byte)Record.IN_USE.byteValue());
        if (inUse) {
            schemaRecord.setInUse(inUse);
            if (Bits.bitFlag((int)flags, (int)2)) {
                schemaRecord.setCreated();
            }
            schemaRecord.setUseFixedReferences(Bits.bitFlag((int)flags, (int)16));
            byte schemaFlags = channel.get();
            schemaRecord.setConstraint(Bits.bitFlag((byte)schemaFlags, (byte)1));
            schemaRecord.setNextProp(channel.getLong());
            if (Bits.bitFlag((int)flags, (int)8)) {
                schemaRecord.setSecondaryUnitIdOnLoad(channel.getLong());
            }
        } else {
            schemaRecord.clear();
        }
        return schemaRecord;
    }

    private static SchemaRule readSchemaRule(long id, ReadableChannel channel) throws IOException {
        Map<String, Value> ruleMap = LogCommandSerializationV4_0.readStringValueMap(channel);
        try {
            return SchemaRuleMapifier.unmapifySchemaRule((long)id, ruleMap);
        }
        catch (MalformedSchemaRuleException e) {
            throw new IOException("Failed to create a schema rule from string-value map: " + ruleMap, e);
        }
    }

    static Map<String, Value> readStringValueMap(ReadableChannel channel) throws IOException {
        HashMap<String, Value> map = new HashMap<String, Value>();
        int size = channel.getInt();
        for (int i = 0; i < size; ++i) {
            byte[] keyBytes = LogCommandSerializationV4_0.readMapKeyByteArray(channel);
            String key = UTF8.decode((byte[])keyBytes);
            Value value = LogCommandSerializationV4_0.readMapValue(channel);
            map.put(key, value);
        }
        return map;
    }

    private static byte[] readMapKeyByteArray(ReadableChannel channel) throws IOException {
        int size = channel.getInt();
        byte[] bytes = new byte[size];
        channel.get(bytes, size);
        return bytes;
    }

    private static Value readMapValue(ReadableChannel channel) throws IOException {
        SchemaMapValueType type = SchemaMapValueType.map(channel.get());
        switch (type) {
            case BOOL_LITERAL_TRUE: {
                return Values.booleanValue((boolean)true);
            }
            case BOOL_LITERAL_FALSE: {
                return Values.booleanValue((boolean)false);
            }
            case BOOL_ARRAY_ELEMENT: {
                throw new IOException("Cannot read schema rule map value of type boolean array element as a top-level type.");
            }
            case BYTE: {
                return Values.byteValue((byte)channel.get());
            }
            case SHORT: {
                return Values.shortValue((short)channel.getShort());
            }
            case INT: {
                return Values.intValue((int)channel.getInt());
            }
            case LONG: {
                return Values.longValue((long)channel.getLong());
            }
            case FLOAT: {
                return Values.floatValue((float)channel.getFloat());
            }
            case DOUBLE: {
                return Values.doubleValue((double)channel.getDouble());
            }
            case STRING: {
                int size = channel.getInt();
                byte[] bytes = new byte[size];
                channel.get(bytes, size);
                return Values.utf8Value((byte[])bytes);
            }
            case CHAR: {
                return Values.charValue((char)((char)channel.getInt()));
            }
            case ARRAY: {
                int arraySize = channel.getInt();
                SchemaMapValueType elementType = SchemaMapValueType.map(channel.get());
                switch (elementType) {
                    case BOOL_LITERAL_TRUE: {
                        throw new IOException("BOOL_LITERAL_TRUE cannot be a schema rule map value array element type.");
                    }
                    case BOOL_LITERAL_FALSE: {
                        throw new IOException("BOOL_LITERAL_FALSE cannot be a schema rule map value array element type.");
                    }
                    case BOOL_ARRAY_ELEMENT: {
                        boolean[] array = new boolean[arraySize];
                        for (int i = 0; i < arraySize; ++i) {
                            array[i] = channel.get() == SchemaMapValueType.BOOL_LITERAL_TRUE.type();
                        }
                        return Values.booleanArray((boolean[])array);
                    }
                    case BYTE: {
                        byte[] array = new byte[arraySize];
                        for (int i = 0; i < arraySize; ++i) {
                            array[i] = channel.get();
                        }
                        return Values.byteArray((byte[])array);
                    }
                    case SHORT: {
                        short[] array = new short[arraySize];
                        for (int i = 0; i < arraySize; ++i) {
                            array[i] = channel.getShort();
                        }
                        return Values.shortArray((short[])array);
                    }
                    case INT: {
                        int[] array = new int[arraySize];
                        for (int i = 0; i < arraySize; ++i) {
                            array[i] = channel.getInt();
                        }
                        return Values.intArray((int[])array);
                    }
                    case LONG: {
                        long[] array = new long[arraySize];
                        for (int i = 0; i < arraySize; ++i) {
                            array[i] = channel.getLong();
                        }
                        return Values.longArray((long[])array);
                    }
                    case FLOAT: {
                        float[] array = new float[arraySize];
                        for (int i = 0; i < arraySize; ++i) {
                            array[i] = channel.getFloat();
                        }
                        return Values.floatArray((float[])array);
                    }
                    case DOUBLE: {
                        double[] array = new double[arraySize];
                        for (int i = 0; i < arraySize; ++i) {
                            array[i] = channel.getDouble();
                        }
                        return Values.doubleArray((double[])array);
                    }
                    case STRING: {
                        String[] array = new String[arraySize];
                        for (int i = 0; i < arraySize; ++i) {
                            int size = channel.getInt();
                            byte[] bytes = new byte[size];
                            channel.get(bytes, size);
                            array[i] = UTF8.decode((byte[])bytes);
                        }
                        return Values.stringArray((String[])array);
                    }
                    case CHAR: {
                        char[] array = new char[arraySize];
                        for (int i = 0; i < arraySize; ++i) {
                            array[i] = (char)channel.getInt();
                        }
                        return Values.charArray((char[])array);
                    }
                    case ARRAY: {
                        throw new IOException("Nested arrays are not support for schema rule map values.");
                    }
                }
                throw new IOException("Unknown array element type: " + elementType);
            }
        }
        throw new IOException("Unknown schema map value type: " + type);
    }

    private static NodeRecord readNodeRecord(long id, ReadableChannel channel) throws IOException {
        NodeRecord record;
        byte flags = channel.get();
        boolean inUse = Bits.bitFlag((byte)flags, (byte)Record.IN_USE.byteValue());
        boolean isCreated = Bits.bitFlag((int)flags, (int)2);
        boolean requiresSecondaryUnit = Bits.bitFlag((int)flags, (int)4);
        boolean hasSecondaryUnit = Bits.bitFlag((int)flags, (int)8);
        boolean usesFixedReferenceFormat = Bits.bitFlag((int)flags, (int)16);
        ArrayList<DynamicRecord> dynamicLabelRecords = new ArrayList<DynamicRecord>();
        long labelField = Record.NO_LABELS_FIELD.intValue();
        if (inUse) {
            boolean dense = channel.get() == 1;
            long nextRel = channel.getLong();
            long nextProp = channel.getLong();
            record = new NodeRecord(id).initialize(false, nextProp, dense, nextRel, 0L);
            labelField = channel.getLong();
            record.setRequiresSecondaryUnit(requiresSecondaryUnit);
            if (hasSecondaryUnit) {
                record.setSecondaryUnitIdOnLoad(channel.getLong());
            }
            record.setUseFixedReferences(usesFixedReferenceFormat);
        } else {
            record = new NodeRecord(id);
        }
        LogCommandSerializationV4_0.readDynamicRecords(channel, dynamicLabelRecords, CommandReading.COLLECTION_DYNAMIC_RECORD_ADDER);
        record.setLabelField(labelField, dynamicLabelRecords);
        record.setInUse(inUse);
        if (isCreated) {
            record.setCreated();
        }
        return record;
    }

    private static RelationshipRecord readRelationshipRecord(long id, ReadableChannel channel) throws IOException {
        RelationshipRecord record;
        byte flags = channel.get();
        boolean inUse = Bits.bitFlag((byte)flags, (byte)Record.IN_USE.byteValue());
        boolean requiresSecondaryUnit = Bits.bitFlag((int)flags, (int)4);
        boolean hasSecondaryUnit = Bits.bitFlag((int)flags, (int)8);
        boolean usesFixedReferenceFormat = Bits.bitFlag((int)flags, (int)16);
        if (inUse) {
            record = new RelationshipRecord(id);
            record.setLinks(channel.getLong(), channel.getLong(), channel.getInt());
            record.setInUse(true);
            record.setRequiresSecondaryUnit(requiresSecondaryUnit);
            record.setFirstPrevRel(channel.getLong());
            record.setFirstNextRel(channel.getLong());
            record.setSecondPrevRel(channel.getLong());
            record.setSecondNextRel(channel.getLong());
            record.setNextProp(channel.getLong());
            byte extraByte = channel.get();
            record.setFirstInFirstChain((extraByte & 1) > 0);
            record.setFirstInSecondChain((extraByte & 2) > 0);
            if (hasSecondaryUnit) {
                record.setSecondaryUnitIdOnLoad(channel.getLong());
            }
            record.setUseFixedReferences(usesFixedReferenceFormat);
        } else {
            record = new RelationshipRecord(id);
            record.setLinks(-1L, -1L, channel.getInt());
            record.setInUse(false);
        }
        if (Bits.bitFlag((int)flags, (int)2)) {
            record.setCreated();
        }
        return record;
    }

    private static DynamicRecord readDynamicRecord(ReadableChannel channel) throws IOException {
        long id = channel.getLong();
        assert (id >= 0L && id <= 0xFFFFFFFFFL) : id + " is not a valid dynamic record id";
        int type = channel.getInt();
        byte inUseFlag = channel.get();
        boolean inUse = (inUseFlag & Record.IN_USE.byteValue()) != 0;
        DynamicRecord record = new DynamicRecord(id);
        record.setInUse(inUse, type);
        if (inUse) {
            record.setStartRecord((inUseFlag & 0x20) != 0);
            if ((inUseFlag & 2) != 0) {
                record.setCreated();
            }
            int nrOfBytes = channel.getInt();
            assert (nrOfBytes >= 0 && nrOfBytes < 0xFFFFFF) : nrOfBytes + " is not valid for a number of bytes field of a dynamic record";
            long nextBlock = channel.getLong();
            assert (nextBlock >= 0L && nextBlock <= 0x800000000L || nextBlock == (long)Record.NO_NEXT_BLOCK.intValue()) : nextBlock + " is not valid for a next record field of a dynamic record";
            record.setNextBlock(nextBlock);
            byte[] data = new byte[nrOfBytes];
            channel.get(data, nrOfBytes);
            record.setData(data);
        }
        return record;
    }

    private static <T> int readDynamicRecords(ReadableChannel channel, T target, CommandReading.DynamicRecordAdder<T> adder) throws IOException {
        int numberOfRecords;
        assert (numberOfRecords >= 0);
        for (numberOfRecords = channel.getInt(); numberOfRecords > 0; --numberOfRecords) {
            DynamicRecord read = LogCommandSerializationV4_0.readDynamicRecord(channel);
            adder.add(target, read);
        }
        return numberOfRecords;
    }

    private static PropertyRecord readPropertyRecord(long id, ReadableChannel channel) throws IOException {
        PropertyRecord record = new PropertyRecord(id);
        byte flags = channel.get();
        boolean inUse = Bits.bitFlag((byte)flags, (byte)Record.IN_USE.byteValue());
        boolean nodeProperty = !Bits.bitFlag((byte)flags, (byte)Record.REL_PROPERTY.byteValue());
        boolean requireSecondaryUnit = Bits.bitFlag((int)flags, (int)4);
        boolean hasSecondaryUnit = Bits.bitFlag((int)flags, (int)8);
        boolean usesFixedReferenceFormat = Bits.bitFlag((int)flags, (int)16);
        record.setRequiresSecondaryUnit(requireSecondaryUnit);
        record.setUseFixedReferences(usesFixedReferenceFormat);
        long nextProp = channel.getLong();
        long prevProp = channel.getLong();
        record.setNextProp(nextProp);
        record.setPrevProp(prevProp);
        long primitiveId = channel.getLong();
        if (primitiveId != -1L && nodeProperty) {
            record.setNodeId(primitiveId);
        } else if (primitiveId != -1L) {
            record.setRelId(primitiveId);
        }
        if (hasSecondaryUnit) {
            record.setSecondaryUnitIdOnLoad(channel.getLong());
        }
        int nrPropBlocks = channel.get();
        assert (nrPropBlocks >= 0);
        if (nrPropBlocks > 0) {
            record.setInUse(true);
        }
        while (nrPropBlocks-- > 0) {
            PropertyBlock block = LogCommandSerializationV4_0.readPropertyBlock(channel);
            if (block == null) {
                return null;
            }
            record.addPropertyBlock(block);
        }
        int deletedRecords = LogCommandSerializationV4_0.readDynamicRecords(channel, record, CommandReading.PROPERTY_DELETED_DYNAMIC_RECORD_ADDER);
        if (deletedRecords == -1) {
            return null;
        }
        assert (deletedRecords >= 0);
        while (deletedRecords-- > 0) {
            DynamicRecord read = LogCommandSerializationV4_0.readDynamicRecord(channel);
            record.addDeletedRecord(read);
        }
        if (inUse && !record.inUse() || !inUse && record.inUse()) {
            throw new IllegalStateException("Weird, inUse was read in as " + inUse + " but the record is " + record);
        }
        return record;
    }

    private static PropertyBlock readPropertyBlock(ReadableChannel channel) throws IOException {
        PropertyBlock toReturn = new PropertyBlock();
        byte blockSize = channel.get();
        assert (blockSize > 0 && blockSize % 8 == 0) : blockSize + " is not a valid block size value";
        long[] blocks = LogCommandSerializationV4_0.readLongs(channel, blockSize / 8);
        assert (blocks.length == blockSize / 8) : blocks.length + " longs were read in while i asked for what corresponds to " + blockSize;
        assert (PropertyType.getPropertyTypeOrThrow(blocks[0]).calculateNumberOfBlocksUsed(blocks[0]) == blocks.length) : blocks.length + " is not a valid number of blocks for type " + PropertyType.getPropertyTypeOrThrow(blocks[0]);
        toReturn.setValueBlocks(blocks);
        if (LogCommandSerializationV4_0.readDynamicRecords(channel, toReturn, CommandReading.PROPERTY_BLOCK_DYNAMIC_RECORD_ADDER) == -1) {
            return null;
        }
        return toReturn;
    }

    private static long[] readLongs(ReadableChannel channel, int count) throws IOException {
        long[] result = new long[count];
        for (int i = 0; i < count; ++i) {
            result[i] = channel.getLong();
        }
        return result;
    }

    @Override
    protected Command readNodeCountsCommand(ReadableChannel channel) throws IOException {
        int labelId = channel.getInt();
        long delta = channel.getLong();
        return new Command.NodeCountsCommand(this, labelId, delta);
    }

    @Override
    protected Command readRelationshipCountsCommand(ReadableChannel channel) throws IOException {
        int startLabelId = channel.getInt();
        int typeId = channel.getInt();
        int endLabelId = channel.getInt();
        long delta = channel.getLong();
        return new Command.RelationshipCountsCommand(this, startLabelId, typeId, endLabelId, delta);
    }

    @Override
    protected Command readNeoStoreCommand(ReadableChannel channel) throws IOException {
        throw this.unsupportedInThisVersionException();
    }

    static void markAfterRecordAsCreatedIfCommandLooksCreated(AbstractBaseRecord before, AbstractBaseRecord after) {
        if (!before.inUse() && after.inUse()) {
            after.setCreated();
        }
        if (!before.hasSecondaryUnitId() && after.hasSecondaryUnitId()) {
            after.setSecondaryUnitIdOnCreate(after.getSecondaryUnitId());
        }
    }

    @Override
    public void writeNodeCommand(WritableChannel channel, Command.NodeCommand command) throws IOException {
        channel.put((byte)1);
        channel.putLong(((NodeRecord)command.getAfter()).getId());
        LogCommandSerializationV4_0.writeNodeRecord(channel, (NodeRecord)command.getBefore());
        LogCommandSerializationV4_0.writeNodeRecord(channel, (NodeRecord)command.getAfter());
    }

    private static void writeNodeRecord(WritableChannel channel, NodeRecord record) throws IOException {
        byte flags = Bits.bitFlags((int)Bits.bitFlag((boolean)record.inUse(), (byte)Record.IN_USE.byteValue()), (int)Bits.bitFlag((boolean)record.isCreated(), (int)2), (int)Bits.bitFlag((boolean)record.requiresSecondaryUnit(), (int)4), (int)Bits.bitFlag((boolean)record.hasSecondaryUnitId(), (int)8), (int)Bits.bitFlag((boolean)record.isUseFixedReferences(), (int)16));
        channel.put(flags);
        if (record.inUse()) {
            channel.put(record.isDense() ? (byte)1 : 0);
            channel.putLong(record.getNextRel()).putLong(record.getNextProp());
            channel.putLong(record.getLabelField());
            if (record.hasSecondaryUnitId()) {
                channel.putLong(record.getSecondaryUnitId());
            }
        }
        LogCommandSerializationV4_0.writeDynamicRecords(channel, record.getDynamicLabelRecords());
    }

    @Override
    public void writeRelationshipCommand(WritableChannel channel, Command.RelationshipCommand command) throws IOException {
        channel.put((byte)3);
        channel.putLong(((RelationshipRecord)command.getAfter()).getId());
        LogCommandSerializationV4_0.writeRelationshipRecord(channel, (RelationshipRecord)command.getBefore());
        LogCommandSerializationV4_0.writeRelationshipRecord(channel, (RelationshipRecord)command.getAfter());
    }

    private static void writeRelationshipRecord(WritableChannel channel, RelationshipRecord record) throws IOException {
        byte flags = Bits.bitFlags((int)Bits.bitFlag((boolean)record.inUse(), (byte)Record.IN_USE.byteValue()), (int)Bits.bitFlag((boolean)record.isCreated(), (int)2), (int)Bits.bitFlag((boolean)record.requiresSecondaryUnit(), (int)4), (int)Bits.bitFlag((boolean)record.hasSecondaryUnitId(), (int)8), (int)Bits.bitFlag((boolean)record.isUseFixedReferences(), (int)16));
        channel.put(flags);
        if (record.inUse()) {
            channel.putLong(record.getFirstNode()).putLong(record.getSecondNode()).putInt(record.getType()).putLong(record.getFirstPrevRel()).putLong(record.getFirstNextRel()).putLong(record.getSecondPrevRel()).putLong(record.getSecondNextRel()).putLong(record.getNextProp()).put((byte)((record.isFirstInFirstChain() ? 1 : 0) | (record.isFirstInSecondChain() ? 2 : 0)));
            if (record.hasSecondaryUnitId()) {
                channel.putLong(record.getSecondaryUnitId());
            }
        } else {
            channel.putInt(record.getType());
        }
    }

    @Override
    public void writePropertyCommand(WritableChannel channel, Command.PropertyCommand command) throws IOException {
        channel.put((byte)2);
        channel.putLong(((PropertyRecord)command.getAfter()).getId());
        LogCommandSerializationV4_0.writePropertyRecord(channel, (PropertyRecord)command.getBefore());
        LogCommandSerializationV4_0.writePropertyRecord(channel, (PropertyRecord)command.getAfter());
    }

    private static void writePropertyRecord(WritableChannel channel, PropertyRecord record) throws IOException {
        byte flags = Bits.bitFlags((int)Bits.bitFlag((boolean)record.inUse(), (byte)Record.IN_USE.byteValue()), (int)Bits.bitFlag((record.getRelId() != -1L ? 1 : 0) != 0, (byte)Record.REL_PROPERTY.byteValue()), (int)Bits.bitFlag((boolean)record.requiresSecondaryUnit(), (int)4), (int)Bits.bitFlag((boolean)record.hasSecondaryUnitId(), (int)8), (int)Bits.bitFlag((boolean)record.isUseFixedReferences(), (int)16));
        channel.put(flags);
        channel.putLong(record.getNextProp()).putLong(record.getPrevProp());
        long nodeId = record.getNodeId();
        long relId = record.getRelId();
        if (nodeId != -1L) {
            channel.putLong(nodeId);
        } else if (relId != -1L) {
            channel.putLong(relId);
        } else {
            channel.putLong(-1L);
        }
        if (record.hasSecondaryUnitId()) {
            channel.putLong(record.getSecondaryUnitId());
        }
        int numberOfProperties = record.numberOfProperties();
        channel.put((byte)numberOfProperties);
        PropertyBlock[] blocks = record.getPropertyBlocks();
        for (int i = 0; i < numberOfProperties; ++i) {
            PropertyBlock block = blocks[i];
            assert (block.getSize() > 0) : record + " has incorrect size";
            LogCommandSerializationV4_0.writePropertyBlock(channel, block);
        }
        LogCommandSerializationV4_0.writeDynamicRecords(channel, record.getDeletedRecords());
    }

    private static void writePropertyBlock(WritableChannel channel, PropertyBlock block) throws IOException {
        long[] propBlockValues;
        byte blockSize = (byte)block.getSize();
        assert (blockSize > 0) : blockSize + " is not a valid block size value";
        channel.put(blockSize);
        for (long propBlockValue : propBlockValues = block.getValueBlocks()) {
            channel.putLong(propBlockValue);
        }
        if (block.isLight()) {
            channel.putInt(0);
        } else {
            LogCommandSerializationV4_0.writeDynamicRecords(channel, block.getValueRecords());
        }
    }

    @Override
    public void writeRelationshipGroupCommand(WritableChannel channel, Command.RelationshipGroupCommand command) throws IOException {
        int relType = Math.max(((RelationshipGroupRecord)command.getBefore()).getType(), ((RelationshipGroupRecord)command.getAfter()).getType());
        if (relType == Record.NULL_REFERENCE.intValue() || relType >>> 16 == 0) {
            channel.put((byte)9);
            channel.putLong(((RelationshipGroupRecord)command.getAfter()).getId());
            LogCommandSerializationV4_0.writeRelationshipGroupRecord(channel, (RelationshipGroupRecord)command.getBefore());
            LogCommandSerializationV4_0.writeRelationshipGroupRecord(channel, (RelationshipGroupRecord)command.getAfter());
        } else {
            channel.put((byte)21);
            channel.putLong(((RelationshipGroupRecord)command.getAfter()).getId());
            this.writeRelationshipGroupExtendedRecord(channel, (RelationshipGroupRecord)command.getBefore());
            this.writeRelationshipGroupExtendedRecord(channel, (RelationshipGroupRecord)command.getAfter());
        }
    }

    private static void writeRelationshipGroupRecord(WritableChannel channel, RelationshipGroupRecord record) throws IOException {
        byte flags = Bits.bitFlags((int)Bits.bitFlag((boolean)record.inUse(), (byte)Record.IN_USE.byteValue()), (int)Bits.bitFlag((boolean)record.requiresSecondaryUnit(), (int)4), (int)Bits.bitFlag((boolean)record.hasSecondaryUnitId(), (int)8), (int)Bits.bitFlag((boolean)record.isUseFixedReferences(), (int)16));
        channel.put(flags);
        channel.putShort((short)record.getType());
        channel.putLong(record.getNext());
        channel.putLong(record.getFirstOut());
        channel.putLong(record.getFirstIn());
        channel.putLong(record.getFirstLoop());
        channel.putLong(record.getOwningNode());
        if (record.hasSecondaryUnitId()) {
            channel.putLong(record.getSecondaryUnitId());
        }
    }

    private void writeRelationshipGroupExtendedRecord(WritableChannel channel, RelationshipGroupRecord record) throws IOException {
        byte flags = Bits.bitFlags((int)Bits.bitFlag((boolean)record.inUse(), (byte)Record.IN_USE.byteValue()), (int)Bits.bitFlag((boolean)record.requiresSecondaryUnit(), (int)4), (int)Bits.bitFlag((boolean)record.hasSecondaryUnitId(), (int)8), (int)Bits.bitFlag((boolean)record.isUseFixedReferences(), (int)16));
        channel.put(flags);
        channel.putShort((short)record.getType());
        channel.put((byte)(record.getType() >>> 16));
        channel.putLong(record.getNext());
        channel.putLong(record.getFirstOut());
        channel.putLong(record.getFirstIn());
        channel.putLong(record.getFirstLoop());
        channel.putLong(record.getOwningNode());
        if (record.hasSecondaryUnitId()) {
            channel.putLong(record.getSecondaryUnitId());
        }
    }

    @Override
    public void writeRelationshipTypeTokenCommand(WritableChannel channel, Command.RelationshipTypeTokenCommand command) throws IOException {
        channel.put((byte)4);
        channel.putInt(((RelationshipTypeTokenRecord)command.getAfter()).getIntId());
        LogCommandSerializationV4_0.writeRelationshipTypeTokenRecord(channel, (RelationshipTypeTokenRecord)command.getBefore());
        LogCommandSerializationV4_0.writeRelationshipTypeTokenRecord(channel, (RelationshipTypeTokenRecord)command.getAfter());
    }

    private static void writeRelationshipTypeTokenRecord(WritableChannel channel, RelationshipTypeTokenRecord record) throws IOException {
        byte headerByte = record.inUse() ? Record.IN_USE.byteValue() : Record.NOT_IN_USE.byteValue();
        headerByte = (byte)(headerByte + (record.isInternal() ? 32 : 0));
        channel.put(headerByte);
        channel.putInt(record.getNameId());
        if (record.isLight()) {
            channel.putInt(0);
        } else {
            LogCommandSerializationV4_0.writeDynamicRecords(channel, record.getNameRecords());
        }
    }

    @Override
    public void writeLabelTokenCommand(WritableChannel channel, Command.LabelTokenCommand command) throws IOException {
        channel.put((byte)8);
        channel.putInt(((LabelTokenRecord)command.getAfter()).getIntId());
        LogCommandSerializationV4_0.writeLabelTokenRecord(channel, (LabelTokenRecord)command.getBefore());
        LogCommandSerializationV4_0.writeLabelTokenRecord(channel, (LabelTokenRecord)command.getAfter());
    }

    private static void writeLabelTokenRecord(WritableChannel channel, LabelTokenRecord record) throws IOException {
        byte headerByte = record.inUse() ? Record.IN_USE.byteValue() : Record.NOT_IN_USE.byteValue();
        headerByte = (byte)(headerByte + (record.isInternal() ? 32 : 0));
        channel.put(headerByte).putInt(record.getNameId());
        LogCommandSerializationV4_0.writeDynamicRecords(channel, record.getNameRecords());
    }

    @Override
    public void writePropertyKeyTokenCommand(WritableChannel channel, Command.PropertyKeyTokenCommand command) throws IOException {
        channel.put((byte)5);
        channel.putInt(((PropertyKeyTokenRecord)command.getAfter()).getIntId());
        LogCommandSerializationV4_0.writePropertyKeyTokenRecord(channel, (PropertyKeyTokenRecord)command.getBefore());
        LogCommandSerializationV4_0.writePropertyKeyTokenRecord(channel, (PropertyKeyTokenRecord)command.getAfter());
    }

    private static void writePropertyKeyTokenRecord(WritableChannel channel, PropertyKeyTokenRecord record) throws IOException {
        byte headerByte = record.inUse() ? Record.IN_USE.byteValue() : Record.NOT_IN_USE.byteValue();
        headerByte = (byte)(headerByte + (record.isInternal() ? 32 : 0));
        channel.put(headerByte);
        channel.putInt(record.getPropertyCount()).putInt(record.getNameId());
        if (record.isLight()) {
            channel.putInt(0);
        } else {
            LogCommandSerializationV4_0.writeDynamicRecords(channel, record.getNameRecords());
        }
    }

    @Override
    public void writeSchemaRuleCommand(WritableChannel channel, Command.SchemaRuleCommand command) throws IOException {
        channel.put((byte)18);
        channel.putLong(((SchemaRecord)command.getBefore()).getId());
        SchemaRule schemaRule = command.getSchemaRule();
        boolean hasSchemaRule = schemaRule != null;
        channel.put(hasSchemaRule ? (byte)1 : 0);
        LogCommandSerializationV4_0.writeSchemaRecord(channel, (SchemaRecord)command.getBefore());
        LogCommandSerializationV4_0.writeSchemaRecord(channel, (SchemaRecord)command.getAfter());
        if (hasSchemaRule) {
            LogCommandSerializationV4_0.writeSchemaRule(channel, schemaRule);
        }
    }

    private static void writeSchemaRecord(WritableChannel channel, SchemaRecord record) throws IOException {
        byte flags = Bits.bitFlags((int)Bits.bitFlag((boolean)record.inUse(), (byte)Record.IN_USE.byteValue()), (int)Bits.bitFlag((boolean)record.isCreated(), (int)2), (int)Bits.bitFlag((boolean)record.isUseFixedReferences(), (int)16), (int)Bits.bitFlag((boolean)record.hasSecondaryUnitId(), (int)8));
        channel.put(flags);
        if (record.inUse()) {
            byte schemaFlags = Bits.bitFlag((boolean)record.isConstraint(), (byte)1);
            channel.put(schemaFlags);
            channel.putLong(record.getNextProp());
            if (record.hasSecondaryUnitId()) {
                channel.putLong(record.getSecondaryUnitId());
            }
        }
    }

    private static void writeSchemaRule(WritableChannel channel, SchemaRule schemaRule) throws IOException {
        Map ruleMap = SchemaRuleMapifier.mapifySchemaRule((SchemaRule)schemaRule);
        LogCommandSerializationV4_0.writeStringValueMap(channel, ruleMap);
    }

    static void writeStringValueMap(WritableChannel channel, Map<String, Value> ruleMap) throws IOException {
        channel.putInt(ruleMap.size());
        for (Map.Entry<String, Value> entry : ruleMap.entrySet()) {
            LogCommandSerializationV4_0.writeMapKeyByteArray(channel, UTF8.encode((String)entry.getKey()));
            LogCommandSerializationV4_0.writeMapValue(channel, entry.getValue());
        }
    }

    private static void writeMapKeyByteArray(WritableChannel channel, byte[] bytes) throws IOException {
        channel.putInt(bytes.length);
        channel.put(bytes, bytes.length);
    }

    private static void writeMapValue(final WritableChannel channel, Value value) throws IOException {
        value.writeTo((ValueWriter)new ValueWriter<IOException>(){
            private boolean arrayContext;

            public void writeNull() throws IOException {
                throw new IOException("Cannot write null entry value in schema record map representation.");
            }

            public void writeBoolean(boolean value) throws IOException {
                if (value) {
                    channel.put(SchemaMapValueType.BOOL_LITERAL_TRUE.type());
                } else {
                    channel.put(SchemaMapValueType.BOOL_LITERAL_FALSE.type());
                }
            }

            public void writeInteger(byte value) throws IOException {
                if (!this.arrayContext) {
                    channel.put(SchemaMapValueType.BYTE.type());
                }
                channel.put(value);
            }

            public void writeInteger(short value) throws IOException {
                if (!this.arrayContext) {
                    channel.put(SchemaMapValueType.SHORT.type());
                }
                channel.putShort(value);
            }

            public void writeInteger(int value) throws IOException {
                if (!this.arrayContext) {
                    channel.put(SchemaMapValueType.INT.type());
                }
                channel.putInt(value);
            }

            public void writeInteger(long value) throws IOException {
                if (!this.arrayContext) {
                    channel.put(SchemaMapValueType.LONG.type());
                }
                channel.putLong(value);
            }

            public void writeFloatingPoint(float value) throws IOException {
                if (!this.arrayContext) {
                    channel.put(SchemaMapValueType.FLOAT.type());
                }
                channel.putFloat(value);
            }

            public void writeFloatingPoint(double value) throws IOException {
                if (!this.arrayContext) {
                    channel.put(SchemaMapValueType.DOUBLE.type());
                }
                channel.putDouble(value);
            }

            public void writeString(String value) throws IOException {
                if (!this.arrayContext) {
                    channel.put(SchemaMapValueType.STRING.type());
                }
                byte[] bytes = UTF8.encode((String)value);
                channel.putInt(bytes.length);
                channel.put(bytes, bytes.length);
            }

            public void writeString(char value) throws IOException {
                if (!this.arrayContext) {
                    channel.put(SchemaMapValueType.CHAR.type());
                }
                channel.putInt((int)value);
            }

            public void beginArray(int size, ValueWriter.ArrayType arrayType) throws IOException {
                this.arrayContext = true;
                channel.put(SchemaMapValueType.ARRAY.type());
                channel.putInt(size);
                channel.put(SchemaMapValueType.map(arrayType).type());
            }

            public void endArray() {
                this.arrayContext = false;
            }

            public void writeByteArray(byte[] value) throws IOException {
                this.beginArray(value.length, ValueWriter.ArrayType.BYTE);
                for (byte b : value) {
                    this.writeInteger(b);
                }
                this.endArray();
            }

            public void writePoint(CoordinateReferenceSystem crs, double[] coordinate) throws IOException {
                throw new IOException("Point is not a supported schema map value type.");
            }

            public void writeDuration(long months, long days, long seconds, int nanos) throws IOException {
                throw new IOException("Duration is not a supported schema map value type.");
            }

            public void writeDate(LocalDate localDate) throws IOException {
                throw new IOException("Date is not a supported schema map value type.");
            }

            public void writeLocalTime(LocalTime localTime) throws IOException {
                throw new IOException("LocalTime is not a supported schema map value type.");
            }

            public void writeTime(OffsetTime offsetTime) throws IOException {
                throw new IOException("OffsetTime is not a supported schema map value type.");
            }

            public void writeLocalDateTime(LocalDateTime localDateTime) throws IOException {
                throw new IOException("LocalDateTime is not a supported schema map value type.");
            }

            public void writeDateTime(ZonedDateTime zonedDateTime) throws IOException {
                throw new IOException("DateTime is not a supported schema map value type.");
            }
        });
    }

    @Override
    public void writeNodeCountsCommand(WritableChannel channel, Command.NodeCountsCommand command) throws IOException {
        channel.put((byte)17);
        channel.putInt(command.labelId()).putLong(command.delta());
    }

    @Override
    public void writeRelationshipCountsCommand(WritableChannel channel, Command.RelationshipCountsCommand command) throws IOException {
        channel.put((byte)16);
        channel.putInt(command.startLabelId()).putInt(command.typeId()).putInt(command.endLabelId()).putLong(command.delta());
    }

    static void writeDynamicRecords(WritableChannel channel, List<DynamicRecord> records) throws IOException {
        LogCommandSerializationV4_0.writeDynamicRecords(channel, records, records.size());
    }

    static void writeDynamicRecords(WritableChannel channel, List<DynamicRecord> records, int size) throws IOException {
        channel.putInt(size);
        for (int i = 0; i < records.size(); ++i) {
            LogCommandSerializationV4_0.writeDynamicRecord(channel, records.get(i));
        }
    }

    static void writeDynamicRecord(WritableChannel channel, DynamicRecord record) throws IOException {
        if (record.inUse()) {
            byte inUse = Record.IN_USE.byteValue();
            if (record.isCreated()) {
                inUse = (byte)(inUse | 2);
            }
            if (record.isStartRecord()) {
                inUse = (byte)(inUse | 0x20);
            }
            channel.putLong(record.getId()).putInt(record.getTypeAsInt()).put(inUse).putInt(record.getLength()).putLong(record.getNextBlock());
            byte[] data = record.getData();
            assert (data != null);
            channel.put(data, data.length);
        } else {
            byte inUse = Record.NOT_IN_USE.byteValue();
            channel.putLong(record.getId()).putInt(record.getTypeAsInt()).put(inUse);
        }
    }

    @Override
    protected Command readLegacySchemaRuleCommand(ReadableChannel channel) throws IOException {
        throw this.unsupportedInThisVersionException();
    }

    @Override
    protected Command readIndexDefineCommand(ReadableChannel channel) throws IOException {
        throw this.unsupportedInThisVersionException();
    }

    @Override
    protected Command readIndexAddNodeCommand(ReadableChannel channel) throws IOException {
        throw this.unsupportedInThisVersionException();
    }

    @Override
    protected Command readIndexAddRelationshipCommand(ReadableChannel channel) throws IOException {
        throw this.unsupportedInThisVersionException();
    }

    @Override
    protected Command readIndexCreateCommand(ReadableChannel channel) throws IOException {
        throw this.unsupportedInThisVersionException();
    }

    @Override
    protected Command readIndexDeleteCommand(ReadableChannel channel) throws IOException {
        throw this.unsupportedInThisVersionException();
    }

    @Override
    protected Command readIndexRemoveCommand(ReadableChannel channel) throws IOException {
        throw this.unsupportedInThisVersionException();
    }

    private static enum SchemaMapValueType {
        BOOL_LITERAL_TRUE,
        BOOL_LITERAL_FALSE,
        BOOL_ARRAY_ELEMENT,
        BYTE,
        SHORT,
        INT,
        LONG,
        FLOAT,
        DOUBLE,
        STRING,
        CHAR,
        ARRAY;

        private static final SchemaMapValueType[] TYPE_ID_TO_ENUM;

        public static SchemaMapValueType map(byte type) {
            return TYPE_ID_TO_ENUM[type];
        }

        public static SchemaMapValueType map(ValueWriter.ArrayType arrayType) throws IOException {
            switch (arrayType) {
                case BYTE: {
                    return BYTE;
                }
                case SHORT: {
                    return SHORT;
                }
                case INT: {
                    return INT;
                }
                case LONG: {
                    return LONG;
                }
                case FLOAT: {
                    return FLOAT;
                }
                case DOUBLE: {
                    return DOUBLE;
                }
                case BOOLEAN: {
                    return BOOL_ARRAY_ELEMENT;
                }
                case STRING: {
                    return STRING;
                }
                case CHAR: {
                    return CHAR;
                }
            }
            throw new IOException("Unsupported schema record map value type: " + arrayType);
        }

        public byte type() {
            return (byte)this.ordinal();
        }

        static {
            TYPE_ID_TO_ENUM = SchemaMapValueType.values();
        }
    }
}

