/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime.interpreted.pipes;

import org.neo4j.cypher.internal.runtime.ClosingIterator;
import org.neo4j.cypher.internal.runtime.CypherRow;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.QueryState;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.TransactionCommittedCounterIterator;
import org.neo4j.exceptions.Neo4jException;
import org.neo4j.exceptions.StatusWrapCypherException;
import scala.Function0;
import scala.Serializable;

public final class TransactionCommittedCounterIterator$ {
    public static TransactionCommittedCounterIterator$ MODULE$;

    static {
        new TransactionCommittedCounterIterator$();
    }

    public ClosingIterator<CypherRow> wrap(Function0<ClosingIterator<CypherRow>> f, QueryState state) {
        return (ClosingIterator)this.executeWithHandling((Function0 & java.io.Serializable & Serializable)() -> new TransactionCommittedCounterIterator((ClosingIterator<CypherRow>)((ClosingIterator)f.apply()), state), state);
    }

    public <T> T executeWithHandling(Function0<T> f, QueryState queryState) {
        Object object;
        try {
            object = f.apply();
        }
        catch (StatusWrapCypherException e) {
            throw this.addTransactionInfoToException(e, queryState);
        }
        catch (Neo4jException e) {
            throw this.addTransactionInfoToException(new StatusWrapCypherException(e), queryState);
        }
        catch (Throwable e) {
            throw e;
        }
        return (T)object;
    }

    private <T> StatusWrapCypherException addTransactionInfoToException(StatusWrapCypherException e, QueryState queryState) {
        return e.addExtraInfo(StatusWrapCypherException.ExtraInformation.TRANSACTIONS_COMMITTED, this.transactionInfo(queryState));
    }

    private String transactionInfo(QueryState state) {
        return new StringBuilder(24).append("Transactions committed: ").append(state.getStatistics().transactionsCommitted()).toString();
    }

    private TransactionCommittedCounterIterator$() {
        MODULE$ = this;
    }
}

