/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util.collection;

import org.eclipse.collections.api.map.primitive.MutableLongObjectMap;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.neo4j.collection.trackable.HeapTrackingCollections;
import org.neo4j.kernel.impl.util.collection.CollectionsFactory;
import org.neo4j.kernel.impl.util.collection.HeapTrackingValuesMap;
import org.neo4j.kernel.impl.util.diffsets.MutableLongDiffSets;
import org.neo4j.kernel.impl.util.diffsets.TrackableDiffSets;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.values.storable.Value;

public class OnHeapCollectionsFactory
implements CollectionsFactory {
    public static final CollectionsFactory INSTANCE = new OnHeapCollectionsFactory();

    private OnHeapCollectionsFactory() {
    }

    @Override
    public MutableLongSet newLongSet(MemoryTracker memoryTracker) {
        return HeapTrackingCollections.newLongSet((MemoryTracker)memoryTracker);
    }

    @Override
    public MutableLongDiffSets newLongDiffSets(MemoryTracker memoryTracker) {
        return TrackableDiffSets.newMutableLongDiffSets(this, memoryTracker);
    }

    @Override
    public MutableLongObjectMap<Value> newValuesMap(MemoryTracker memoryTracker) {
        return HeapTrackingValuesMap.createValuesMap(memoryTracker);
    }

    @Override
    public void release() {
    }
}

