/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.pruning;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.time.Clock;
import java.util.concurrent.locks.Lock;
import java.util.function.LongConsumer;
import org.apache.commons.lang3.ArrayUtils;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.internal.helpers.collection.LongRange;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.transaction.log.files.LogFile;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.checkpoint.CheckpointFile;
import org.neo4j.kernel.impl.transaction.log.pruning.LogPruneStrategy;
import org.neo4j.kernel.impl.transaction.log.pruning.LogPruneStrategyFactory;
import org.neo4j.kernel.impl.transaction.log.pruning.LogPruning;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public class LogPruningImpl
implements LogPruning {
    private final Lock pruneLock;
    private final FileSystemAbstraction fs;
    private final LogFiles logFiles;
    private final Log log;
    private final LogPruneStrategyFactory strategyFactory;
    private final Clock clock;
    private final LogProvider logProvider;
    private final int checkpointFilesToKeep;
    private volatile LogPruneStrategy pruneStrategy;

    public LogPruningImpl(FileSystemAbstraction fs, LogFiles logFiles, LogProvider logProvider, LogPruneStrategyFactory strategyFactory, Clock clock, Config config, Lock pruneLock) {
        this.fs = fs;
        this.logFiles = logFiles;
        this.logProvider = logProvider;
        this.log = logProvider.getLog(this.getClass());
        this.strategyFactory = strategyFactory;
        this.clock = clock;
        this.pruneLock = pruneLock;
        this.pruneStrategy = strategyFactory.strategyFromConfigValue(fs, logFiles, logProvider, clock, (String)config.get(GraphDatabaseSettings.keep_logical_logs));
        this.checkpointFilesToKeep = (Integer)config.get(GraphDatabaseInternalSettings.checkpoint_logical_log_keep_threshold);
        config.addListener(GraphDatabaseSettings.keep_logical_logs, (prev, update) -> this.updateConfiguration((String)update));
    }

    private void updateConfiguration(String pruningConf) {
        LogPruneStrategy strategy;
        this.pruneStrategy = strategy = this.strategyFactory.strategyFromConfigValue(this.fs, this.logFiles, this.logProvider, this.clock, pruningConf);
        this.log.info("Retention policy updated to '" + strategy + "', which will take effect next time a checkpoint completes.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pruneLogs(long upToVersion) throws IOException {
        this.pruneLock.lock();
        try {
            LogFile logFile = this.logFiles.getLogFile();
            LogPruneStrategy strategy = this.pruneStrategy;
            CountingDeleter deleter = new CountingDeleter(logFile, this.fs);
            LongRange versionsToDelete = strategy.findLogVersionsToDelete(upToVersion);
            logFile.terminateExternalReaders(versionsToDelete.to());
            versionsToDelete.stream().forEachOrdered(deleter);
            this.log.info(deleter.describeResult(strategy));
            this.cleanupCheckpointLogFiles();
        }
        finally {
            this.pruneLock.unlock();
        }
    }

    private void cleanupCheckpointLogFiles() throws IOException {
        CheckpointFile checkpointFile = this.logFiles.getCheckpointFile();
        Object[] checkpointFiles = checkpointFile.getDetachedCheckpointFiles();
        if (ArrayUtils.isNotEmpty((Object[])checkpointFiles) && checkpointFiles.length > this.checkpointFilesToKeep) {
            long highestVersionToRemove = checkpointFile.getCurrentDetachedLogVersion() - (long)this.checkpointFilesToKeep;
            int filesDeleted = 0;
            for (Object file : checkpointFiles) {
                if (checkpointFile.getDetachedCheckpointLogFileVersion((Path)file) > highestVersionToRemove) continue;
                this.fs.deleteFile((Path)file);
                ++filesDeleted;
            }
            this.log.info("Pruned " + filesDeleted + " checkpoint log files. Lowest preserved version: " + (highestVersionToRemove + 1L));
        }
    }

    @Override
    public boolean mightHaveLogsToPrune(long upToVersion) {
        return !this.pruneStrategy.findLogVersionsToDelete(upToVersion).isEmpty();
    }

    @Override
    public String describeCurrentStrategy() {
        return this.pruneStrategy.toString();
    }

    private static class CountingDeleter
    implements LongConsumer {
        private static final int NO_VERSION = -1;
        private final LogFile logFile;
        private final FileSystemAbstraction fs;
        private long fromVersion;
        private long toVersion;

        private CountingDeleter(LogFile logFile, FileSystemAbstraction fs) {
            this.logFile = logFile;
            this.fs = fs;
            this.fromVersion = -1L;
            this.toVersion = -1L;
        }

        @Override
        public void accept(long version) {
            this.fromVersion = this.fromVersion == -1L ? version : Math.min(this.fromVersion, version);
            this.toVersion = this.toVersion == -1L ? version : Math.max(this.toVersion, version);
            Path logFilePath = this.logFile.getLogFileForVersion(version);
            try {
                this.fs.deleteFile(logFilePath);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        String describeResult(LogPruneStrategy strategy) {
            String pruned = this.fromVersion == -1L ? "No log version pruned" : (this.fromVersion == this.toVersion ? "Pruned log version " + this.fromVersion : "Pruned log versions " + this.fromVersion + " through " + this.toVersion);
            return pruned + ". The strategy used was '" + strategy + "'. ";
        }
    }
}

