/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.pruning;

import java.io.IOException;
import java.nio.file.Path;
import org.neo4j.kernel.impl.transaction.log.LogFileInformation;
import org.neo4j.kernel.impl.transaction.log.pruning.Threshold;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public final class EntryCountThreshold
implements Threshold {
    private final long maxTransactionCount;
    private final Log log;

    EntryCountThreshold(LogProvider logProvider, long maxTransactionCount) {
        this.log = logProvider.getLog(this.getClass());
        this.maxTransactionCount = maxTransactionCount;
    }

    @Override
    public void init() {
    }

    @Override
    public boolean reached(Path ignored, long version, LogFileInformation source) {
        long nextVersion = version + 1L;
        try {
            long lastTx = source.getFirstEntryId(nextVersion);
            if (lastTx == -1L) {
                this.log.warn("Fail to get id of the first entry in the next transaction log file. Requested version: " + nextVersion);
                return false;
            }
            long highest = source.getLastEntryId();
            return highest - lastTx >= this.maxTransactionCount;
        }
        catch (IOException e) {
            this.log.warn("Error on attempt to get entry ids from transaction log files. Checked version: " + version, (Throwable)e);
            return false;
        }
    }

    public String toString() {
        return this.maxTransactionCount + " entries";
    }
}

