/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.files.checkpoint;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.kernel.impl.transaction.log.LogEntryCursor;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogVersionBridge;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.ReadAheadLogChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableClosablePositionAwareChecksumChannel;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckpointAppender;
import org.neo4j.kernel.impl.transaction.log.checkpoint.DetachedCheckpointAppender;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryDetachedCheckpoint;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogTailInformation;
import org.neo4j.kernel.impl.transaction.log.files.LogVersionVisitor;
import org.neo4j.kernel.impl.transaction.log.files.RangeLogVersionVisitor;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogChannelAllocator;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogFilesContext;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogFilesHelper;
import org.neo4j.kernel.impl.transaction.log.files.checkpoint.CheckpointFile;
import org.neo4j.kernel.impl.transaction.log.files.checkpoint.CheckpointInfo;
import org.neo4j.kernel.impl.transaction.log.files.checkpoint.CheckpointLogChannelAllocator;
import org.neo4j.kernel.impl.transaction.log.files.checkpoint.DetachedLogTailScanner;
import org.neo4j.kernel.impl.transaction.log.rotation.FileLogRotation;
import org.neo4j.kernel.impl.transaction.log.rotation.LogRotation;
import org.neo4j.kernel.impl.transaction.log.rotation.monitor.LogRotationMonitor;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.Log;
import org.neo4j.monitoring.Health;
import org.neo4j.storageengine.api.CommandReaderFactory;
import org.neo4j.storageengine.api.LogVersionRepository;

public class CheckpointLogFile
extends LifecycleAdapter
implements CheckpointFile {
    private final DetachedCheckpointAppender checkpointAppender;
    private final DetachedLogTailScanner logTailScanner;
    private final TransactionLogFilesHelper fileHelper;
    private final TransactionLogChannelAllocator channelAllocator;
    private final TransactionLogFilesContext context;
    private final Log log;
    private final long rotationsSize;
    private LogVersionRepository logVersionRepository;

    public CheckpointLogFile(LogFiles logFiles, TransactionLogFilesContext context) {
        this.context = context;
        this.rotationsSize = (Long)context.getConfig().get(GraphDatabaseInternalSettings.checkpoint_logical_log_rotation_threshold);
        this.fileHelper = new TransactionLogFilesHelper(context.getFileSystem(), logFiles.logFilesDirectory(), "checkpoint");
        this.channelAllocator = new CheckpointLogChannelAllocator(context, this.fileHelper);
        this.logTailScanner = new DetachedLogTailScanner(logFiles, context, this);
        this.log = context.getLogProvider().getLog(this.getClass());
        LogRotationMonitor rotationMonitor = (LogRotationMonitor)context.getMonitors().newMonitor(LogRotationMonitor.class, new String[0]);
        LogRotation checkpointRotation = FileLogRotation.checkpointLogRotation(this, logFiles.getLogFile(), context.getClock(), (Health)context.getDatabaseHealth(), rotationMonitor);
        this.checkpointAppender = new DetachedCheckpointAppender(this.channelAllocator, context, this, checkpointRotation);
    }

    public void start() throws Exception {
        this.checkpointAppender.start();
        this.logVersionRepository = this.context.getLogVersionRepository();
    }

    public void shutdown() throws Exception {
        this.checkpointAppender.shutdown();
    }

    @Override
    public Optional<CheckpointInfo> findLatestCheckpoint() throws IOException {
        return this.findLatestCheckpoint(this.log);
    }

    @Override
    public Optional<CheckpointInfo> findLatestCheckpoint(Log log) throws IOException {
        RangeLogVersionVisitor versionVisitor = new RangeLogVersionVisitor();
        this.fileHelper.accept((LogVersionVisitor)versionVisitor);
        long highestVersion = versionVisitor.getHighestVersion();
        if (highestVersion < 0L) {
            return Optional.empty();
        }
        long lowestVersion = versionVisitor.getLowestVersion();
        VersionAwareLogEntryReader checkpointReader = new VersionAwareLogEntryReader(CommandReaderFactory.NO_COMMANDS, true);
        for (long currentVersion = highestVersion; currentVersion >= lowestVersion; --currentVersion) {
            if (!this.logFileExist(currentVersion)) continue;
            try (PhysicalLogVersionedStoreChannel channel = this.channelAllocator.openLogChannel(currentVersion);
                 ReadAheadLogChannel reader = new ReadAheadLogChannel(channel, LogVersionBridge.NO_MORE_CHANNELS, this.context.getMemoryTracker());
                 LogEntryCursor logEntryCursor = new LogEntryCursor((LogEntryReader)checkpointReader, (ReadableClosablePositionAwareChecksumChannel)reader);){
                LogPosition lastCheckpointLocation;
                log.info("Scanning log file with version %d for checkpoint entries", new Object[]{currentVersion});
                LogEntryDetachedCheckpoint checkpoint = null;
                LogPosition lastLocation = lastCheckpointLocation = reader.getCurrentPosition();
                while (logEntryCursor.next()) {
                    lastCheckpointLocation = lastLocation;
                    LogEntry logEntry = logEntryCursor.get();
                    checkpoint = CheckpointLogFile.verify(logEntry);
                    lastLocation = reader.getCurrentPosition();
                }
                if (checkpoint == null) continue;
                Optional<CheckpointInfo> optional = Optional.of(new CheckpointInfo(checkpoint, lastCheckpointLocation));
                return optional;
            }
        }
        return Optional.empty();
    }

    private boolean logFileExist(long currentVersion) {
        return this.context.getFileSystem().fileExists(this.fileHelper.getLogFileForVersion(currentVersion));
    }

    @Override
    public List<CheckpointInfo> reachableCheckpoints() throws IOException {
        RangeLogVersionVisitor versionVisitor = new RangeLogVersionVisitor();
        this.fileHelper.accept((LogVersionVisitor)versionVisitor);
        long highestVersion = versionVisitor.getHighestVersion();
        if (highestVersion < 0L) {
            return Collections.emptyList();
        }
        VersionAwareLogEntryReader checkpointReader = new VersionAwareLogEntryReader(CommandReaderFactory.NO_COMMANDS, true);
        ArrayList<CheckpointInfo> checkpoints = new ArrayList<CheckpointInfo>();
        for (long currentVersion = versionVisitor.getLowestVersion(); currentVersion <= highestVersion; ++currentVersion) {
            if (!this.logFileExist(currentVersion)) continue;
            try (PhysicalLogVersionedStoreChannel channel = this.channelAllocator.openLogChannel(currentVersion);
                 ReadAheadLogChannel reader = new ReadAheadLogChannel(channel, LogVersionBridge.NO_MORE_CHANNELS, this.context.getMemoryTracker());
                 LogEntryCursor logEntryCursor = new LogEntryCursor((LogEntryReader)checkpointReader, (ReadableClosablePositionAwareChecksumChannel)reader);){
                LogPosition lastCheckpointLocation;
                this.log.info("Scanning log file with version %d for checkpoint entries", new Object[]{currentVersion});
                LogPosition lastLocation = lastCheckpointLocation = reader.getCurrentPosition();
                while (logEntryCursor.next()) {
                    lastCheckpointLocation = lastLocation;
                    LogEntry logEntry = logEntryCursor.get();
                    LogEntryDetachedCheckpoint checkpoint = CheckpointLogFile.verify(logEntry);
                    checkpoints.add(new CheckpointInfo(checkpoint, lastCheckpointLocation));
                    lastLocation = reader.getCurrentPosition();
                }
                continue;
            }
        }
        return checkpoints;
    }

    @Override
    public List<CheckpointInfo> getReachableDetachedCheckpoints() throws IOException {
        return this.reachableCheckpoints();
    }

    @Override
    public CheckpointAppender getCheckpointAppender() {
        return this.checkpointAppender;
    }

    @Override
    public LogTailInformation getTailInformation() {
        return this.logTailScanner.getTailInformation();
    }

    @Override
    public Path getCurrentFile() throws IOException {
        return this.fileHelper.getLogFileForVersion(this.getCurrentDetachedLogVersion());
    }

    @Override
    public Path getDetachedCheckpointFileForVersion(long logVersion) {
        return this.fileHelper.getLogFileForVersion(logVersion);
    }

    @Override
    public Path[] getDetachedCheckpointFiles() throws IOException {
        return this.fileHelper.getMatchedFiles();
    }

    @Override
    public long getCurrentDetachedLogVersion() throws IOException {
        if (this.logVersionRepository != null) {
            return this.logVersionRepository.getCheckpointLogVersion();
        }
        RangeLogVersionVisitor versionVisitor = new RangeLogVersionVisitor();
        this.fileHelper.accept((LogVersionVisitor)versionVisitor);
        return versionVisitor.getHighestVersion();
    }

    @Override
    public long getDetachedCheckpointLogFileVersion(Path checkpointLogFile) {
        return TransactionLogFilesHelper.getLogVersion((Path)checkpointLogFile);
    }

    private static LogEntryDetachedCheckpoint verify(LogEntry logEntry) {
        if (logEntry instanceof LogEntryDetachedCheckpoint) {
            return (LogEntryDetachedCheckpoint)logEntry;
        }
        throw new UnsupportedOperationException("Expected to observe only checkpoint entries, but: `" + logEntry + "` was found.");
    }

    @Override
    public boolean rotationNeeded() {
        long position = this.checkpointAppender.getCurrentPosition();
        return position >= this.rotationsSize;
    }

    @Override
    public synchronized Path rotate() throws IOException {
        return this.checkpointAppender.rotate();
    }

    @Override
    public long getLowestLogVersion() {
        return this.visitLogFiles(new RangeLogVersionVisitor()).getLowestVersion();
    }

    @Override
    public long getHighestLogVersion() {
        return this.visitLogFiles(new RangeLogVersionVisitor()).getHighestVersion();
    }

    private <V extends LogVersionVisitor> V visitLogFiles(V visitor) {
        try {
            for (Path file : this.fileHelper.getMatchedFiles()) {
                visitor.visit(file, TransactionLogFilesHelper.getLogVersion((Path)file));
            }
            return visitor;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

