/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.config;

import org.neo4j.configuration.Config;
import org.neo4j.gis.spatial.index.curves.PartialOverlapConfiguration;
import org.neo4j.gis.spatial.index.curves.SpaceFillingCurveConfiguration;
import org.neo4j.gis.spatial.index.curves.StandardConfiguration;
import org.neo4j.kernel.impl.index.schema.config.EnvelopeSettings;
import org.neo4j.kernel.impl.index.schema.config.SpaceFillingCurveSettings;
import org.neo4j.kernel.impl.index.schema.config.SpatialIndexSettings;

public final class SpaceFillingCurveSettingsFactory {
    private SpaceFillingCurveSettingsFactory() {
    }

    static SpaceFillingCurveSettings fromConfig(EnvelopeSettings envelopeSettings) {
        return new SpaceFillingCurveSettings(envelopeSettings.getCrs().getDimension(), envelopeSettings.asEnvelope());
    }

    public static SpaceFillingCurveConfiguration getConfiguredSpaceFillingCurveConfiguration(Config config) {
        int extraLevels = (Integer)config.get(SpatialIndexSettings.space_filling_curve_extra_levels);
        double topThreshold = (Double)config.get(SpatialIndexSettings.space_filling_curve_top_threshold);
        double bottomThreshold = (Double)config.get(SpatialIndexSettings.space_filling_curve_bottom_threshold);
        if (topThreshold == 0.0 || bottomThreshold == 0.0) {
            return new StandardConfiguration(extraLevels);
        }
        return new PartialOverlapConfiguration(extraLevels, topThreshold, bottomThreshold);
    }
}

