/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.neo4j.configuration.GroupSetting;
import org.neo4j.configuration.SettingConstraints;
import org.neo4j.configuration.SettingValueParser;
import org.neo4j.configuration.SettingValueParsers;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.values.storable.CoordinateReferenceSystem;

public class CrsConfig
extends GroupSetting {
    private static final String PREFIX = "unsupported.dbms.db.spatial.crs";
    public final Setting<List<Double>> min;
    public final Setting<List<Double>> max;
    public final CoordinateReferenceSystem crs;

    public static CrsConfig group(CoordinateReferenceSystem crs) {
        return new CrsConfig(crs.getName());
    }

    private CrsConfig(String name) {
        super(name);
        this.crs = CoordinateReferenceSystem.byName((String)name);
        ArrayList<Double> defaultValue = new ArrayList<Double>(Collections.nCopies(this.crs.getDimension(), Double.NaN));
        this.min = this.getBuilder("min", SettingValueParsers.listOf((SettingValueParser)SettingValueParsers.DOUBLE), defaultValue).addConstraint(SettingConstraints.size((int)this.crs.getDimension())).build();
        this.max = this.getBuilder("max", SettingValueParsers.listOf((SettingValueParser)SettingValueParsers.DOUBLE), defaultValue).addConstraint(SettingConstraints.size((int)this.crs.getDimension())).build();
    }

    public CrsConfig() {
        super(null);
        this.min = null;
        this.max = null;
        this.crs = null;
    }

    public String getPrefix() {
        return PREFIX;
    }
}

