/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.util.Arrays;
import java.util.EnumSet;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.schema.IndexCapability;
import org.neo4j.internal.schema.IndexOrder;
import org.neo4j.internal.schema.IndexOrderCapability;
import org.neo4j.internal.schema.IndexQuery;
import org.neo4j.values.storable.ValueCategory;

class QueryValidator {
    QueryValidator() {
    }

    static void validateOrder(IndexCapability capability, IndexOrder indexOrder, PropertyIndexQuery[] predicates) {
        if (indexOrder != IndexOrder.NONE) {
            ValueCategory valueCategory = predicates[0].valueGroup().category();
            IndexOrderCapability orderCapability = capability.orderCapability(new ValueCategory[]{valueCategory});
            if (indexOrder == IndexOrder.ASCENDING && !orderCapability.supportsAsc() || indexOrder == IndexOrder.DESCENDING && !orderCapability.supportsDesc()) {
                throw new UnsupportedOperationException(String.format("Tried to query index with unsupported order %s. For query %s supports ascending: %b, supports descending: %b.", indexOrder, Arrays.toString(predicates), orderCapability.supportsAsc(), orderCapability.supportsDesc()));
            }
        }
    }

    static void validateCompositeQuery(PropertyIndexQuery[] predicates) {
        String illegalQueryMessage = "Tried to query index with illegal composite query.";
        IndexQuery.IndexQueryType prev = null;
        for (PropertyIndexQuery predicate : predicates) {
            IndexQuery.IndexQueryType current = predicate.type();
            if (EnumSet.of(IndexQuery.IndexQueryType.ALL_ENTRIES, IndexQuery.IndexQueryType.STRING_CONTAINS, IndexQuery.IndexQueryType.STRING_SUFFIX).contains(current) && predicates.length > 1) {
                throw new IllegalArgumentException(String.format("%s %s queries are not allowed in composite query. Query was: %s ", "Tried to query index with illegal composite query.", current, Arrays.toString(predicates)));
            }
            if (EnumSet.of(IndexQuery.IndexQueryType.EXISTS, IndexQuery.IndexQueryType.RANGE, IndexQuery.IndexQueryType.STRING_PREFIX).contains(prev) && current != IndexQuery.IndexQueryType.EXISTS) {
                throw new IllegalArgumentException(String.format("%s Composite query must have decreasing precision. Query was: %s ", "Tried to query index with illegal composite query.", Arrays.toString(predicates)));
            }
            prev = current;
        }
    }
}

