/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import org.neo4j.index.internal.gbptree.Writer;
import org.neo4j.io.IOUtils;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.impl.index.schema.ConflictDetectingValueMerger;
import org.neo4j.kernel.impl.index.schema.IndexUpdateIgnoreStrategy;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.NullValue;
import org.neo4j.kernel.impl.index.schema.ThrowingConflictDetector;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.ValueIndexEntryUpdate;
import org.neo4j.values.storable.Value;

class NativeIndexUpdater<KEY extends NativeIndexKey<KEY>>
implements IndexUpdater {
    private final KEY treeKey;
    private final IndexUpdateIgnoreStrategy ignoreStrategy;
    private final ConflictDetectingValueMerger<KEY, Value[]> conflictDetectingValueMerger = new ThrowingConflictDetector(true);
    private Writer<KEY, NullValue> writer;
    private boolean closed = true;

    NativeIndexUpdater(KEY treeKey, IndexUpdateIgnoreStrategy ignoreStrategy) {
        this.treeKey = treeKey;
        this.ignoreStrategy = ignoreStrategy;
    }

    NativeIndexUpdater<KEY> initialize(Writer<KEY, NullValue> writer) {
        if (!this.closed) {
            throw new IllegalStateException("Updater still open");
        }
        this.writer = writer;
        this.closed = false;
        return this;
    }

    public void process(IndexEntryUpdate<?> update) throws IndexEntryConflictException {
        this.assertOpen();
        ValueIndexEntryUpdate valueUpdate = this.asValueUpdate(update);
        NativeIndexUpdater.processUpdate(this.treeKey, valueUpdate, this.writer, this.conflictDetectingValueMerger, this.ignoreStrategy);
    }

    public void close() {
        this.closed = true;
        IOUtils.closeAllUnchecked((AutoCloseable[])new Writer[]{this.writer});
    }

    private void assertOpen() {
        if (this.closed) {
            throw new IllegalStateException("Updater has been closed");
        }
    }

    static <KEY extends NativeIndexKey<KEY>> void processUpdate(KEY treeKey, ValueIndexEntryUpdate<?> update, Writer<KEY, NullValue> writer, ConflictDetectingValueMerger<KEY, Value[]> conflictDetectingValueMerger, IndexUpdateIgnoreStrategy ignoreStrategy) throws IndexEntryConflictException {
        switch (update.updateMode()) {
            case REMOVED: {
                NativeIndexUpdater.processRemove(treeKey, update.getEntityId(), update.values(), writer, ignoreStrategy);
                break;
            }
            case CHANGED: {
                NativeIndexUpdater.processRemove(treeKey, update.getEntityId(), update.beforeValues(), writer, ignoreStrategy);
            }
            case ADDED: {
                NativeIndexUpdater.processAdd(treeKey, update.getEntityId(), update.values(), writer, conflictDetectingValueMerger, ignoreStrategy);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    private static <KEY extends NativeIndexKey<KEY>> void processRemove(KEY treeKey, long entityId, Value[] values, Writer<KEY, NullValue> writer, IndexUpdateIgnoreStrategy ignoreStrategy) {
        if (ignoreStrategy.ignore(values)) {
            return;
        }
        NativeIndexUpdater.initializeKeyFromUpdate(treeKey, entityId, values);
        writer.remove(treeKey);
    }

    private static <KEY extends NativeIndexKey<KEY>> void processAdd(KEY treeKey, long entityId, Value[] values, Writer<KEY, NullValue> writer, ConflictDetectingValueMerger<KEY, Value[]> conflictDetectingValueMerger, IndexUpdateIgnoreStrategy ignoreStrategy) throws IndexEntryConflictException {
        if (ignoreStrategy.ignore(values)) {
            return;
        }
        NativeIndexUpdater.initializeKeyFromUpdate(treeKey, entityId, values);
        conflictDetectingValueMerger.controlConflictDetection(treeKey);
        writer.merge(treeKey, (Object)NullValue.INSTANCE, conflictDetectingValueMerger);
        conflictDetectingValueMerger.checkConflict(values);
    }

    static <KEY extends NativeIndexKey<KEY>> void initializeKeyFromUpdate(KEY treeKey, long entityId, Value[] values) {
        treeKey.initialize(entityId);
        for (int i = 0; i < values.length; ++i) {
            treeKey.initFromValue(i, values[i], NativeIndexKey.Inclusion.NEUTRAL);
        }
    }
}

