/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.http.cypher.format.jolt;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.Iterator;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.server.http.cypher.format.jolt.JoltRelationship;
import org.neo4j.server.http.cypher.format.jolt.Sigil;

final class JoltPathSerializer
extends StdSerializer<Path> {
    JoltPathSerializer() {
        super(Path.class);
    }

    public void serialize(Path path, JsonGenerator generator, SerializerProvider provider) throws IOException {
        generator.writeStartObject((Object)path);
        generator.writeFieldName(Sigil.PATH.getValue());
        generator.writeStartArray();
        Iterator it = path.iterator();
        long lastNodeId = 0L;
        while (it.hasNext()) {
            Entity entity = (Entity)it.next();
            if (entity instanceof Node) {
                Node node = (Node)entity;
                lastNodeId = node.getId();
                generator.writeObject((Object)node);
                continue;
            }
            if (!(entity instanceof Relationship)) continue;
            Relationship rel = (Relationship)entity;
            if (rel.getStartNodeId() != lastNodeId) {
                generator.writeObject((Object)JoltRelationship.fromRelationshipReversed(rel));
                continue;
            }
            generator.writeObject((Object)rel);
        }
        generator.writeEndArray();
        generator.writeEndObject();
    }
}

