/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.http.cypher;

import java.util.concurrent.TimeUnit;
import org.neo4j.internal.kernel.api.connectioninfo.ClientConnectionInfo;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;

public class TransitionalTxManagementKernelTransaction {
    private final GraphDatabaseAPI db;
    private final KernelTransaction.Type type;
    private final LoginContext loginContext;
    private final long customTransactionTimeout;
    private final ClientConnectionInfo connectionInfo;
    private InternalTransaction tx;

    TransitionalTxManagementKernelTransaction(GraphDatabaseAPI db, KernelTransaction.Type type, LoginContext loginContext, ClientConnectionInfo connectionInfo, long customTransactionTimeout) {
        this.db = db;
        this.type = type;
        this.loginContext = loginContext;
        this.customTransactionTimeout = customTransactionTimeout;
        this.connectionInfo = connectionInfo;
        this.tx = this.startTransaction();
    }

    public InternalTransaction getInternalTransaction() {
        return this.tx;
    }

    public void terminate() {
        this.tx.terminate();
    }

    public void rollback() {
        this.tx.rollback();
    }

    public void commit() {
        this.tx.commit();
    }

    void closeTransactionForPeriodicCommit() {
        this.tx.close();
    }

    void reopenAfterPeriodicCommit() {
        this.tx = this.startTransaction();
    }

    private InternalTransaction startTransaction() {
        return this.customTransactionTimeout > 0L ? this.db.beginTransaction(this.type, this.loginContext, this.connectionInfo, this.customTransactionTimeout, TimeUnit.MILLISECONDS) : this.db.beginTransaction(this.type, this.loginContext, this.connectionInfo);
    }
}

