macro( DEBUG_INCLUDE_DIRECTORIES _TAG )
    if($ENV{DEBUG_VERBOSE})
            message(" ")
            message("--------------------------------------------------------")
            message("[DEBUG:INCL_DIR:${_TAG}] INCLUDE_DIRECTORIES:")
            message("--------------------------------------------------------")
            get_property(debug_dirs DIRECTORY ${CMAKE_CURRENT_SOURCE_DIR} PROPERTY INCLUDE_DIRECTORIES)
            foreach(dir ${debug_dirs})
                    message("${dir}")
            endforeach()
    endif()
endmacro()

macro(DEBUG_VAR)
    if($ENV{DEBUG_VERBOSE})
            message(" ")
            foreach(var ${ARGN})
                message("[DEBUG:VAR:${var}] ${${var}}")
            endforeach(var)
    endif()
endmacro()

macro(DEBUG_GLOBAL_VAR)
    if($ENV{DEBUG_VERBOSE})
            message(" ")
            foreach(var ${ARGN})
                get_property(temp GLOBAL PROPERTY ${var} )
                message("[DEBUG:GLOBAL_VAR:${var}] ${temp}")
            endforeach(var)
    endif()
endmacro()

macro(DEBUG_MESSAGE _msg)
    message(" ")
    if($ENV{DEBUG_VERBOSE})
            message("[DEBUG:MSG] ${_msg}")
    endif()
endmacro()

