/*
 * Copyright (c) 2010-2022 Belledonne Communications SARL.
 *
 * This file is part of mediastreamer2
 * (see https://gitlab.linphone.org/BC/public/mediastreamer2).
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

#pragma once

#include "videotoolbox-utils.h"

namespace mediastreamer {

class VideoToolboxH264Utilities : public VideoToolboxUtilities {
public:
	CMVideoCodecType getCodecType() const override;
	CFStringRef getDefaultProfileLevel() const override;

private:
	void getParameterSet(const CMFormatDescriptionRef format,
	                     size_t offset,
	                     const uint8_t *&parameterSet,
	                     size_t &parameterSetSize,
	                     size_t &parameterSetsCount) const override;
	CMFormatDescriptionRef createFormatDescription(size_t parameterSetsCount,
	                                               const uint8_t *parameterSets[],
	                                               const size_t parameterSetSizes[]) const override;
};

} // namespace mediastreamer
