/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.sql.tests.java.sql;

import java.sql.Date;
import java.util.Calendar;
import java.util.TimeZone;
import junit.framework.TestCase;

/*
 * Exception performing whole class analysis ignored.
 */
public class DateTest
extends TestCase {
    static Calendar aCal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
    static long TIME_AN_HOUR = 3600000L;
    static long TIME_EPOCH = 0L;
    static long TIME_NOW = System.currentTimeMillis();
    static long TIME_NEGATIVE = -3600001L;
    static long TIME_TESTDATE1 = DateTest.getTime((int)1999, (int)11, (int)31, (int)23, (int)59, (int)59);
    static long TIME_TESTDATE2 = DateTest.getTime((int)2010, (int)5, (int)10, (int)20, (int)3, (int)16);
    static long TIME_TESTDATE3 = DateTest.getTime((int)1931, (int)3, (int)21, (int)1, (int)25, (int)1);
    static long TIME_LOWERLIMIT = Long.MIN_VALUE;
    static long TIME_UPPERLIMIT = Long.MAX_VALUE;
    static String SQL_DATESTRING1 = "1999-12-31";
    static String SQL_DATESTRING2 = "2010-06-10";
    static String SQL_DATESTRING3 = "1931-04-21";
    static String SQL_EPOCHSTRING = "1970-01-01";
    static String SQL_DATEDAY1 = "1970-01-02";
    static String SQL_NEGATIVE = "1969-12-31";
    static long[] TIME_ARRAY = new long[]{TIME_TESTDATE1, TIME_TESTDATE2, TIME_TESTDATE3, TIME_NEGATIVE, TIME_EPOCH};
    static String[] SQL_DATEARRAY = new String[]{SQL_DATESTRING1, SQL_DATESTRING2, SQL_DATESTRING3, SQL_NEGATIVE, SQL_EPOCHSTRING};
    static String[] SQL_NYARRAY = new String[]{"1999-12-31", "2010-06-10", "1931-04-20", "1969-12-31", "1969-12-31"};
    static String[] SQL_JAPANARRAY = new String[]{"2000-01-01", "2010-06-11", "1931-04-21", "1970-01-01", "1970-01-01"};
    static String[][] SQL_TZ_DATEARRAYS = new String[][]{SQL_DATEARRAY, SQL_NYARRAY, SQL_JAPANARRAY};
    static String TZ_LONDON = "Europe/London";
    static String TZ_PACIFIC = "America/Los_Angeles";
    static String TZ_JAPAN = "Asia/Tokyo";
    static String[] TIMEZONES = new String[]{TZ_LONDON, TZ_PACIFIC, TZ_JAPAN};

    private static long getTime(int year, int month, int date, int hour, int minute, int second) {
        aCal.set(year, month, date, hour, minute, second);
        return aCal.getTimeInMillis();
    }

    public void testDateintintint() {
        int[] init1 = new int[]{99, 8099, 9000, 99999, 99, 99, -1, -100};
        int[] nArray = new int[8];
        nArray[0] = 11;
        nArray[4] = 999;
        nArray[7] = -111;
        int[] init2 = nArray;
        int[] nArray2 = new int[8];
        nArray2[0] = 31;
        nArray2[5] = 999;
        nArray2[7] = -999;
        int[] init3 = nArray2;
        int i = 0;
        while (i < init1.length) {
            Date theDate = new Date(init1[i], init2[i], init3[i]);
            DateTest.assertNotNull((Object)theDate);
            ++i;
        }
    }

    public void testDatelong() {
        long[] init1;
        long[] lArray = init1 = new long[]{TIME_TESTDATE1, TIME_TESTDATE2, TIME_TESTDATE3, TIME_NEGATIVE, TIME_LOWERLIMIT, TIME_UPPERLIMIT, TIME_EPOCH, TIME_NOW};
        int n = 0;
        int n2 = lArray.length;
        while (n < n2) {
            long element = lArray[n];
            Date theDate = new Date(element);
            DateTest.assertNotNull((Object)theDate);
            ++n;
        }
    }

    public void testGetHours() {
        Date theDate = new Date(TIME_TESTDATE1);
        try {
            theDate.getHours();
            DateTest.fail((String)"Should throw IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGetMinutes() {
        Date theDate = new Date(TIME_TESTDATE1);
        try {
            theDate.getMinutes();
            DateTest.fail((String)"Should throw IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGetSeconds() {
        Date theDate = new Date(TIME_TESTDATE1);
        try {
            theDate.getSeconds();
            DateTest.fail((String)"Should throw IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testSetHours() {
        Date theDate = new Date(TIME_TESTDATE1);
        try {
            theDate.setHours(22);
            DateTest.fail((String)"Should throw IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testSetMinutes() {
        Date theDate = new Date(TIME_TESTDATE1);
        try {
            theDate.setMinutes(54);
            DateTest.fail((String)"Should throw IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testSetSeconds() {
        Date theDate = new Date(TIME_TESTDATE1);
        try {
            theDate.setSeconds(36);
            DateTest.fail((String)"Should throw IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testToString() {
        TimeZone.setDefault(TimeZone.getTimeZone("GMT"));
        int i = 0;
        while (i < TIME_ARRAY.length) {
            Date theDate = new Date(TIME_ARRAY[i]);
            DateTest.assertEquals((String)SQL_DATEARRAY[i], (String)theDate.toString());
            ++i;
        }
    }

    public void testSetTimelong() {
        int i = 0;
        while (i < TIMEZONES.length) {
            this.testSetTimelong(TIMEZONES[i], SQL_TZ_DATEARRAYS[i]);
            ++i;
        }
    }

    private void testSetTimelong(String timeZoneName, String[] dateArray) {
        if (timeZoneName != null) {
            TimeZone.setDefault(TimeZone.getTimeZone(timeZoneName));
        }
        Date theDate = new Date(TIME_TESTDATE1);
        int i = 0;
        while (i < dateArray.length) {
            theDate.setTime(TIME_ARRAY[i]);
            DateTest.assertEquals((String)dateArray[i], (String)theDate.toString());
            ++i;
        }
    }

    public void testValueOf() {
        Date theDate;
        String element;
        String SQL_NOTVALID1 = "ABCDEF";
        String SQL_NOTVALID2 = "12321.43.56";
        Object SQL_NOTVALID3 = null;
        String[] SQL_INVALIDARRAY = new String[]{SQL_NOTVALID1, SQL_NOTVALID2, SQL_NOTVALID3};
        String[] stringArray = SQL_DATEARRAY;
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            element = stringArray[n];
            theDate = Date.valueOf(element);
            DateTest.assertEquals((String)element, (String)theDate.toString());
            ++n;
        }
        stringArray = SQL_INVALIDARRAY;
        n = 0;
        n2 = stringArray.length;
        while (n < n2) {
            element = stringArray[n];
            try {
                theDate = Date.valueOf(element);
                DateTest.fail((String)"Should throw IllegalArgumentException.");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            ++n;
        }
    }

    public void test_valueOf_IllegalArgumentException() {
        try {
            Date.valueOf("1996-10-07-01");
            DateTest.fail((String)"should throw NumberFormatException");
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            Date.valueOf("-10-07-01");
            DateTest.fail((String)"should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            Date.valueOf("--01");
            DateTest.fail((String)"should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            Date.valueOf("1991--");
            DateTest.fail((String)"should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            Date.valueOf("-01-");
            DateTest.fail((String)"should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            Date.valueOf("-10-w2-01");
            DateTest.fail((String)"should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            Date.valueOf("07-w2-");
            DateTest.fail((String)"should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            Date.valueOf("1997-w2-w2");
            DateTest.fail((String)"should throw NumberFormatException");
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            Date.valueOf("1996--01");
            DateTest.fail((String)"should throw NumberFormatException");
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }
}

