/**
 * A JavaScript implementation of the SHA family of hashes - defined in FIPS PUB 180-4, FIPS PUB 202,
 * and SP 800-185 - as well as the corresponding HMAC implementation as defined in FIPS PUB 198-1.
 *
 * Copyright 2008-2022 Brian Turek, 1998-2009 Paul Johnston & Contributors
 * Distributed under the BSD License
 * See http://caligatio.github.com/jsSHA/ for more information
 *
 * Two ECMAScript polyfill functions carry the following license:
 *
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0
 *
 * THIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, EITHER EXPRESS OR IMPLIED,
 * INCLUDING WITHOUT LIMITATION ANY IMPLIED WARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,
 * MERCHANTABLITY OR NON-INFRINGEMENT.
 *
 * See the Apache Version 2.0 License for specific language governing permissions and limitations under the License.
 */
!function(t,r){"object"==typeof exports&&"undefined"!=typeof module?module.exports=r():"function"==typeof define&&define.amd?define(r):(t="undefined"!=typeof globalThis?globalThis:t||self).jsSHA=r()}(this,(function(){"use strict";var t=function(r,n){return t=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(t,r){t.__proto__=r}||function(t,r){for(var n in r)Object.prototype.hasOwnProperty.call(r,n)&&(t[n]=r[n])},t(r,n)};var r="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/",n="ARRAYBUFFER not supported by this environment",i="UINT8ARRAY not supported by this environment";function e(t,r,n,i){var e,o,u,s=r||[0],f=(n=n||0)>>>3,h=-1===i?3:0;for(e=0;e<t.length;e+=1)o=(u=e+f)>>>2,s.length<=o&&s.push(0),s[o]|=t[e]<<8*(h+i*(u%4));return{value:s,binLen:8*t.length+n}}function o(t,o,u){switch(o){case"UTF8":case"UTF16BE":case"UTF16LE":break;default:throw new Error("encoding must be UTF8, UTF16BE, or UTF16LE")}switch(t){case"HEX":return function(t,r,n){return function(t,r,n,i){var e,o,u,s;if(0!=t.length%2)throw new Error("String of HEX type must be in byte increments");var f=r||[0],h=(n=n||0)>>>3,a=-1===i?3:0;for(e=0;e<t.length;e+=2){if(o=parseInt(t.substr(e,2),16),isNaN(o))throw new Error("String of HEX type contains invalid characters");for(u=(s=(e>>>1)+h)>>>2;f.length<=u;)f.push(0);f[u]|=o<<8*(a+i*(s%4))}return{value:f,binLen:4*t.length+n}}(t,r,n,u)};case"TEXT":return function(t,r,n){return function(t,r,n,i,e){var o,u,s,f,h,a,c,w,E=0,v=n||[0],l=(i=i||0)>>>3;if("UTF8"===r)for(c=-1===e?3:0,s=0;s<t.length;s+=1)for(u=[],128>(o=t.charCodeAt(s))?u.push(o):2048>o?(u.push(192|o>>>6),u.push(128|63&o)):55296>o||57344<=o?u.push(224|o>>>12,128|o>>>6&63,128|63&o):(s+=1,o=65536+((1023&o)<<10|1023&t.charCodeAt(s)),u.push(240|o>>>18,128|o>>>12&63,128|o>>>6&63,128|63&o)),f=0;f<u.length;f+=1){for(h=(a=E+l)>>>2;v.length<=h;)v.push(0);v[h]|=u[f]<<8*(c+e*(a%4)),E+=1}else for(c=-1===e?2:0,w="UTF16LE"===r&&1!==e||"UTF16LE"!==r&&1===e,s=0;s<t.length;s+=1){for(o=t.charCodeAt(s),!0===w&&(o=(f=255&o)<<8|o>>>8),h=(a=E+l)>>>2;v.length<=h;)v.push(0);v[h]|=o<<8*(c+e*(a%4)),E+=2}return{value:v,binLen:8*E+i}}(t,o,r,n,u)};case"B64":return function(t,n,i){return function(t,n,i,e){var o,u,s,f,h,a,c=0,w=n||[0],E=(i=i||0)>>>3,v=-1===e?3:0,l=t.indexOf("=");if(-1===t.search(/^[a-zA-Z0-9=+/]+$/))throw new Error("Invalid character in base-64 string");if(t=t.replace(/=/g,""),-1!==l&&l<t.length)throw new Error("Invalid '=' found in base-64 string");for(o=0;o<t.length;o+=4){for(f=t.substr(o,4),s=0,u=0;u<f.length;u+=1)s|=r.indexOf(f.charAt(u))<<18-6*u;for(u=0;u<f.length-1;u+=1){for(h=(a=c+E)>>>2;w.length<=h;)w.push(0);w[h]|=(s>>>16-8*u&255)<<8*(v+e*(a%4)),c+=1}}return{value:w,binLen:8*c+i}}(t,n,i,u)};case"BYTES":return function(t,r,n){return function(t,r,n,i){var e,o,u,s,f=r||[0],h=(n=n||0)>>>3,a=-1===i?3:0;for(o=0;o<t.length;o+=1)e=t.charCodeAt(o),u=(s=o+h)>>>2,f.length<=u&&f.push(0),f[u]|=e<<8*(a+i*(s%4));return{value:f,binLen:8*t.length+n}}(t,r,n,u)};case"ARRAYBUFFER":try{new ArrayBuffer(0)}catch(t){throw new Error(n)}return function(t,r,n){return function(t,r,n,i){return e(new Uint8Array(t),r,n,i)}(t,r,n,u)};case"UINT8ARRAY":try{new Uint8Array(0)}catch(t){throw new Error(i)}return function(t,r,n){return e(t,r,n,u)};default:throw new Error("format must be HEX, TEXT, B64, BYTES, ARRAYBUFFER, or UINT8ARRAY")}}function u(t,e,o,u){switch(t){case"HEX":return function(t){return function(t,r,n,i){var e,o,u="0123456789abcdef",s="",f=r/8,h=-1===n?3:0;for(e=0;e<f;e+=1)o=t[e>>>2]>>>8*(h+n*(e%4)),s+=u.charAt(o>>>4&15)+u.charAt(15&o);return i.outputUpper?s.toUpperCase():s}(t,e,o,u)};case"B64":return function(t){return function(t,n,i,e){var o,u,s,f,h,a="",c=n/8,w=-1===i?3:0;for(o=0;o<c;o+=3)for(f=o+1<c?t[o+1>>>2]:0,h=o+2<c?t[o+2>>>2]:0,s=(t[o>>>2]>>>8*(w+i*(o%4))&255)<<16|(f>>>8*(w+i*((o+1)%4))&255)<<8|h>>>8*(w+i*((o+2)%4))&255,u=0;u<4;u+=1)a+=8*o+6*u<=n?r.charAt(s>>>6*(3-u)&63):e.b64Pad;return a}(t,e,o,u)};case"BYTES":return function(t){return function(t,r,n){var i,e,o="",u=r/8,s=-1===n?3:0;for(i=0;i<u;i+=1)e=t[i>>>2]>>>8*(s+n*(i%4))&255,o+=String.fromCharCode(e);return o}(t,e,o)};case"ARRAYBUFFER":try{new ArrayBuffer(0)}catch(t){throw new Error(n)}return function(t){return function(t,r,n){var i,e=r/8,o=new ArrayBuffer(e),u=new Uint8Array(o),s=-1===n?3:0;for(i=0;i<e;i+=1)u[i]=t[i>>>2]>>>8*(s+n*(i%4))&255;return o}(t,e,o)};case"UINT8ARRAY":try{new Uint8Array(0)}catch(t){throw new Error(i)}return function(t){return function(t,r,n){var i,e=r/8,o=-1===n?3:0,u=new Uint8Array(e);for(i=0;i<e;i+=1)u[i]=t[i>>>2]>>>8*(o+n*(i%4))&255;return u}(t,e,o)};default:throw new Error("format must be HEX, B64, BYTES, ARRAYBUFFER, or UINT8ARRAY")}}function s(t){var r={outputUpper:!1,b64Pad:"=",outputLen:-1},n=t||{},i="Output length must be a multiple of 8";if(r.outputUpper=n.outputUpper||!1,n.b64Pad&&(r.b64Pad=n.b64Pad),n.outputLen){if(n.outputLen%8!=0)throw new Error(i);r.outputLen=n.outputLen}else if(n.shakeLen){if(n.shakeLen%8!=0)throw new Error(i);r.outputLen=n.shakeLen}if("boolean"!=typeof r.outputUpper)throw new Error("Invalid outputUpper formatting option");if("string"!=typeof r.b64Pad)throw new Error("Invalid b64Pad formatting option");return r}function f(t,r){return t<<r|t>>>32-r}function h(t,r,n){return t^r^n}function a(t,r,n){return t&r^t&n^r&n}function c(t,r){var n=(65535&t)+(65535&r);return(65535&(t>>>16)+(r>>>16)+(n>>>16))<<16|65535&n}function w(t,r,n,i,e){var o=(65535&t)+(65535&r)+(65535&n)+(65535&i)+(65535&e);return(65535&(t>>>16)+(r>>>16)+(n>>>16)+(i>>>16)+(e>>>16)+(o>>>16))<<16|65535&o}function E(t){return[1732584193,4023233417,2562383102,271733878,3285377520]}function v(t,r){var n,i,e,o,u,s,E,v,l=[];for(n=r[0],i=r[1],e=r[2],o=r[3],u=r[4],E=0;E<80;E+=1)l[E]=E<16?t[E]:f(l[E-3]^l[E-8]^l[E-14]^l[E-16],1),s=E<20?w(f(n,5),(v=i)&e^~v&o,u,1518500249,l[E]):E<40?w(f(n,5),h(i,e,o),u,1859775393,l[E]):E<60?w(f(n,5),a(i,e,o),u,2400959708,l[E]):w(f(n,5),h(i,e,o),u,3395469782,l[E]),u=o,o=e,e=f(i,30),i=n,n=s;return r[0]=c(n,r[0]),r[1]=c(i,r[1]),r[2]=c(e,r[2]),r[3]=c(o,r[3]),r[4]=c(u,r[4]),r}function l(t,r,n,i){for(var e,o=15+(r+65>>>9<<4),u=r+n;t.length<=o;)t.push(0);for(t[r>>>5]|=128<<24-r%32,t[o]=4294967295&u,t[o-1]=u/4294967296|0,e=0;e<t.length;e+=16)i=v(t.slice(e,e+16),i);return i}return function(r){function n(t,n,i){var e=this;if("SHA-1"!==t)throw new Error("Chosen SHA variant is not supported");var u=i||{};return(e=r.call(this,t,n,i)||this).t=!0,e.i=e.o,e.u=-1,e.h=o(e.v,e.l,e.u),e.A=v,e.p=function(t){return t.slice()},e.U=E,e.T=l,e.R=[1732584193,4023233417,2562383102,271733878,3285377520],e.m=512,e.F=160,e.g=!1,u.hmacKey&&e.B(function(t,r,n,i){var e=t+" must include a value and format";if(!r){if(!i)throw new Error(e);return i}if(void 0===r.value||!r.format)throw new Error(e);return o(r.format,r.encoding||"UTF8",n)(r.value)}("hmacKey",u.hmacKey,e.u)),e}return function(r,n){if("function"!=typeof n&&null!==n)throw new TypeError("Class extends value "+String(n)+" is not a constructor or null");function i(){this.constructor=r}t(r,n),r.prototype=null===n?Object.create(n):(i.prototype=n.prototype,new i)}(n,r),n}(function(){function t(t,r,n){var i=n||{};if(this.v=r,this.l=i.encoding||"UTF8",this.numRounds=i.numRounds||1,isNaN(this.numRounds)||this.numRounds!==parseInt(this.numRounds,10)||1>this.numRounds)throw new Error("numRounds must a integer >= 1");this.Y=t,this.C=[],this.I=0,this.H=!1,this.L=0,this.S=!1,this.N=[],this.X=[]}return t.prototype.update=function(t){var r,n=0,i=this.m>>>5,e=this.h(t,this.C,this.I),o=e.binLen,u=e.value,s=o>>>5;for(r=0;r<s;r+=i)n+this.m<=o&&(this.R=this.A(u.slice(r,r+i),this.R),n+=this.m);return this.L+=n,this.C=u.slice(n>>>5),this.I=o%this.m,this.H=!0,this},t.prototype.getHash=function(t,r){var n,i,e=this.F,o=s(r);if(this.g){if(-1===o.outputLen)throw new Error("Output length must be specified in options");e=o.outputLen}var f=u(t,e,this.u,o);if(this.S&&this.i)return f(this.i(o));for(i=this.T(this.C.slice(),this.I,this.L,this.p(this.R),e),n=1;n<this.numRounds;n+=1)this.g&&e%32!=0&&(i[i.length-1]&=16777215>>>24-e%32),i=this.T(i,e,0,this.U(this.Y),e);return f(i)},t.prototype.setHMACKey=function(t,r,n){if(!this.t)throw new Error("Variant does not support HMAC");if(this.H)throw new Error("Cannot set MAC key after calling update");var i=o(r,(n||{}).encoding||"UTF8",this.u);this.B(i(t))},t.prototype.B=function(t){var r,n=this.m>>>3,i=n/4-1;if(1!==this.numRounds)throw new Error("Cannot set numRounds with MAC");if(this.S)throw new Error("MAC key already set");for(n<t.binLen/8&&(t.value=this.T(t.value,t.binLen,0,this.U(this.Y),this.F));t.value.length<=i;)t.value.push(0);for(r=0;r<=i;r+=1)this.N[r]=909522486^t.value[r],this.X[r]=1549556828^t.value[r];this.R=this.A(this.N,this.R),this.L=this.m,this.S=!0},t.prototype.getHMAC=function(t,r){var n=s(r);return u(t,this.F,this.u,n)(this.o())},t.prototype.o=function(){var t;if(!this.S)throw new Error("Cannot call getHMAC without first setting MAC key");var r=this.T(this.C.slice(),this.I,this.L,this.p(this.R),this.F);return t=this.A(this.X,this.U(this.Y)),t=this.T(r,this.F,this.m,t,this.F)},t}())}));
