/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.view.swing.tree;

import com.jsql.model.bean.database.AbstractElementDatabase;
import com.jsql.model.bean.database.Column;
import com.jsql.model.bean.database.Database;
import com.jsql.model.bean.database.Table;
import com.jsql.util.LogLevelUtil;
import com.jsql.view.swing.tree.model.AbstractNodeModel;
import com.jsql.view.swing.tree.model.NodeModelColumn;
import com.jsql.view.swing.tree.model.NodeModelDatabase;
import com.jsql.view.swing.tree.model.NodeModelTable;
import com.jsql.view.swing.util.MediatorHelper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TreeDatabase
extends JTree {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private final transient Map<AbstractElementDatabase, DefaultMutableTreeNode> mapNodes = new HashMap<AbstractElementDatabase, DefaultMutableTreeNode>();

    public TreeDatabase(DefaultMutableTreeNode root) {
        super(root);
    }

    public void reloadNodes() {
        if (this.isRootVisible()) {
            DefaultTreeModel model = (DefaultTreeModel)this.getModel();
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)model.getRoot();
            model.reload(root);
            this.revalidate();
        }
    }

    public void reset() {
        DefaultTreeModel treeModel = (DefaultTreeModel)this.getModel();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)treeModel.getRoot();
        root.removeAllChildren();
        treeModel.nodeChanged(root);
        treeModel.reload();
        this.setRootVisible(true);
    }

    public void addColumns(List<Column> columns) {
        DefaultTreeModel treeModel = (DefaultTreeModel)this.getModel();
        DefaultMutableTreeNode tableNode = null;
        for (Column column : columns) {
            NodeModelColumn newTreeNodeModel = new NodeModelColumn(column);
            DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(newTreeNodeModel);
            tableNode = this.getTreeNodeModels().get(column.getParent());
            if (tableNode == null) continue;
            treeModel.insertNodeInto(newNode, tableNode, tableNode.getChildCount());
        }
        if (tableNode != null) {
            this.expandPath(new TreePath(tableNode.getPath()));
            ((AbstractNodeModel)tableNode.getUserObject()).setLoaded(true);
        }
    }

    public void addDatabases(List<Database> databases) {
        DefaultTreeModel treeModel = (DefaultTreeModel)this.getModel();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)treeModel.getRoot();
        for (Database database : databases) {
            NodeModelDatabase newTreeNodeModel = new NodeModelDatabase(database);
            DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(newTreeNodeModel);
            this.getTreeNodeModels().put(database, newNode);
            root.add(newNode);
        }
        treeModel.reload(root);
        this.expandPath(new TreePath(root.getPath()));
        this.setRootVisible(false);
    }

    public void addTables(List<Table> tables) {
        DefaultTreeModel treeModel = (DefaultTreeModel)this.getModel();
        DefaultMutableTreeNode databaseNode = null;
        for (Table table : tables) {
            NodeModelTable newTreeNodeModel = new NodeModelTable(table);
            DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(newTreeNodeModel);
            this.getTreeNodeModels().put(table, newNode);
            databaseNode = this.getTreeNodeModels().get(table.getParent());
            if (databaseNode != null) {
                treeModel.insertNodeInto(newNode, databaseNode, databaseNode.getChildCount());
                continue;
            }
            LOGGER.log(LogLevelUtil.CONSOLE_ERROR, "Missing database for table {}.", () -> table);
        }
        if (databaseNode != null) {
            this.expandPath(new TreePath(databaseNode.getPath()));
            ((AbstractNodeModel)databaseNode.getUserObject()).setLoaded(true);
        }
    }

    public void createValuesTab(String[][] data, String[] columnNames, AbstractElementDatabase table) {
        DefaultMutableTreeNode node = this.getTreeNodeModels().get(table);
        if (node != null) {
            AbstractNodeModel progressingTreeNodeModel = (AbstractNodeModel)node.getUserObject();
            progressingTreeNodeModel.setIndexProgress(table.getChildCount());
            progressingTreeNodeModel.setRunning(false);
            MediatorHelper.tabResults().createValuesTab(data, columnNames, table);
        }
    }

    public void endIndeterminateProgess(AbstractElementDatabase dataElementDatabase) {
        DefaultTreeModel treeModel = (DefaultTreeModel)this.getModel();
        DefaultMutableTreeNode nodeModel = this.getTreeNodeModels().get(dataElementDatabase);
        if (nodeModel != null) {
            AbstractNodeModel progressingTreeNodeModel = (AbstractNodeModel)nodeModel.getUserObject();
            progressingTreeNodeModel.setProgressing(false);
            progressingTreeNodeModel.setRunning(false);
            treeModel.nodeChanged(nodeModel);
        }
    }

    public void endProgess(AbstractElementDatabase dataElementDatabase) {
        DefaultTreeModel treeModel = (DefaultTreeModel)this.getModel();
        DefaultMutableTreeNode node = this.getTreeNodeModels().get(dataElementDatabase);
        if (node != null) {
            AbstractNodeModel progressingTreeNodeModel = (AbstractNodeModel)node.getUserObject();
            progressingTreeNodeModel.setLoading(false);
            progressingTreeNodeModel.setRunning(false);
            progressingTreeNodeModel.setIndexProgress(0);
            treeModel.nodeChanged(node);
        }
    }

    public void startIndeterminateProgess(AbstractElementDatabase dataElementDatabase) {
        DefaultMutableTreeNode node = this.getTreeNodeModels().get(dataElementDatabase);
        if (node != null) {
            AbstractNodeModel progressingTreeNodeModel = (AbstractNodeModel)node.getUserObject();
            progressingTreeNodeModel.setProgressing(true);
            DefaultTreeModel treeModel = (DefaultTreeModel)this.getModel();
            treeModel.nodeChanged(node);
        }
    }

    public void startProgess(AbstractElementDatabase dataElementDatabase) {
        DefaultMutableTreeNode node = this.getTreeNodeModels().get(dataElementDatabase);
        if (node != null) {
            AbstractNodeModel progressingTreeNodeModel = (AbstractNodeModel)node.getUserObject();
            if (progressingTreeNodeModel != null) {
                progressingTreeNodeModel.setLoading(true);
            }
            DefaultTreeModel treeModel = (DefaultTreeModel)this.getModel();
            treeModel.nodeChanged(node);
        }
    }

    public void updateProgess(AbstractElementDatabase dataElementDatabase, int dataCount) {
        DefaultMutableTreeNode node = this.getTreeNodeModels().get(dataElementDatabase);
        if (node != null) {
            AbstractNodeModel progressingTreeNodeModel = (AbstractNodeModel)node.getUserObject();
            progressingTreeNodeModel.setIndexProgress(dataCount);
            DefaultTreeModel treeModel = (DefaultTreeModel)this.getModel();
            treeModel.nodeChanged(node);
        }
    }

    public final Map<AbstractElementDatabase, DefaultMutableTreeNode> getTreeNodeModels() {
        return this.mapNodes;
    }
}

