/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.view.swing.text;

import com.jsql.util.I18nUtil;
import com.jsql.util.LogLevelUtil;
import com.jsql.view.swing.text.JTextFieldPlaceholder;
import com.jsql.view.swing.util.UiUtil;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Graphics;
import java.awt.Image;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JTextFieldWithIcon
extends JTextFieldPlaceholder {
    private static final Logger LOGGER = LogManager.getRootLogger();

    public JTextFieldWithIcon(String placeholder) {
        super(placeholder);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        URL url = UiUtil.URL_GLOBE;
        if (url == null) {
            return;
        }
        Image image = null;
        try {
            image = new ImageIcon(url).getImage();
        }
        catch (IllegalArgumentException e) {
            LOGGER.log(LogLevelUtil.CONSOLE_JAVA, e, (Throwable)e);
        }
        Border border = UIManager.getBorder("TextField.border");
        int x = border.getBorderInsets((Component)this).left;
        int y = (this.getHeight() - 16) / 2;
        try {
            g.drawImage(image, ComponentOrientation.RIGHT_TO_LEFT.equals(ComponentOrientation.getOrientation(I18nUtil.getLocaleDefault())) ? this.getWidth() - (16 + x + 4) : x + 4, y + 1, this);
        }
        catch (ClassCastException e) {
            LOGGER.log(LogLevelUtil.CONSOLE_JAVA, e, (Throwable)e);
        }
    }
}

