/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.view.swing.tab;

import com.jsql.model.bean.database.AbstractElementDatabase;
import com.jsql.util.I18nUtil;
import com.jsql.util.LogLevelUtil;
import com.jsql.util.StringUtil;
import com.jsql.view.swing.action.HotkeyUtil;
import com.jsql.view.swing.scrollpane.LightScrollPane;
import com.jsql.view.swing.scrollpane.LightScrollPaneShell;
import com.jsql.view.swing.shell.ShellSql;
import com.jsql.view.swing.shell.ShellWeb;
import com.jsql.view.swing.tab.TabHeader;
import com.jsql.view.swing.tab.dnd.DnDTabbedPane;
import com.jsql.view.swing.tab.dnd.TabTransferHandler;
import com.jsql.view.swing.table.PanelTable;
import com.jsql.view.swing.text.JPopupTextArea;
import com.jsql.view.swing.util.MediatorHelper;
import com.jsql.view.swing.util.UiStringUtil;
import com.jsql.view.swing.util.UiUtil;
import java.awt.ComponentOrientation;
import java.awt.Font;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.UUID;
import javax.swing.JTextArea;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TabResults
extends DnDTabbedPane {
    private static final Logger LOGGER = LogManager.getRootLogger();

    public TabResults() {
        this.setTabLayoutPolicy(1);
        this.setTransferHandler(new TabTransferHandler());
        HotkeyUtil.addShortcut(this);
    }

    public void createFileTab(String name, String content, String path) {
        JTextArea fileText = (JTextArea)new JPopupTextArea().getProxy();
        fileText.setText(content);
        fileText.setFont(new Font("Ubuntu Mono", 0, 14));
        LightScrollPane scroller = new LightScrollPane(1, 0, 0, 0, fileText);
        fileText.setCaretPosition(0);
        this.addTab(name + " ", scroller);
        this.setSelectedComponent(scroller);
        TabHeader header = new TabHeader(name, UiUtil.ICON_FILE_SERVER);
        this.setToolTipTextAt(this.indexOfComponent(scroller), path);
        this.setTabComponentAt(this.indexOfComponent(scroller), header);
        MediatorHelper.tabManagers().createFileTab(path, name);
    }

    public void createShell(String url, String path) {
        try {
            UUID terminalID = UUID.randomUUID();
            ShellWeb terminal = new ShellWeb(terminalID, url);
            MediatorHelper.frame().getConsoles().put(terminalID, terminal);
            LightScrollPaneShell scroller = new LightScrollPaneShell(terminal);
            this.addTab("Web shell ", scroller);
            this.setSelectedComponent(scroller);
            TabHeader header = new TabHeader("Web shell", UiUtil.ICON_SHELL_SERVER);
            this.setToolTipTextAt(this.indexOfComponent(scroller), String.format("<html><b>URL</b><br>%s<br><b>Path</b><br>%s%s</html>", url, path, MediatorHelper.model().getResourceAccess().filenameWebshell));
            this.setTabComponentAt(this.indexOfComponent(scroller), header);
            terminal.requestFocusInWindow();
        }
        catch (MalformedURLException | URISyntaxException e) {
            LOGGER.log(LogLevelUtil.CONSOLE_ERROR, "Incorrect shell Url", (Throwable)e);
        }
    }

    public void createSQLShellTab(String url, String user, String pass, String path) {
        try {
            UUID terminalID = UUID.randomUUID();
            ShellSql terminal = new ShellSql(terminalID, url, user, pass);
            MediatorHelper.frame().getConsoles().put(terminalID, terminal);
            LightScrollPaneShell scroller = new LightScrollPaneShell(terminal);
            this.addTab("SQL shell ", scroller);
            this.setSelectedComponent(scroller);
            TabHeader header = new TabHeader("SQL shell", UiUtil.ICON_SHELL_SERVER);
            this.setToolTipTextAt(this.indexOfComponent(scroller), String.format("<html><b>URL</b><br>%s<br><b>Path</b><br>%s%s</html>", url, path, MediatorHelper.model().getResourceAccess().filenameSqlshell));
            this.setTabComponentAt(this.indexOfComponent(scroller), header);
            terminal.requestFocusInWindow();
        }
        catch (MalformedURLException | URISyntaxException e) {
            LOGGER.log(LogLevelUtil.CONSOLE_ERROR, "Incorrect shell Url", (Throwable)e);
        }
    }

    public void createValuesTab(String[][] data, String[] columnNames, AbstractElementDatabase table) {
        PanelTable newTableJPanel = new PanelTable(data, columnNames);
        this.addTab(StringUtil.detectUtf8(table.toString()), newTableJPanel);
        newTableJPanel.setComponentOrientation(ComponentOrientation.getOrientation(I18nUtil.getLocaleDefault()));
        this.setSelectedComponent(newTableJPanel);
        TabHeader header = new TabHeader(UiStringUtil.detectUtf8Html(table.toString()));
        this.setToolTipTextAt(this.indexOfComponent(newTableJPanel), String.format("<html><b>%s.%s</b><br><i>%s</i></html>", table.getParent(), table, String.join((CharSequence)"<br>", Arrays.copyOfRange(columnNames, 2, columnNames.length))));
        this.setTabComponentAt(this.indexOfComponent(newTableJPanel), header);
    }
}

