/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.view.swing.tab;

import com.jsql.util.I18nUtil;
import com.jsql.view.swing.manager.ManagerAdminPage;
import com.jsql.view.swing.manager.ManagerBruteForce;
import com.jsql.view.swing.manager.ManagerCoder;
import com.jsql.view.swing.manager.ManagerDatabase;
import com.jsql.view.swing.manager.ManagerFile;
import com.jsql.view.swing.manager.ManagerScan;
import com.jsql.view.swing.manager.ManagerSqlShell;
import com.jsql.view.swing.manager.ManagerUpload;
import com.jsql.view.swing.manager.ManagerWebShell;
import com.jsql.view.swing.util.MediatorHelper;
import com.jsql.view.swing.util.UiUtil;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Icon;
import javax.swing.JTabbedPane;
import javax.swing.plaf.metal.MetalTabbedPaneUI;

public class TabManagersProxy
extends JTabbedPane {
    private final ManagerWebShell managerWebShell = new ManagerWebShell();
    private final ManagerFile managerFile = new ManagerFile();
    private final ManagerUpload managerUpload = new ManagerUpload();
    private final ManagerSqlShell managerSqlShell = new ManagerSqlShell();

    public TabManagersProxy() {
        this.setName("tabManagersProxy");
        this.setUI(new MetalTabbedPaneUI(){

            @Override
            protected int calculateTabAreaHeight(int tabPlacement, int horizRunCount, int maxTabHeight) {
                return 0;
            }
        });
        ManagerScan managerScanList = new ManagerScan();
        ManagerDatabase managerDatabase = new ManagerDatabase();
        ManagerAdminPage managerAdminPage = new ManagerAdminPage();
        ManagerBruteForce managerBruteForce = new ManagerBruteForce();
        MediatorHelper.register(this.managerWebShell);
        MediatorHelper.register(this.managerFile);
        MediatorHelper.register(this.managerUpload);
        MediatorHelper.register(this.managerSqlShell);
        MediatorHelper.register(managerScanList);
        MediatorHelper.register(managerAdminPage);
        MediatorHelper.register(managerBruteForce);
        this.setMinimumSize(new Dimension(100, 0));
        this.buildI18nTab("DATABASE_TAB", UiUtil.ICON_DATABASE_SERVER, managerDatabase);
        this.buildI18nTab("ADMINPAGE_TAB", UiUtil.ICON_ADMIN_SERVER, managerAdminPage);
        this.buildI18nTab("FILE_TAB", UiUtil.ICON_FILE_SERVER, this.managerFile);
        this.buildI18nTab("WEBSHELL_TAB", UiUtil.ICON_SHELL_SERVER, this.managerWebShell);
        this.buildI18nTab("SQLSHELL_TAB", UiUtil.ICON_SHELL_SERVER, this.managerSqlShell);
        this.buildI18nTab("UPLOAD_TAB", UiUtil.ICON_UPLOAD, this.managerUpload);
        this.buildI18nTab("BRUTEFORCE_TAB", UiUtil.ICON_BRUTER, managerBruteForce);
        this.buildI18nTab("CODER_TAB", UiUtil.ICON_CODER, new ManagerCoder());
        this.buildI18nTab("SCANLIST_TAB", UiUtil.ICON_SCANLIST, managerScanList);
    }

    public void createFileTab(String path, String name) {
        this.managerWebShell.addToList(path.replace(name, ""));
        this.managerUpload.addToList(path.replace(name, ""));
        this.managerSqlShell.addToList(path.replace(name, ""));
    }

    public void markFileSystemInvulnerable() {
        this.managerFile.changePrivilegeIcon(UiUtil.ICON_SQUARE_RED);
        this.managerFile.endProcess();
        this.managerWebShell.changePrivilegeIcon(UiUtil.ICON_SQUARE_RED);
        this.managerWebShell.endProcess();
        this.managerUpload.changePrivilegeIcon(UiUtil.ICON_SQUARE_RED);
        this.managerUpload.endProcess();
        this.managerSqlShell.changePrivilegeIcon(UiUtil.ICON_SQUARE_RED);
        this.managerSqlShell.endProcess();
    }

    public void endPreparation() {
        this.managerFile.setButtonEnable(true);
        this.managerWebShell.setButtonEnable(true);
        this.managerSqlShell.setButtonEnable(true);
        this.managerUpload.setButtonEnable(true);
    }

    public void markFileSystemVulnerable() {
        this.managerFile.changePrivilegeIcon(UiUtil.ICON_TICK);
        this.managerWebShell.changePrivilegeIcon(UiUtil.ICON_TICK);
        this.managerSqlShell.changePrivilegeIcon(UiUtil.ICON_TICK);
        this.managerUpload.changePrivilegeIcon(UiUtil.ICON_TICK);
    }

    private void buildI18nTab(String keyLabel, Icon icon, Component manager) {
        this.addTab(I18nUtil.valueByKey(keyLabel), icon, manager);
    }
}

