/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.view.swing.scrollpane;

import com.jsql.util.LogLevelUtil;
import com.jsql.view.swing.scrollpane.JScrollPanePixelBorder;
import com.jsql.view.swing.util.UiUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.ScrollPaneLayout;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicScrollBarUI;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LightScrollPane
extends JComponent {
    private static final Logger LOGGER = LogManager.getRootLogger();
    protected int scrollBarAlpha = 25;
    protected int scrollBarAlphaRollover = 100;
    private static final int THUMB_BORDER_SIZE = 0;
    public static final int THUMB_SIZE = 15;
    protected Color colorThumb = Color.DARK_GRAY;
    public final JScrollPane scrollPane;
    private final JScrollBar verticalScrollBar;
    private final JScrollBar horizontalScrollBar;

    public LightScrollPane(int top, int left, int bottom, int right, JComponent c) {
        this(c);
        this.setBorder(BorderFactory.createMatteBorder(top, left, bottom, right, UiUtil.COLOR_COMPONENT_BORDER));
    }

    public LightScrollPane(JComponent component) {
        this.scrollPane = new JScrollPanePixelBorder(component);
        this.scrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.verticalScrollBar = this.scrollPane.getVerticalScrollBar();
        this.verticalScrollBar.setVisible(false);
        this.verticalScrollBar.setOpaque(false);
        this.verticalScrollBar.setUI(new MyScrollBarUI());
        this.horizontalScrollBar = this.scrollPane.getHorizontalScrollBar();
        this.horizontalScrollBar.setVisible(false);
        this.horizontalScrollBar.setOpaque(false);
        this.horizontalScrollBar.setUI(new MyScrollBarUI());
        JLayeredPane layeredPane = new JLayeredPane();
        layeredPane.setLayer(this.verticalScrollBar, JLayeredPane.PALETTE_LAYER);
        layeredPane.setLayer(this.horizontalScrollBar, JLayeredPane.PALETTE_LAYER);
        this.scrollPane.setVerticalScrollBarPolicy(20);
        this.scrollPane.setHorizontalScrollBarPolicy(30);
        this.scrollPane.setLayout(new ScrollPaneLayout(){

            @Override
            public void layoutContainer(Container parent) {
                try {
                    this.viewport.setBounds(0, 0, LightScrollPane.this.getWidth(), LightScrollPane.this.getHeight() - 1);
                }
                catch (NullPointerException e) {
                    LOGGER.log(LogLevelUtil.CONSOLE_JAVA, e, (Throwable)e);
                }
                SwingUtilities.invokeLater(() -> LightScrollPane.this.displayScrollBarsIfNecessary(this.viewport));
            }
        });
        layeredPane.add(this.horizontalScrollBar);
        layeredPane.add(this.verticalScrollBar);
        layeredPane.add(this.scrollPane);
        this.setLayout(new BorderLayout(){

            @Override
            public void layoutContainer(Container target) {
                int cornerOffset;
                super.layoutContainer(target);
                int width = LightScrollPane.this.getWidth();
                int height = LightScrollPane.this.getHeight();
                LightScrollPane.this.scrollPane.setBounds(0, 0, width, height);
                int scrollBarSize = 15;
                int n = cornerOffset = LightScrollPane.this.verticalScrollBar.isVisible() && LightScrollPane.this.horizontalScrollBar.isVisible() ? scrollBarSize : 0;
                if (LightScrollPane.this.verticalScrollBar.isVisible()) {
                    LightScrollPane.this.verticalScrollBar.setBounds(LightScrollPane.this.getComponentOrientation() == ComponentOrientation.RIGHT_TO_LEFT ? 0 : width - scrollBarSize, 0, scrollBarSize, height - cornerOffset);
                }
                if (LightScrollPane.this.horizontalScrollBar.isVisible()) {
                    LightScrollPane.this.horizontalScrollBar.setBounds(0, height - scrollBarSize, width - cornerOffset, scrollBarSize);
                }
            }
        });
        this.add((Component)layeredPane, "Center");
        layeredPane.setBackground(Color.BLUE);
    }

    private void displayScrollBarsIfNecessary(JViewport viewPort) {
        this.displayVerticalScrollBarIfNecessary(viewPort);
        this.displayHorizontalScrollBarIfNecessary(viewPort);
    }

    private void displayVerticalScrollBarIfNecessary(JViewport viewPort) {
        Rectangle viewRect = viewPort.getViewRect();
        Dimension viewSize = viewPort.getViewSize();
        boolean isDisplayingVerticalScrollBar = viewSize.getHeight() > viewRect.getHeight();
        this.verticalScrollBar.setVisible(isDisplayingVerticalScrollBar);
    }

    private void displayHorizontalScrollBarIfNecessary(JViewport viewPort) {
        Rectangle viewRect = viewPort.getViewRect();
        Dimension viewSize = viewPort.getViewSize();
        boolean isDisplayingHorizontalScrollBar = viewSize.getWidth() > viewRect.getWidth();
        this.horizontalScrollBar.setVisible(isDisplayingHorizontalScrollBar);
    }

    private class MyScrollBarUI
    extends BasicScrollBarUI {
        private MyScrollBarUI() {
        }

        @Override
        protected JButton createDecreaseButton(int orientation) {
            return new MyScrollBarButton();
        }

        @Override
        protected JButton createIncreaseButton(int orientation) {
            return new MyScrollBarButton();
        }

        @Override
        protected void paintTrack(Graphics g, JComponent c, Rectangle trackBounds) {
        }

        @Override
        protected Dimension getMinimumThumbSize() {
            return new Dimension(15, 28);
        }

        @Override
        protected void paintThumb(Graphics g, JComponent c, Rectangle thumbBounds) {
            Color colorThumbAlpha;
            int alpha = this.isThumbRollover() ? LightScrollPane.this.scrollBarAlphaRollover : LightScrollPane.this.scrollBarAlpha;
            int orientation = this.scrollbar.getOrientation();
            int x = thumbBounds.x + 0;
            int y = thumbBounds.y + 0;
            int width = orientation == 1 ? 15 : thumbBounds.width - 0;
            width = Math.max(width, 15);
            int height = orientation == 1 ? thumbBounds.height - 0 : 15;
            height = Math.max(height, 15);
            Graphics2D graphics2D = (Graphics2D)g.create();
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            try {
                colorThumbAlpha = new Color(LightScrollPane.this.colorThumb.getRed(), LightScrollPane.this.colorThumb.getGreen(), LightScrollPane.this.colorThumb.getBlue(), alpha);
            }
            catch (NullPointerException e) {
                colorThumbAlpha = Color.GRAY;
                LOGGER.log(LogLevelUtil.IGNORE, e);
            }
            graphics2D.setColor(colorThumbAlpha);
            graphics2D.fillRect(x, y, width, height);
            graphics2D.dispose();
        }
    }

    private static class MyScrollBarButton
    extends JButton {
        private MyScrollBarButton() {
            this.setOpaque(false);
            this.setFocusable(false);
            this.setFocusPainted(false);
            this.setBorderPainted(false);
            this.setBorder(BorderFactory.createEmptyBorder());
        }
    }
}

