/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.view.swing.radio;

import com.jsql.view.swing.radio.AbstractRadioLink;
import com.jsql.view.swing.util.UiUtil;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.TextAttribute;
import java.util.HashMap;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;

public class RadioMethodMouseAdapter
extends MouseAdapter {
    private Font original;

    @Override
    public void mouseClicked(MouseEvent e) {
        super.mouseClicked(e);
        AbstractRadioLink radio = (AbstractRadioLink)e.getComponent();
        if (radio.isActivable() && SwingUtilities.isLeftMouseButton(e)) {
            for (JLabel label : radio.getGroup()) {
                if (e.getComponent() != label) {
                    label.setFont(UiUtil.FONT_NON_MONO);
                    continue;
                }
                radio.action();
            }
            radio.setUnderlined();
            this.original = e.getComponent().getFont();
            radio.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        super.mouseEntered(e);
        AbstractRadioLink radio = (AbstractRadioLink)e.getComponent();
        this.original = e.getComponent().getFont();
        if (radio.isActivable()) {
            Font font = radio.getFont();
            HashMap attributes = new HashMap(font.getAttributes());
            attributes.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
            radio.setFont(font.deriveFont(attributes));
            radio.setCursor(Cursor.getPredefinedCursor(12));
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        super.mouseExited(e);
        AbstractRadioLink radio = (AbstractRadioLink)e.getComponent();
        radio.setFont(this.original);
        radio.setCursor(Cursor.getPredefinedCursor(0));
    }
}

