/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.view.swing.manager;

import com.jsql.model.bean.util.Interaction;
import com.jsql.model.bean.util.Request;
import com.jsql.model.injection.method.AbstractMethodInjection;
import com.jsql.model.injection.vendor.model.Vendor;
import com.jsql.util.I18nUtil;
import com.jsql.util.LogLevelUtil;
import com.jsql.view.scan.ScanListTerminal;
import com.jsql.view.swing.list.BeanInjection;
import com.jsql.view.swing.list.DnDList;
import com.jsql.view.swing.list.DnDListScan;
import com.jsql.view.swing.list.ItemList;
import com.jsql.view.swing.list.ItemListScan;
import com.jsql.view.swing.list.ListTransfertHandlerScan;
import com.jsql.view.swing.manager.AbstractManagerList;
import com.jsql.view.swing.manager.util.JButtonStateful;
import com.jsql.view.swing.manager.util.StateButton;
import com.jsql.view.swing.scrollpane.LightScrollPane;
import com.jsql.view.swing.ui.FlatButtonMouseAdapter;
import com.jsql.view.swing.util.I18nViewUtil;
import com.jsql.view.swing.util.MediatorHelper;
import com.jsql.view.swing.util.UiUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JPanel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ManagerScan
extends AbstractManagerList {
    private static final Logger LOGGER = LogManager.getRootLogger();
    public static final String NAME = "listManagerScan";

    public ManagerScan() {
        this.setLayout(new BorderLayout());
        List<ItemList> itemsList = this.getItemList();
        DnDListScan dndListScan = new DnDListScan(itemsList);
        dndListScan.setTransferHandler(null);
        dndListScan.setTransferHandler(new ListTransfertHandlerScan());
        this.listPaths = dndListScan;
        this.listPaths.setName(NAME);
        this.getListPaths().setBorder(BorderFactory.createEmptyBorder(0, 0, 15, 0));
        this.add((Component)new LightScrollPane(0, 0, 0, 0, dndListScan), "Center");
        JPanel lastLine = this.getLastLinePanel(dndListScan);
        this.add((Component)lastLine, "South");
        dndListScan.addListSelectionListener(e -> {
            if (dndListScan.getSelectedValue() == null) {
                return;
            }
            BeanInjection beanInjection = ((ItemListScan)dndListScan.getSelectedValue()).getBeanInjection();
            MediatorHelper.panelAddressBar().getTextFieldAddress().setText(beanInjection.getUrl());
            MediatorHelper.panelAddressBar().getTextFieldHeader().setText(beanInjection.getHeader());
            MediatorHelper.panelAddressBar().getTextFieldRequest().setText(beanInjection.getRequest());
            String requestType = beanInjection.getRequestType();
            if (requestType != null && !requestType.isEmpty()) {
                MediatorHelper.panelAddressBar().getRadioRequest().setText(requestType);
            } else {
                MediatorHelper.panelAddressBar().getRadioRequest().setText("GET");
            }
            AbstractMethodInjection method = beanInjection.getMethodInstance();
            if (method == MediatorHelper.model().getMediatorMethod().getHeader()) {
                MediatorHelper.panelAddressBar().getRadioHeader().setSelected();
            } else if (method == MediatorHelper.model().getMediatorMethod().getRequest()) {
                MediatorHelper.panelAddressBar().getRadioRequest().setSelected();
            } else {
                MediatorHelper.panelAddressBar().getRadioQueryString().setSelected();
            }
        });
    }

    private JPanel getLastLinePanel(DnDList dndListScan) {
        JPanel lastLine = new JPanel();
        lastLine.setOpaque(false);
        lastLine.setLayout(new BoxLayout(lastLine, 0));
        lastLine.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 0, 0, UiUtil.COLOR_COMPONENT_BORDER), BorderFactory.createEmptyBorder(1, 0, 1, 1)));
        this.initializeRunButton(dndListScan);
        this.loader.setVisible(false);
        lastLine.add(Box.createHorizontalGlue());
        lastLine.add(this.loader);
        lastLine.add(Box.createRigidArea(new Dimension(5, 0)));
        lastLine.add(this.run);
        return lastLine;
    }

    private List<ItemList> getItemList() {
        StringBuilder jsonScan = new StringBuilder();
        try (InputStream inputStream = UiUtil.class.getClassLoader().getResourceAsStream("swing/list/scan-page.json");
             InputStreamReader inputStreamReader = new InputStreamReader(Objects.requireNonNull(inputStream));
             BufferedReader reader = new BufferedReader(inputStreamReader);){
            String line;
            while ((line = reader.readLine()) != null) {
                jsonScan.append(line);
            }
        }
        catch (IOException e) {
            LOGGER.log(LogLevelUtil.CONSOLE_JAVA, e, (Throwable)e);
        }
        ArrayList<ItemList> itemsList = new ArrayList<ItemList>();
        try {
            JSONArray jsonArrayScan = new JSONArray(jsonScan.toString());
            for (int i = 0; i < jsonArrayScan.length(); ++i) {
                JSONObject jsonObjectScan = jsonArrayScan.getJSONObject(i);
                BeanInjection beanInjection = new BeanInjection(jsonObjectScan.getString("url"), jsonObjectScan.optString("request"), jsonObjectScan.optString("header"), jsonObjectScan.optString("method"), jsonObjectScan.optString("vendor"), jsonObjectScan.optString("requestType"));
                itemsList.add(new ItemListScan(beanInjection));
            }
        }
        catch (JSONException e) {
            LOGGER.log(LogLevelUtil.CONSOLE_JAVA, e, (Throwable)e);
        }
        return itemsList;
    }

    private void initializeRunButton(DnDList dndListScan) {
        this.defaultText = "SCAN_RUN_BUTTON_LABEL";
        this.run = new JButtonStateful(this.defaultText);
        I18nViewUtil.addComponentForKey("SCAN_RUN_BUTTON_LABEL", this.run);
        this.run.setToolTipText(I18nUtil.valueByKey("SCAN_RUN_BUTTON_TOOLTIP"));
        this.run.setContentAreaFilled(false);
        this.run.setBorder(BorderFactory.createEmptyBorder(4, 8, 4, 8));
        this.run.setBackground(new Color(200, 221, 242));
        this.run.addMouseListener(new FlatButtonMouseAdapter(this.run));
        this.run.addActionListener(actionEvent -> {
            if (dndListScan.getSelectedValuesList().isEmpty()) {
                LOGGER.log(LogLevelUtil.CONSOLE_ERROR, "Select URL(s) to scan");
                return;
            }
            new Thread(() -> {
                if (this.run.getState() == StateButton.STARTABLE) {
                    this.run.setText(I18nViewUtil.valueByKey("SCAN_RUN_BUTTON_STOP"));
                    this.run.setState(StateButton.STOPPABLE);
                    this.loader.setVisible(true);
                    DefaultListModel listModel = (DefaultListModel)dndListScan.getModel();
                    for (int i = 0; i < listModel.getSize(); ++i) {
                        ((ItemList)listModel.get(i)).reset();
                    }
                    this.scan(dndListScan.getSelectedValuesList());
                } else {
                    MediatorHelper.model().getResourceAccess().setScanStopped(true);
                    MediatorHelper.model().setIsStoppedByUser(true);
                    this.run.setEnabled(false);
                    this.run.setState(StateButton.STOPPING);
                }
            }, "ThreadScan").start();
        });
    }

    public void scan(List<ItemList> urlsItemList) {
        Request requests = new Request();
        requests.setMessage(Interaction.RESET_INTERFACE);
        MediatorHelper.model().sendToViews(requests);
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            LOGGER.log(LogLevelUtil.IGNORE, e, (Throwable)e);
            Thread.currentThread().interrupt();
        }
        Request requestUnsubscribe = new Request();
        requestUnsubscribe.setMessage(Interaction.UNSUBSCRIBE);
        MediatorHelper.model().sendToViews(requestUnsubscribe);
        MediatorHelper.model().subscribe(new ScanListTerminal());
        MediatorHelper.model().setIsScanning(true);
        MediatorHelper.model().getResourceAccess().setScanStopped(false);
        for (ItemList urlItemList : urlsItemList) {
            ItemListScan urlItemListScan = (ItemListScan)urlItemList;
            if (MediatorHelper.model().isStoppedByUser() || MediatorHelper.model().getResourceAccess().isScanStopped()) break;
            LOGGER.log(LogLevelUtil.CONSOLE_INFORM, "Scanning {}", (Object)urlItemListScan.getBeanInjection().getUrl());
            Optional<Vendor> vendor = MediatorHelper.model().getMediatorVendor().getVendors().stream().filter(v -> v.toString().equalsIgnoreCase(urlItemListScan.getBeanInjection().getVendor())).findAny();
            MediatorHelper.model().getMediatorVendor().setVendorByUser(vendor.orElse(MediatorHelper.model().getMediatorVendor().getAuto()));
            MediatorHelper.model().getMediatorUtils().getParameterUtil().controlInput(urlItemListScan.getBeanInjection().getUrl(), urlItemListScan.getBeanInjection().getRequest(), urlItemListScan.getBeanInjection().getHeader(), urlItemListScan.getBeanInjection().getMethodInstance(), urlItemListScan.getBeanInjection().getRequestType(), true);
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                LOGGER.log(LogLevelUtil.IGNORE, e, (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
        MediatorHelper.model().sendToViews(requestUnsubscribe);
        MediatorHelper.model().subscribe(MediatorHelper.frame().getSubscriber());
        MediatorHelper.model().setIsScanning(false);
        MediatorHelper.model().setIsStoppedByUser(false);
        MediatorHelper.model().getResourceAccess().setScanStopped(false);
        Request request = new Request();
        request.setMessage(Interaction.END_SCAN);
        MediatorHelper.model().sendToViews(request);
    }
}

