/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.view.swing.manager;

import com.jsql.model.exception.JSqlException;
import com.jsql.util.I18nUtil;
import com.jsql.util.LogLevelUtil;
import com.jsql.view.swing.list.DnDList;
import com.jsql.view.swing.list.ItemList;
import com.jsql.view.swing.manager.AbstractManagerList;
import com.jsql.view.swing.manager.util.JButtonStateful;
import com.jsql.view.swing.scrollpane.LightScrollPane;
import com.jsql.view.swing.text.JPopupTextField;
import com.jsql.view.swing.ui.FlatButtonMouseAdapter;
import com.jsql.view.swing.util.I18nViewUtil;
import com.jsql.view.swing.util.UiUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractManagerShell
extends AbstractManagerList {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private final JTextField textfieldUrlShell = (JTextField)new JPopupTextField(I18nUtil.valueByKey("SHELL_URL_LABEL")).getProxy();

    protected AbstractManagerShell() {
        this.setLayout(new BorderLayout());
        ArrayList<ItemList> itemsList = new ArrayList<ItemList>();
        try (InputStream inputStream = UiUtil.class.getClassLoader().getResourceAsStream("swing/list/payload.txt");
             InputStreamReader inputStreamReader = new InputStreamReader(Objects.requireNonNull(inputStream));
             BufferedReader reader = new BufferedReader(inputStreamReader);){
            String line;
            while ((line = reader.readLine()) != null) {
                itemsList.add(new ItemList(line));
            }
        }
        catch (IOException e) {
            LOGGER.log(LogLevelUtil.CONSOLE_JAVA, e, (Throwable)e);
        }
        this.listPaths = new DnDList(itemsList);
        this.getListPaths().setBorder(BorderFactory.createEmptyBorder(0, 0, 15, 0));
        this.add((Component)new LightScrollPane(0, 0, 0, 0, this.getListPaths()), "Center");
        JPanel southPanel = new JPanel();
        southPanel.setLayout(new BoxLayout(southPanel, 1));
        String urlTooltip = I18nUtil.valueByKey("SHELL_URL_TOOLTIP");
        this.textfieldUrlShell.setToolTipText(urlTooltip);
        this.textfieldUrlShell.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 0, 0, UiUtil.COLOR_COMPONENT_BORDER), BorderFactory.createMatteBorder(1, 1, 0, 1, UiUtil.COLOR_DEFAULT_BACKGROUND)), UiUtil.BORDER_BLU));
        JPanel lastLine = this.initializeRunButtonPanel();
        southPanel.add(this.textfieldUrlShell);
        southPanel.add(lastLine);
        this.add((Component)southPanel, "South");
    }

    protected abstract void createPayload(String var1, String var2) throws JSqlException, InterruptedException;

    private JPanel initializeRunButtonPanel() {
        this.defaultText = "SHELL_RUN_BUTTON_LABEL";
        JPanel lastLine = new JPanel();
        lastLine.setLayout(new BoxLayout(lastLine, 0));
        lastLine.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 0, 0, UiUtil.COLOR_COMPONENT_BORDER), BorderFactory.createEmptyBorder(1, 0, 1, 1)));
        this.run = new JButtonStateful(this.defaultText);
        I18nViewUtil.addComponentForKey(this.defaultText, this.run);
        this.run.setToolTipText(I18nUtil.valueByKey("SHELL_RUN_BUTTON_TOOLTIP"));
        this.run.setEnabled(false);
        this.run.setContentAreaFilled(false);
        this.run.setBorder(BorderFactory.createEmptyBorder(4, 8, 4, 8));
        this.run.setBackground(new Color(200, 221, 242));
        this.run.addMouseListener(new FlatButtonMouseAdapter(this.run));
        this.run.addActionListener(new ActionCreationShell());
        this.privilege = new JLabel(I18nUtil.valueByKey("PRIVILEGE_LABEL"), UiUtil.ICON_SQUARE_GREY, 2);
        I18nViewUtil.addComponentForKey("PRIVILEGE_LABEL", this.privilege);
        this.privilege.setBorder(BorderFactory.createMatteBorder(2, 0, 0, 0, UiUtil.COLOR_DEFAULT_BACKGROUND));
        this.privilege.setToolTipText(I18nUtil.valueByKey("PRIVILEGE_TOOLTIP"));
        lastLine.add(this.privilege);
        lastLine.add(Box.createHorizontalStrut(5));
        lastLine.add(Box.createHorizontalGlue());
        lastLine.add(this.run);
        return lastLine;
    }

    private class ActionCreationShell
    implements ActionListener {
        private ActionCreationShell() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (AbstractManagerShell.this.getListPaths().getSelectedValuesList().isEmpty()) {
                LOGGER.log(LogLevelUtil.CONSOLE_ERROR, "Select at least one directory in the list");
                return;
            }
            Object refUrlShell = AbstractManagerShell.this.textfieldUrlShell.getText();
            if (!((String)refUrlShell).isEmpty() && !((String)refUrlShell).matches("(?i)^https?://.*")) {
                if (!((String)refUrlShell).matches("(?i)^\\w+://.*")) {
                    LOGGER.log(LogLevelUtil.CONSOLE_INFORM, "Undefined shell URL protocol, forcing to [http://]");
                    refUrlShell = "http://" + (String)refUrlShell;
                } else {
                    LOGGER.log(LogLevelUtil.CONSOLE_ERROR, "Unknown URL protocol");
                    return;
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)refUrlShell)) {
                try {
                    new URI((String)refUrlShell);
                }
                catch (URISyntaxException e) {
                    LOGGER.log(LogLevelUtil.CONSOLE_ERROR, String.format("Incorrect URL: %s", e.getMessage()), (Throwable)e);
                    return;
                }
            }
            String urlShellFinal = refUrlShell;
            AbstractManagerShell.this.getListPaths().getSelectedValuesList().forEach(pathShell -> new Thread(() -> {
                try {
                    AbstractManagerShell.this.createPayload(pathShell.toString(), urlShellFinal);
                }
                catch (JSqlException e) {
                    LOGGER.log(LogLevelUtil.CONSOLE_ERROR, String.format("Payload creation error: %s", e.getMessage()));
                }
                catch (InterruptedException e) {
                    LOGGER.log(LogLevelUtil.CONSOLE_ERROR, String.format("Payload creation error: %s", e.getMessage()));
                    Thread.currentThread().interrupt();
                }
            }, "ThreadGetShell").start());
        }
    }
}

