/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.view.swing.dialog;

import com.jsql.util.LogLevelUtil;
import com.jsql.view.swing.popupmenu.JPopupMenuText;
import com.jsql.view.swing.scrollpane.LightScrollPane;
import com.jsql.view.swing.ui.FlatButtonMouseAdapter;
import com.jsql.view.swing.util.MediatorHelper;
import com.jsql.view.swing.util.UiUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.event.HyperlinkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DialogAbout
extends JDialog {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private JButton buttonClose = null;
    private final LightScrollPane scrollPane;

    public DialogAbout() {
        super((Window)MediatorHelper.frame(), "About jSQL Injection", Dialog.ModalityType.MODELESS);
        this.setDefaultCloseOperation(2);
        this.setIconImages(UiUtil.getIcons());
        ActionListener escapeListener = actionEvent -> this.dispose();
        this.getRootPane().registerKeyboardAction(escapeListener, KeyStroke.getKeyStroke(27, 0), 2);
        this.setLayout(new BorderLayout());
        Container dialogPane = this.getContentPane();
        JPanel lastLine = this.initializeLastLine(escapeListener);
        JLabel iconJsql = new JLabel(new ImageIcon(Objects.requireNonNull(UiUtil.URL_ICON_96)));
        dialogPane.add((Component)iconJsql, "West");
        dialogPane.add((Component)lastLine, "South");
        JEditorPane text = this.initializeEditorPane();
        this.scrollPane = new LightScrollPane(1, 1, 1, 0, text);
        dialogPane.add((Component)this.scrollPane, "Center");
        this.initializeDialog();
    }

    private JPanel initializeLastLine(ActionListener escapeListener) {
        JPanel lastLine = new JPanel();
        lastLine.setLayout(new BoxLayout(lastLine, 2));
        lastLine.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JButton buttonWebpage = this.initializeButtonWebpage();
        this.initializeButtonClose(escapeListener);
        lastLine.add(buttonWebpage);
        lastLine.add(Box.createGlue());
        lastLine.add(this.buttonClose);
        return lastLine;
    }

    private void initializeButtonClose(ActionListener escapeListener) {
        this.buttonClose = new JButton("Close");
        this.buttonClose.setBorder(BorderFactory.createCompoundBorder(UiUtil.BORDER_FOCUS_GAINED, BorderFactory.createEmptyBorder(2, 20, 2, 20)));
        this.buttonClose.addActionListener(escapeListener);
        this.buttonClose.setContentAreaFilled(false);
        this.buttonClose.setBorder(BorderFactory.createEmptyBorder(4, 8, 4, 8));
        this.buttonClose.setBackground(new Color(200, 221, 242));
        this.buttonClose.addMouseListener(new FlatButtonMouseAdapter(this.buttonClose));
    }

    private JButton initializeButtonWebpage() {
        JButton buttonWebpage = new JButton("Webpage");
        buttonWebpage.setBorder(BorderFactory.createCompoundBorder(UiUtil.BORDER_FOCUS_GAINED, BorderFactory.createEmptyBorder(2, 20, 2, 20)));
        buttonWebpage.addActionListener(ev -> {
            try {
                Desktop.getDesktop().browse(new URI((String)MediatorHelper.model().getMediatorUtils().getPropertiesUtil().getProperties().get("github.url")));
            }
            catch (IOException | UnsupportedOperationException | URISyntaxException e) {
                LOGGER.log(LogLevelUtil.CONSOLE_ERROR, "Browsing to Url failed", (Throwable)e);
            }
        });
        buttonWebpage.setContentAreaFilled(false);
        buttonWebpage.setBorder(BorderFactory.createEmptyBorder(4, 8, 4, 8));
        buttonWebpage.setBackground(new Color(200, 221, 242));
        buttonWebpage.addMouseListener(new FlatButtonMouseAdapter(buttonWebpage));
        return buttonWebpage;
    }

    private JEditorPane initializeEditorPane() {
        final JEditorPane editorPane = new JEditorPane();
        try {
            editorPane.setContentType("text/html");
            StringBuilder result = new StringBuilder();
            try (InputStream inputStream = DialogAbout.class.getClassLoader().getResourceAsStream("swing/about.htm");
                 InputStreamReader inputStreamReader = new InputStreamReader(Objects.requireNonNull(inputStream));
                 BufferedReader reader = new BufferedReader(inputStreamReader);){
                String line;
                while ((line = reader.readLine()) != null) {
                    result.append(line);
                }
            }
            editorPane.setText(result.toString().replace("%JSQLVERSION%", MediatorHelper.model().getVersionJsql()));
        }
        catch (IOException | NoClassDefFoundError e) {
            LOGGER.log(LogLevelUtil.CONSOLE_JAVA, e, e);
        }
        editorPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                super.mousePressed(e);
                editorPane.requestFocusInWindow();
            }
        });
        editorPane.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent arg0) {
                editorPane.getCaret().setVisible(true);
                editorPane.getCaret().setSelectionVisible(true);
            }
        });
        editorPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        editorPane.setDragEnabled(true);
        editorPane.setEditable(false);
        editorPane.setComponentPopupMenu(new JPopupMenuText(editorPane));
        editorPane.addHyperlinkListener(linkEvent -> {
            if (HyperlinkEvent.EventType.ACTIVATED.equals(linkEvent.getEventType())) {
                try {
                    Desktop.getDesktop().browse(linkEvent.getURL().toURI());
                }
                catch (IOException | UnsupportedOperationException | URISyntaxException e) {
                    LOGGER.log(LogLevelUtil.CONSOLE_ERROR, "Browsing to Url failed", (Throwable)e);
                }
            }
        });
        return editorPane;
    }

    public final void initializeDialog() {
        this.scrollPane.scrollPane.getViewport().setViewPosition(new Point(0, 0));
        this.setSize(533, 400);
        this.setLocationRelativeTo(MediatorHelper.frame());
        this.buttonClose.requestFocusInWindow();
        this.getRootPane().setDefaultButton(this.buttonClose);
    }

    public void requestButtonFocus() {
        this.buttonClose.requestFocusInWindow();
    }
}

