/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.view.interaction;

import com.jsql.model.bean.util.Interaction;
import com.jsql.model.bean.util.Request;
import com.jsql.util.LogLevelUtil;
import com.jsql.view.interaction.InteractionCommand;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.Flow;
import javax.swing.SwingUtilities;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SubscriberInteraction
implements Flow.Subscriber<Request> {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private final String packageInteraction;
    private Flow.Subscription subscription;

    public SubscriberInteraction(String packageInteraction) {
        this.packageInteraction = packageInteraction;
    }

    @Override
    public void onSubscribe(Flow.Subscription subscription) {
        this.subscription = subscription;
        subscription.request(1L);
    }

    @Override
    public void onNext(Request request) {
        this.subscription.request(1L);
        if (Interaction.UNSUBSCRIBE.equals((Object)request.getMessage())) {
            this.subscription.cancel();
            return;
        }
        String nameThread = Thread.currentThread().getName();
        SwingUtilities.invokeLater(() -> {
            Thread.currentThread().setName("from " + nameThread);
            try {
                Class<?> cl = Class.forName(this.packageInteraction + "." + request.getMessage());
                Class[] types = new Class[]{Object[].class};
                Constructor<?> ct = cl.getConstructor(types);
                InteractionCommand o2 = (InteractionCommand)ct.newInstance(new Object[]{request.getParameters()});
                o2.execute();
            }
            catch (ClassNotFoundException e) {
                LOGGER.log(LogLevelUtil.IGNORE, e);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                LOGGER.log(LogLevelUtil.CONSOLE_JAVA, e, (Throwable)e);
            }
        });
    }

    @Override
    public void onError(Throwable e) {
        LOGGER.log(LogLevelUtil.CONSOLE_JAVA, e, e);
    }

    @Override
    public void onComplete() {
    }
}

