/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.util;

import com.jsql.util.LogLevelUtil;
import com.jsql.util.bruter.Base16;
import com.jsql.util.bruter.Base58;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Base32;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.binary.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.mozilla.universalchardet.UniversalDetector;

public final class StringUtil {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private static final CharEncoder DECIMAL_HTML_ENCODER = new CharEncoder("&#", ";", 10);

    private StringUtil() {
    }

    public static String decimalHtmlEncode(String text) {
        return StringUtil.decimalHtmlEncode(text, false);
    }

    public static String decimalHtmlEncode(String text, boolean isRaw) {
        String result = StringUtil.encode(text);
        if (isRaw) {
            return result.replace("<", "&lt;").replace(">", "&gt;").replace("&", "&amp;");
        }
        return result;
    }

    private static String encode(String text) {
        StringBuilder buff = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) > '\u0080') {
                DECIMAL_HTML_ENCODER.encode(text.charAt(i), buff);
                continue;
            }
            buff.append(text.charAt(i));
        }
        return buff.toString();
    }

    public static String hexstr(String hex) {
        byte[] bytes = new byte[hex.length() / 2];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)Integer.parseInt(hex.substring(2 * i, 2 * i + 2), 16);
        }
        return new String(bytes);
    }

    public static boolean isUtf8(String text) {
        if (text == null) {
            return false;
        }
        UniversalDetector detector = new UniversalDetector(null);
        detector.handleData(text.getBytes(), 0, text.length() - 1);
        detector.dataEnd();
        String encoding = detector.getDetectedCharset();
        return encoding != null;
    }

    public static String detectUtf8(String text) {
        if (text == null) {
            return "";
        }
        String encoding = null;
        try {
            UniversalDetector detector = new UniversalDetector(null);
            detector.handleData(text.getBytes(), 0, text.length() - 1);
            detector.dataEnd();
            encoding = detector.getDetectedCharset();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            LOGGER.log(LogLevelUtil.CONSOLE_JAVA, e, (Throwable)e);
        }
        String result = text;
        if (encoding != null) {
            result = new String(text.getBytes(), StandardCharsets.UTF_8);
        }
        return result;
    }

    public static String base32Encode(String s) {
        Base32 base32 = new Base32();
        return base32.encodeToString(StringUtils.getBytesUtf8(s));
    }

    public static String base32Decode(String s) {
        Base32 base32 = new Base32();
        return StringUtils.newStringUtf8(base32.decode(s));
    }

    public static String base58Encode(String s) {
        return Base58.encode(StringUtils.getBytesUtf8(s));
    }

    public static String base58Decode(String s) {
        return StringUtils.newStringUtf8(Base58.decode(s));
    }

    public static String base16Encode(String s) {
        Base16 base16 = new Base16();
        return base16.encodeToString(StringUtils.getBytesUtf8(s));
    }

    public static String base16Decode(String s) {
        Base16 base16 = new Base16();
        return StringUtils.newStringUtf8(base16.decode(s));
    }

    public static String base64Decode(String s) {
        return StringUtils.newStringUtf8(Base64.getDecoder().decode(s));
    }

    public static String base64Encode(String s) {
        return Base64.getEncoder().encodeToString(StringUtils.getBytesUtf8(s));
    }

    public static String compress(String str) throws IOException {
        if (org.apache.commons.lang3.StringUtils.isEmpty(str)) {
            return str;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        GZIPOutputStream gzip = new GZIPOutputStream(out);
        gzip.write(str.getBytes());
        gzip.close();
        return out.toString(StandardCharsets.ISO_8859_1);
    }

    public static String decompress(String str) throws IOException {
        int read;
        if (org.apache.commons.lang3.StringUtils.isEmpty(str)) {
            return str;
        }
        String encode = "ISO-8859-1";
        GZIPInputStream gis = new GZIPInputStream(new ByteArrayInputStream(str.getBytes("ISO-8859-1")));
        BufferedReader bf = new BufferedReader(new InputStreamReader((InputStream)gis, "ISO-8859-1"));
        char[] buff = new char[1024];
        StringBuilder response = new StringBuilder();
        while ((read = bf.read(buff)) != -1) {
            response.append(buff, 0, read);
        }
        return response.toString();
    }

    public static String toHex(String text) {
        return Hex.encodeHexString(text.getBytes(StandardCharsets.UTF_8)).trim();
    }

    public static String fromHex(String text) throws DecoderException {
        byte[] hex = Hex.decodeHex(text.toCharArray());
        return new String(hex, StandardCharsets.UTF_8);
    }

    public static String toHexZip(String text) throws IOException {
        byte[] zip = StringUtil.compress(text).getBytes(StandardCharsets.UTF_8);
        return Hex.encodeHexString(zip).trim();
    }

    public static String fromHexZip(String text) throws IOException, DecoderException {
        byte[] hex = Hex.decodeHex(text.toCharArray());
        String zip = new String(hex, StandardCharsets.UTF_8);
        return StringUtil.decompress(zip);
    }

    public static String toBase64Zip(String text) throws IOException {
        return StringUtil.base64Encode(StringUtil.compress(text));
    }

    public static String fromBase64Zip(String text) throws IOException {
        return StringUtil.decompress(StringUtil.base64Decode(text));
    }

    public static String toHtml(String text) {
        return StringEscapeUtils.escapeHtml4(text).replace("<", "&lt;").replace(">", "&gt;").replace("&", "&amp;");
    }

    public static String fromHtml(String text) {
        return StringEscapeUtils.unescapeHtml4(text).replace("<", "&lt;").replace(">", "&gt;");
    }

    public static String toUrl(String text) {
        return URLEncoder.encode(text, StandardCharsets.UTF_8);
    }

    public static String fromUrl(String text) {
        return URLDecoder.decode(text, StandardCharsets.UTF_8);
    }

    public static String clean(String query) {
        return query.replaceAll("(?s)(?!/\\*\\*/|/\\*!.*\\*/)/\\*.*?\\*/", "").replaceAll("(?s)([^\\s\\w])(\\s+)", "$1").replaceAll("(?s)(\\s+)([^\\s\\w])", "$2").replaceAll("(?s)\\s+", " ");
    }

    private static class CharEncoder {
        private final String prefix;
        private final String suffix;
        private final int radix;

        public CharEncoder(String prefix, String suffix, int radix) {
            this.prefix = prefix;
            this.suffix = suffix;
            this.radix = radix;
        }

        protected void encode(char c, StringBuilder buff) {
            buff.append(this.prefix).append(Integer.toString(c, this.radix)).append(this.suffix);
        }
    }
}

