/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.util;

import com.jsql.model.InjectionModel;
import com.jsql.util.LogLevelUtil;
import java.net.http.HttpRequest;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.jsoup.Jsoup;

public class CsrfUtil {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private AbstractMap.SimpleEntry<String, String> tokenCsrf = null;
    private static final String SET_COOKIE_RESPONSE = "set-cookie";
    private static final String INPUT_ATTR_VALUE = "value";
    private static final String MSG_ENABLE_CSRF = "Try with option CSRF processing enabled in preferences";
    private final InjectionModel injectionModel;

    public CsrfUtil(InjectionModel injectionModel) {
        this.injectionModel = injectionModel;
    }

    public void parseForCsrfToken(String pageSource, Map<String, String> headers) {
        this.parseCsrfFromCookie(headers);
        this.parseCsrfFromHtml(pageSource);
    }

    private void parseCsrfFromHtml(String pageSource) {
        Optional<AbstractMap.SimpleEntry> optionalTokenCsrf;
        ArrayList<String> tags = new ArrayList<String>(Arrays.asList("[name=_csrf]", "[name=_token]", "[name=csrf-token]", "[name=_csrf_header]", "[name=csrf_token]", "[name=csrfToken]", "[name=user_token]", "[name=csrfmiddlewaretoken]", "[name=form_build_id]"));
        if (this.injectionModel.getMediatorUtils().getPreferencesUtil().isCsrfUserTag()) {
            tags.add(String.format("[name=%s]", this.injectionModel.getMediatorUtils().getPreferencesUtil().csrfUserTag()));
        }
        if ((optionalTokenCsrf = Jsoup.parse(pageSource).select("input").select(String.join((CharSequence)",", tags)).stream().findFirst().map(input -> new AbstractMap.SimpleEntry<String, String>(input.attr("name"), input.attr(INPUT_ATTR_VALUE)))).isPresent()) {
            AbstractMap.SimpleEntry tokenCsrfFound = optionalTokenCsrf.get();
            Supplier[] supplierArray = new Supplier[2];
            supplierArray[0] = tokenCsrfFound::getKey;
            supplierArray[1] = tokenCsrfFound::getValue;
            LOGGER.log(LogLevelUtil.CONSOLE_INFORM, "Found Csrf token from HTML body: {}={}", supplierArray);
            if (!this.injectionModel.getMediatorUtils().getPreferencesUtil().isNotProcessingCookies() && this.injectionModel.getMediatorUtils().getPreferencesUtil().isProcessingCsrf()) {
                this.tokenCsrf = tokenCsrfFound;
                Supplier[] supplierArray2 = new Supplier[1];
                supplierArray2[0] = tokenCsrfFound::getValue;
                LOGGER.log(LogLevelUtil.CONSOLE_SUCCESS, "Csrf token added to query and header: {}", supplierArray2);
            } else {
                LOGGER.log(LogLevelUtil.CONSOLE_INFORM, MSG_ENABLE_CSRF);
            }
        }
    }

    private void parseCsrfFromCookie(Map<String, String> mapResponse) {
        Optional<Object> optionalCookieCsrf = Optional.empty();
        if (mapResponse.containsKey(SET_COOKIE_RESPONSE)) {
            String[] cookieValues = StringUtils.split(mapResponse.get(SET_COOKIE_RESPONSE), ";");
            optionalCookieCsrf = Stream.of(cookieValues).filter(cookie -> cookie.trim().toLowerCase().startsWith("xsrf-token")).map(cookie -> {
                String[] cookieEntry = StringUtils.split(cookie, "=");
                return new AbstractMap.SimpleEntry<String, String>(cookieEntry[0].trim(), cookieEntry[1].trim());
            }).findFirst();
        }
        if (optionalCookieCsrf.isPresent()) {
            AbstractMap.SimpleEntry cookieCsrf = (AbstractMap.SimpleEntry)optionalCookieCsrf.get();
            Supplier[] supplierArray = new Supplier[2];
            supplierArray[0] = cookieCsrf::getKey;
            supplierArray[1] = cookieCsrf::getValue;
            LOGGER.log(LogLevelUtil.CONSOLE_ERROR, "Found CSRF token from Cookie: {}={}", supplierArray);
            AbstractMap.SimpleEntry<String, String> headerCsrf = new AbstractMap.SimpleEntry<String, String>((String)cookieCsrf.getKey(), (String)cookieCsrf.getValue());
            if (!this.injectionModel.getMediatorUtils().getPreferencesUtil().isNotProcessingCookies() && this.injectionModel.getMediatorUtils().getPreferencesUtil().isProcessingCsrf()) {
                this.tokenCsrf = headerCsrf;
            } else {
                LOGGER.log(LogLevelUtil.CONSOLE_INFORM, MSG_ENABLE_CSRF);
            }
        }
    }

    public void addHeaderToken(HttpRequest.Builder httpRequest) {
        if (this.tokenCsrf == null) {
            return;
        }
        httpRequest.setHeader("X-XSRF-TOKEN", this.tokenCsrf.getValue());
        httpRequest.setHeader("X-CSRF-TOKEN", this.tokenCsrf.getValue());
        if (this.injectionModel.getMediatorUtils().getPreferencesUtil().isCsrfUserTag()) {
            httpRequest.setHeader(this.injectionModel.getMediatorUtils().getPreferencesUtil().csrfUserTagOutput(), this.tokenCsrf.getValue());
        }
    }

    public void addRequestToken(StringBuilder httpRequest) {
        if (this.tokenCsrf == null) {
            return;
        }
        httpRequest.append(String.format("%s=%s&", this.tokenCsrf.getKey(), this.tokenCsrf.getValue()));
        httpRequest.append(String.format("_csrf=%s&", this.tokenCsrf.getValue()));
        if (this.injectionModel.getMediatorUtils().getPreferencesUtil().isCsrfUserTag()) {
            httpRequest.append(String.format("%s=%s&", this.injectionModel.getMediatorUtils().getPreferencesUtil().csrfUserTagOutput(), this.tokenCsrf.getValue()));
        }
    }

    public String addQueryStringToken(String urlInjection) {
        Object urlInjectionFixed = urlInjection;
        if (this.tokenCsrf == null) {
            return urlInjectionFixed;
        }
        urlInjectionFixed = (String)urlInjectionFixed + String.format("&%s=%s", this.tokenCsrf.getKey(), this.tokenCsrf.getValue());
        urlInjectionFixed = (String)urlInjectionFixed + String.format("&_csrf=%s", this.tokenCsrf.getValue());
        if (this.injectionModel.getMediatorUtils().getPreferencesUtil().isCsrfUserTag()) {
            urlInjectionFixed = (String)urlInjectionFixed + String.format("&%s=%s", this.injectionModel.getMediatorUtils().getPreferencesUtil().csrfUserTagOutput(), this.tokenCsrf.getValue());
        }
        return urlInjectionFixed;
    }

    public boolean isCsrf() {
        return this.tokenCsrf != null;
    }

    public AbstractMap.SimpleEntry<String, String> getTokenCsrf() {
        return this.tokenCsrf;
    }

    public void setTokenCsrf(AbstractMap.SimpleEntry<String, String> tokenCsrf) {
        this.tokenCsrf = tokenCsrf;
    }
}

