/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.util;

import com.jsql.model.InjectionModel;
import com.jsql.model.exception.JSqlException;
import com.jsql.util.LogLevelUtil;
import java.util.AbstractMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;

public class CookiesUtil {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private final InjectionModel injectionModel;

    public CookiesUtil(InjectionModel injectionModel) {
        this.injectionModel = injectionModel;
    }

    public boolean testParameters() {
        String rawHeader = this.injectionModel.getMediatorUtils().getParameterUtil().getRawHeader();
        List cookies = this.injectionModel.getMediatorUtils().getParameterUtil().getListHeader().stream().filter(entry -> "cookie".equalsIgnoreCase((String)entry.getKey())).findFirst().map(cookieHeader -> ((String)cookieHeader.getValue()).split(";")).stream().flatMap(Stream::of).map(cookie -> cookie.split("=", 2)).map(arrayEntry -> new AbstractMap.SimpleEntry<String, String>(arrayEntry[0].trim(), arrayEntry[1] == null ? "\"\"" : arrayEntry[1].trim())).collect(Collectors.toList());
        for (AbstractMap.SimpleEntry cookie2 : cookies) {
            String headerCookieWithStar = rawHeader.replace((String)cookie2.getKey() + "=" + (String)cookie2.getValue(), (String)cookie2.getKey() + "=\"" + ((String)cookie2.getValue()).replaceAll("(^\\s*\")|(\"\\s*$)", "").replaceAll("(.+)\"(.+)", "$1\\\"$2") + "*\"");
            this.injectionModel.getMediatorUtils().getParameterUtil().initializeHeader(headerCookieWithStar);
            try {
                Supplier[] supplierArray = new Supplier[2];
                supplierArray[0] = cookie2::getKey;
                supplierArray[1] = () -> ((String)cookie2.getValue()).replace("*", "");
                LOGGER.log(LogLevelUtil.CONSOLE_DEFAULT, "Checking cookie {}={}", supplierArray);
                if (!this.injectionModel.getMediatorMethod().getHeader().testParameters()) continue;
                return true;
            }
            catch (JSqlException e) {
                LOGGER.log(LogLevelUtil.CONSOLE_ERROR, String.format("No Cookie injection for %s=%s", cookie2.getKey(), ((String)cookie2.getValue()).replace("*", "")));
            }
        }
        return false;
    }
}

